/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.equinox.requirements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Map;
import org.eclipse.passage.lic.api.LicensingConfiguration;
import org.eclipse.passage.lic.api.requirements.LicensingRequirement;
import org.eclipse.passage.lic.api.requirements.RequirementResolver;
import org.eclipse.passage.lic.base.LicensingProperties;
import org.eclipse.passage.lic.base.requirements.LicensingRequirements;
import org.eclipse.passage.lic.internal.equinox.i18n.EquinoxMessages;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;
import org.osgi.service.log.Logger;
import org.osgi.service.log.LoggerFactory;

@Deprecated
@Component
public class ComponentConfigurationResolver
implements RequirementResolver {
    private Logger logger;
    private BundleContext bundleContext;
    private ServiceComponentRuntime scr;

    @Reference
    public void bindLoggerFactory(LoggerFactory factory) {
        this.logger = factory.getLogger(ComponentConfigurationResolver.class);
    }

    public void unbindLoggerFactory(LoggerFactory factory) {
        if (this.logger == factory) {
            this.logger = null;
        }
    }

    @Reference
    public void bindScr(ServiceComponentRuntime runtime) {
        this.scr = runtime;
    }

    public void unbindScr(ServiceComponentRuntime runtime) {
        if (this.scr == runtime) {
            this.scr = null;
        }
    }

    @Activate
    public void activate(BundleContext context) {
        this.bundleContext = context;
    }

    @Deactivate
    public void deactivate() {
        this.bundleContext = null;
    }

    public Iterable<LicensingRequirement> resolveLicensingRequirements(LicensingConfiguration configuration) {
        String nameLicensing = LicensingProperties.LICENSING_FEATURE_NAME_DEFAULT;
        String providerLicensing = LicensingProperties.LICENSING_FEATURE_PROVIDER_DEFAULT;
        if (this.scr == null) {
            this.logger.error(EquinoxMessages.ComponentConfigurationResolver_error_invalid_component_rt);
            return LicensingRequirements.createErrorIterable((String)"licensing.management", (String)"0.0.0", (String)nameLicensing, (String)providerLicensing, (Object)configuration);
        }
        if (this.bundleContext == null) {
            this.logger.error(EquinoxMessages.ComponentConfigurationResolver_error_invalid_bundle_context);
            return LicensingRequirements.createErrorIterable((String)"licensing.management", (String)"0.0.0", (String)nameLicensing, (String)providerLicensing, (Object)configuration);
        }
        ArrayList<LicensingRequirement> result = new ArrayList<LicensingRequirement>();
        Bundle[] bundles = this.bundleContext.getBundles();
        Collection components = this.scr.getComponentDescriptionDTOs(bundles);
        for (ComponentDescriptionDTO component : components) {
            Dictionary headers = this.bundleContext.getBundle(component.bundle.id).getHeaders();
            Map properties = component.properties;
            if (!properties.containsKey("licensing.feature.identifier")) continue;
            result.add(LicensingRequirements.extractFromProperties((String)((String)headers.get("Bundle-Name")), (String)((String)headers.get("Bundle-Vendor")), (Map)properties, (Object)component));
        }
        return result;
    }
}

