/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.hc;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.eclipse.passage.lic.api.LicensingConfiguration;
import org.eclipse.passage.lic.api.conditions.ConditionMiner;
import org.eclipse.passage.lic.api.conditions.ConditionTransport;
import org.eclipse.passage.lic.api.conditions.LicensingCondition;
import org.eclipse.passage.lic.base.conditions.BaseConditionMiner;
import org.eclipse.passage.lic.equinox.io.EquinoxPaths;
import org.eclipse.passage.lic.hc.HttpRequests;
import org.eclipse.passage.lic.internal.hc.i18n.HcMessages;
import org.osgi.service.component.annotations.Component;

@Component(service={ConditionMiner.class})
public class HcConditionMiner
extends BaseConditionMiner {
    private static final String HOST_PORT = "%s:%s";
    private static final String SETTINGS_EXTENSION = ".settings";
    private final Map<String, String> settingsMap = new HashMap<String, String>();
    Logger logger = Logger.getLogger(HcConditionMiner.class.getName());

    public Iterable<LicensingCondition> extractLicensingConditions(LicensingConfiguration configuration) {
        ArrayList<LicensingCondition> conditions = new ArrayList<LicensingCondition>();
        Path configurationPath = EquinoxPaths.resolveInstallConfigurationPath((LicensingConfiguration)configuration);
        if (!Files.isDirectory(configurationPath, new LinkOption[0])) {
            return conditions;
        }
        final ArrayList settinsFiles = new ArrayList();
        try {
            Files.walkFileTree(configurationPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.toString().toLowerCase().endsWith(HcConditionMiner.SETTINGS_EXTENSION)) {
                        settinsFiles.add(file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            this.logger.log(Level.FINEST, e.getMessage(), e);
        }
        for (Path path : settinsFiles) {
            try {
                Map<String, String> loadedSettings = this.loadIstallationAreaSettings(Files.readAllLines(path));
                this.settingsMap.putAll(loadedSettings);
            }
            catch (Exception e) {
                this.logger.log(Level.FINEST, e.getMessage(), e);
            }
        }
        try {
            String hostValue = this.settingsMap.get("licensing.server.host");
            if (hostValue == null || hostValue.isEmpty()) {
                this.logger.log(Level.FINEST, HcMessages.HcConditionMiner_e_host_invalid);
                return conditions;
            }
            String portValue = this.settingsMap.get("licensing.server.port");
            if (portValue == null || portValue.isEmpty()) {
                this.logger.log(Level.FINEST, HcMessages.HcConditionMiner_e_port_invalid);
                return conditions;
            }
            String location = String.format(HOST_PORT, hostValue, portValue);
            String productId = "product.1";
            String productVersion = "1.0.0";
            Map<String, String> requestAttributes = HttpRequests.initRequestParams(hostValue, portValue, "role", productId, productVersion);
            HttpHost host = HttpHost.create((String)location);
            URIBuilder requestBulder = HttpRequests.createRequestURI(requestAttributes, "acquire");
            if (requestBulder == null) {
                this.logger.log(Level.FINEST, "Could not create URI for request");
                return conditions;
            }
            HttpPost httpPost = new HttpPost(requestBulder.build());
            ResponseHandler<Iterable<LicensingCondition>> responseHandler = new ResponseHandler<Iterable<LicensingCondition>>(){

                public Iterable<LicensingCondition> handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                    Header header = response.getEntity().getContentType();
                    String contentType = header.getValue();
                    HttpEntity entity = response.getEntity();
                    if (entity != null && entity.getContent() != null) {
                        ConditionTransport transport = (ConditionTransport)HcConditionMiner.this.conditionTransports.get(contentType);
                        Iterable conditionDescriptors = transport.readConditions(entity.getContent());
                        return conditionDescriptors;
                    }
                    HcConditionMiner.this.logger.log(Level.FINE, "Could not receive an InputStream from request");
                    return null;
                }
            };
            Throwable throwable = null;
            Object var16_20 = null;
            try (CloseableHttpClient httpClient = HttpClients.createDefault();){
                httpClient.execute(host, (HttpRequest)httpPost, (ResponseHandler)responseHandler);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.logger.log(Level.FINER, e.getMessage());
        }
        return conditions;
    }

    private Map<String, String> loadIstallationAreaSettings(List<String> readAllLines) {
        HashMap<String, String> settings = new HashMap<String, String>();
        for (String iter : readAllLines) {
            String[] setting = iter.split("=");
            if (setting.length != 2) continue;
            settings.put(setting[0], setting[1]);
        }
        return settings;
    }

    protected String getBaseLocation() {
        String underfined = "";
        String hostValue = this.settingsMap.getOrDefault("licensing.server.host", underfined);
        String portValue = this.settingsMap.getOrDefault("licensing.server.port", underfined);
        if (underfined.equals(hostValue) || underfined.equals(portValue)) {
            return underfined;
        }
        return String.format(HOST_PORT, hostValue, portValue);
    }
}

