/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.conditions;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.passage.lic.api.LicensingConfiguration;
import org.eclipse.passage.lic.api.LicensingException;
import org.eclipse.passage.lic.api.LicensingResult;
import org.eclipse.passage.lic.api.conditions.ConditionTransport;
import org.eclipse.passage.lic.api.conditions.LicensingCondition;
import org.eclipse.passage.lic.api.io.KeyKeeper;
import org.eclipse.passage.lic.api.io.StreamCodec;
import org.eclipse.passage.lic.base.LicensingResults;
import org.eclipse.passage.lic.base.conditions.BaseConditionMiner;
import org.eclipse.passage.lic.base.conditions.ConditionMiners;
import org.eclipse.passage.lic.base.io.LicensingPaths;
import org.eclipse.passage.lic.base.io.NullKeyKeeper;
import org.eclipse.passage.lic.base.io.NullStreamCodec;
import org.eclipse.passage.lic.internal.base.i18n.BaseMessages;

public abstract class PathConditionMiner
extends BaseConditionMiner {
    public final Iterable<LicensingCondition> extractLicensingConditions(LicensingConfiguration configuration) {
        String source = this.getClass().getName();
        ArrayList<LicensingCondition> mined = new ArrayList<LicensingCondition>();
        if (configuration == null) {
            return mined;
        }
        ConditionTransport transport = (ConditionTransport)this.conditionTransports.get("application/xml");
        if (transport == null) {
            return mined;
        }
        Path from = this.getBasePath();
        Path configurationPath = LicensingPaths.resolveConfigurationPath(from, configuration);
        if (!Files.isDirectory(configurationPath, new LinkOption[0])) {
            String message = String.format(BaseMessages.getString("PathConditionMiner.e_not_a_directory"), configurationPath);
            this.licensingReporter.logResult(LicensingResults.createError(message, source));
            return mined;
        }
        if (this.keyKeeperRegistry == null) {
            this.licensingReporter.logResult(LicensingResults.createError(BaseMessages.getString("PathConditionMiner.e_no_key_keeper_registry"), source));
            return mined;
        }
        KeyKeeper keyKeeper = this.keyKeeperRegistry.getKeyKeeper(configuration);
        if (this.streamCodecRegistry == null) {
            this.licensingReporter.logResult(LicensingResults.createError(BaseMessages.getString("PathConditionMiner.e_no_stream_codec_registry"), source));
            return mined;
        }
        StreamCodec streamCodec = this.streamCodecRegistry.getStreamCodec(configuration);
        String extension = NullKeyKeeper.INSTANCE == keyKeeper && NullStreamCodec.INSTANCE == streamCodec ? ".lic" : ".licen";
        try {
            List<String> packs = ConditionMiners.collectPacks(configurationPath, extension);
            LicensingResult result = ConditionMiners.mine(source, configuration, mined, keyKeeper, streamCodec, transport, packs);
            this.licensingReporter.logResult(result);
        }
        catch (LicensingException e) {
            this.licensingReporter.logResult(e.getResult());
        }
        return mined;
    }

    protected abstract Path getBasePath();

    @Override
    protected String getBaseLocation() {
        return this.getBasePath().toString();
    }
}

