/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.jface.viewers;

import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.passage.lic.api.restrictions.RestrictionVerdict;
import org.eclipse.passage.lic.base.restrictions.RestrictionVerdicts;
import org.eclipse.passage.lic.equinox.LicensingEquinox;
import org.eclipse.passage.lic.jface.resource.LicensingColors;
import org.eclipse.passage.lic.jface.viewers.BaseRestrictionRepresenter;
import org.eclipse.passage.lic.jface.viewers.RestrictionRepresenter;
import org.eclipse.swt.graphics.RGB;

public class RestrictionRepresenters {
    public static String resolveImageKey(Iterable<RestrictionVerdict> verdicts) {
        RestrictionVerdict last = RestrictionVerdicts.resolveLastVerdict(verdicts);
        return RestrictionRepresenters.resolveImageKey(last);
    }

    public static String resolveImageKey(RestrictionVerdict verdict) {
        if (verdict == null) {
            return "IMG_LEVEL_OK";
        }
        return RestrictionRepresenters.resolveImageKey(verdict.getRestrictionLevel());
    }

    public static String resolveImageKey(String level) {
        String restriction = level;
        if (restriction == null) {
            restriction = "warn";
        }
        switch (restriction) {
            case "info": {
                return "IMG_LEVEL_INFO";
            }
            case "warn": {
                return "IMG_LEVEL_WARN";
            }
            case "error": {
                return "IMG_LEVEL_ERROR";
            }
            case "fatal": {
                return "IMG_LEVEL_FATAL";
            }
        }
        return "IMG_LEVEL_WARN";
    }

    public static String resolveColorKey(String level) {
        String restriction = level;
        if (restriction == null) {
            restriction = "warn";
        }
        switch (restriction) {
            case "info": {
                return "COLOR_LEVEL_INFO";
            }
            case "warn": {
                return "COLOR_LEVEL_WARN";
            }
            case "error": {
                return "COLOR_LEVEL_ERROR";
            }
            case "fatal": {
                return "COLOR_LEVEL_FATAL";
            }
        }
        return "COLOR_LEVEL_WARN";
    }

    public static RGB resolveRGB(Iterable<RestrictionVerdict> verdicts) {
        RestrictionVerdict last = RestrictionVerdicts.resolveLastVerdict(verdicts);
        return RestrictionRepresenters.resolveRGB(last);
    }

    public static RGB resolveRGB(RestrictionVerdict verdict) {
        if (verdict == null) {
            return LicensingColors.RGB_LEVEL_OK;
        }
        return RestrictionRepresenters.resolveRGB(verdict.getRestrictionLevel());
    }

    public static RGB resolveRGB(String level) {
        String restriction = level;
        if (restriction == null) {
            restriction = "warn";
        }
        ColorRegistry colorRegistry = LicensingColors.getColorRegistry();
        switch (restriction) {
            case "info": {
                return colorRegistry.get("COLOR_LEVEL_INFO").getRGB();
            }
            case "warn": {
                return colorRegistry.get("COLOR_LEVEL_WARN").getRGB();
            }
            case "error": {
                return colorRegistry.get("COLOR_LEVEL_ERROR").getRGB();
            }
            case "fatal": {
                return colorRegistry.get("COLOR_LEVEL_FATAL").getRGB();
            }
        }
        return colorRegistry.get("COLOR_LEVEL_WARN").getRGB();
    }

    public static String resolveSummary(Iterable<RestrictionVerdict> verdicts) {
        RestrictionRepresenter representer = (RestrictionRepresenter)LicensingEquinox.getLicensingService(RestrictionRepresenter.class);
        if (representer == null) {
            representer = new BaseRestrictionRepresenter();
        }
        return representer.getSummary(verdicts);
    }

    public static String resolveSummary(RestrictionVerdict verdict) {
        RestrictionRepresenter representer = (RestrictionRepresenter)LicensingEquinox.getLicensingService(RestrictionRepresenter.class);
        if (representer == null) {
            representer = new BaseRestrictionRepresenter();
        }
        return representer.getSummary(verdict);
    }
}

