/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.workbench;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.passage.lic.emf.ecore.EditingDomainRegistry;
import org.eclipse.passage.lic.emf.edit.ClassifierInitializer;
import org.eclipse.passage.lic.emf.edit.EditingDomainRegistryAccess;
import org.eclipse.passage.lic.emf.edit.SelectionCommandAdvisor;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class LocDomainRegistryAccess
implements EditingDomainRegistryAccess {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, EditingDomainRegistry<?>> domainRegistries = new HashMap();
    private final Map<String, String> fileExtensions = new HashMap<String, String>();
    private final Map<String, ClassifierInitializer> classifierInitializers = new HashMap<String, ClassifierInitializer>();
    private final Map<String, SelectionCommandAdvisor> selectionAdvisors = new HashMap<String, SelectionCommandAdvisor>();

    @Reference(cardinality=ReferenceCardinality.MULTIPLE)
    public void registerEditingDomainRegistry(EditingDomainRegistry<?> instance, Map<String, Object> properties) {
        String domain = String.valueOf(properties.get("org.eclipse.passage.lic.emf.edit.domain.name"));
        this.registerEntry(this.domainRegistries, domain, instance);
        String extension = String.valueOf(properties.get("org.eclipse.passage.lic.emf.edit.file.extension"));
        this.registerEntry(this.fileExtensions, domain, extension);
    }

    public void unregisterEditingDomainRegistry(EditingDomainRegistry<?> instance, Map<String, Object> properties) {
        String domain = String.valueOf(properties.get("org.eclipse.passage.lic.emf.edit.domain.name"));
        this.unregisterEntry(this.domainRegistries, domain, instance);
        String extension = String.valueOf(properties.get("org.eclipse.passage.lic.emf.edit.file.extension"));
        this.unregisterEntry(this.fileExtensions, domain, extension);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE)
    public void registerClassifierInitializer(ClassifierInitializer instance, Map<String, Object> properties) {
        String domain = String.valueOf(properties.get("org.eclipse.passage.lic.emf.edit.domain.name"));
        this.registerEntry(this.classifierInitializers, domain, instance);
    }

    public void unregisterClassifierInitializer(ClassifierInitializer instance, Map<String, Object> properties) {
        String domain = String.valueOf(properties.get("org.eclipse.passage.lic.emf.edit.domain.name"));
        this.unregisterEntry(this.classifierInitializers, domain, instance);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE)
    public void registerCommandAdvisor(SelectionCommandAdvisor instance, Map<String, Object> properties) {
        String domain = String.valueOf(properties.get("org.eclipse.passage.lic.emf.edit.domain.name"));
        this.registerEntry(this.selectionAdvisors, domain, instance);
    }

    public void unregisterCommandAdvisor(SelectionCommandAdvisor instance, Map<String, Object> properties) {
        String domain = String.valueOf(properties.get("org.eclipse.passage.lic.emf.edit.domain.name"));
        this.unregisterEntry(this.selectionAdvisors, domain, instance);
    }

    protected <K, V> void registerEntry(Map<K, V> map, K key, V value) {
        V existing = map.put(key, value);
        if (existing != null) {
            this.logger.warn("Replaced {} for domain {}", existing, key);
        }
        this.logger.trace("Registered {} for domain {}", value, key);
    }

    protected <K, V> void unregisterEntry(Map<K, V> map, K key, V value) {
        V existing = map.remove(key);
        if (existing == null) {
            this.logger.warn("Unexpected null (should be {}) for domain {}", value, key);
        }
        this.logger.trace("Unregistered {} for domain {}", existing, key);
    }

    public EditingDomainRegistry<?> getDomainRegistry(String domain) {
        return this.domainRegistries.get(domain);
    }

    public String getFileExtension(String domain) {
        return this.fileExtensions.get(domain);
    }

    public ClassifierInitializer getClassifierInitializer(String domain) {
        return this.classifierInitializers.get(domain);
    }

    public SelectionCommandAdvisor getSelectionCommandAdvisor(String domain) {
        return this.selectionAdvisors.get(domain);
    }
}

