/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.equinox;

import java.util.Collection;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.passage.lic.api.LicensingConfiguration;
import org.eclipse.passage.lic.base.LicensingConfigurations;
import org.eclipse.passage.lic.internal.equinox.i18n.EquinoxMessages;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

public class ApplicationConfigurations {
    public static String findProductIdentifier(String[] args) {
        if (args == null) {
            return null;
        }
        int i = 0;
        while (i < args.length) {
            int index;
            String arg = args[i];
            if ("-product".equals(arg) && (index = i + 1) < args.length) {
                return args[index];
            }
            ++i;
        }
        return null;
    }

    public static IApplicationContext getApplicationContext() {
        Collection references;
        Bundle bundle = FrameworkUtil.getBundle(ApplicationConfigurations.class);
        if (bundle == null) {
            return null;
        }
        BundleContext context = bundle.getBundleContext();
        try {
            references = context.getServiceReferences(IApplicationContext.class, "(eclipse.application.type=main.thread)");
        }
        catch (InvalidSyntaxException e) {
            return null;
        }
        if (references == null || references.isEmpty()) {
            return null;
        }
        ServiceReference firstRef = (ServiceReference)references.iterator().next();
        IApplicationContext result = (IApplicationContext)context.getService(firstRef);
        if (result != null) {
            context.ungetService(firstRef);
            return result;
        }
        return null;
    }

    public static LicensingConfiguration getLicensingConfiguration() {
        IApplicationContext applicationContext = ApplicationConfigurations.getApplicationContext();
        return ApplicationConfigurations.getLicensingConfiguration(applicationContext);
    }

    public static LicensingConfiguration getLicensingConfiguration(IApplicationContext application) {
        if (application == null) {
            return LicensingConfigurations.INVALID;
        }
        String productId = ApplicationConfigurations.getLicensingProductIdentifier(application);
        String productVersion = ApplicationConfigurations.getLicensingProductVersion(application);
        LicensingConfiguration configuration = LicensingConfigurations.create((String)productId, (String)productVersion);
        return configuration;
    }

    public static String getLicensingProductIdentifier(IApplicationContext application) {
        if (application == null) {
            return LicensingConfigurations.INVALID.getProductIdentifier();
        }
        String property = application.getBrandingProperty("licensing.product.identifier");
        if (property != null) {
            return property;
        }
        return application.getBrandingId();
    }

    public static String getLicensingContacts() {
        return ApplicationConfigurations.getLicensingContacts(ApplicationConfigurations.getApplicationContext());
    }

    public static String getLicensingContacts(IApplicationContext application) {
        String contantDefaults = EquinoxMessages.ApplicationConfigurations_contact_defaults;
        if (application == null) {
            return contantDefaults;
        }
        String contant = application.getBrandingProperty("licensing.product.contacts");
        if (contant == null) {
            return contantDefaults;
        }
        return contant;
    }

    public static String getLicensingProductVersion(IApplicationContext application) {
        if (application == null) {
            return LicensingConfigurations.INVALID.getProductVersion();
        }
        String property = application.getBrandingProperty("licensing.product.version");
        if (property != null) {
            return property;
        }
        Bundle brandingBundle = application.getBrandingBundle();
        if (brandingBundle != null) {
            Version version = brandingBundle.getVersion();
            StringBuilder sb = new StringBuilder();
            sb.append(version.getMajor()).append('.');
            sb.append(version.getMinor()).append('.');
            sb.append(version.getMicro());
            return sb.toString();
        }
        return "0.0.0";
    }
}

