/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.eclipse.passage.lic.api.access.FeaturePermission;
import org.eclipse.passage.lic.api.access.PermissionTransport;
import org.eclipse.passage.lic.internal.json.FeaturePermissionAggregator;
import org.eclipse.passage.lic.internal.json.JsonTransport;
import org.osgi.service.component.annotations.Component;

@Component(property={"licensing.content.type=application/json"})
public class JsonPermissionTransport
implements PermissionTransport {
    public Iterable<FeaturePermission> readPermissions(InputStream input) throws IOException {
        ArrayList<FeaturePermission> descriptors = new ArrayList<FeaturePermission>();
        ObjectMapper mapper = JsonTransport.createObjectMapper();
        FeaturePermissionAggregator transfer = (FeaturePermissionAggregator)mapper.readValue(input, FeaturePermissionAggregator.class);
        transfer.getFeaturePermissions().forEach(descriptors::add);
        return descriptors;
    }

    public void writePermissions(Iterable<FeaturePermission> permissions, OutputStream output) throws IOException {
        if (permissions == null) {
            return;
        }
        FeaturePermissionAggregator aggregator = new FeaturePermissionAggregator();
        for (FeaturePermission permission : permissions) {
            aggregator.addFeaturePermission(permission);
        }
        ObjectMapper mapper = JsonTransport.createObjectMapper();
        output.write(mapper.writeValueAsBytes((Object)aggregator));
    }
}

