/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.requirements;

import java.util.Collections;
import java.util.Map;
import org.eclipse.passage.lic.api.requirements.LicensingRequirement;
import org.eclipse.passage.lic.base.LicensingNamespaces;
import org.eclipse.passage.lic.base.LicensingProperties;
import org.eclipse.passage.lic.base.LicensingVersions;
import org.eclipse.passage.lic.base.requirements.BaseLicensingRequirement;

public class LicensingRequirements {
    private LicensingRequirements() {
    }

    public static LicensingRequirement extractFromCapability(String bundleName, String bundleVendor, Map<String, Object> attributes, Map<String, String> directives, Object source) {
        if (attributes == null) {
            return null;
        }
        Object feature = attributes.get("licensing.feature");
        if (feature instanceof String) {
            String featureId = (String)feature;
            String version = LicensingVersions.toVersionValue(attributes.get("version"));
            String name = LicensingRequirements.getStringValue(attributes, "name", bundleName);
            if (name == null) {
                name = featureId;
            }
            String provider = LicensingRequirements.getStringValue(attributes, "provider", bundleVendor);
            String level = LicensingNamespaces.toLevelAttribute(attributes.get("level"));
            return new BaseLicensingRequirement(featureId, version, name, provider, level, source);
        }
        return null;
    }

    public static LicensingRequirement extractFromProperties(String bundleName, String bundleVendor, Map<String, Object> properties, Object source) {
        if (properties == null) {
            return null;
        }
        Object feature = properties.get("licensing.feature.identifier");
        if (feature instanceof String) {
            String provider;
            String featureId = (String)feature;
            String version = LicensingVersions.toVersionValue(properties.get("licensing.feature.version"));
            String name = LicensingRequirements.getStringValue(properties, "licensing.feature.name", bundleName);
            if (name == null) {
                name = featureId;
            }
            if ((provider = LicensingRequirements.getStringValue(properties, "licensing.feature.provider", bundleVendor)) == null) {
                provider = "";
            }
            String level = LicensingProperties.toRestrictionLevelProperty(properties.get("licensing.restriction.level"));
            return new BaseLicensingRequirement(featureId, version, name, provider, level, source);
        }
        return null;
    }

    public static LicensingRequirement createConfigurationError(String featureId, Object source) {
        String name = LicensingProperties.LICENSING_FEATURE_NAME_DEFAULT;
        String provider = LicensingProperties.LICENSING_FEATURE_PROVIDER_DEFAULT;
        return LicensingRequirements.createConfigurationError(featureId, name, provider, source);
    }

    public static LicensingRequirement createConfigurationError(String featureId, String name, String provider, Object source) {
        String policy = "error";
        String version = "0.0.0";
        return new BaseLicensingRequirement(featureId, version, name, provider, policy, source);
    }

    public static LicensingRequirement createError(String featureId, String version, String name, String provider, Object source) {
        String policy = "error";
        return new BaseLicensingRequirement(featureId, version, name, provider, policy, source);
    }

    public static Iterable<LicensingRequirement> createErrorIterable(String featureId, String version, String name, String provider, Object source) {
        return Collections.singletonList(LicensingRequirements.createError(featureId, version, name, provider, source));
    }

    public static LicensingRequirement createDefault(String featureId, String version, String name, String provider, Object source) {
        String policy = "warn";
        return new BaseLicensingRequirement(featureId, version, name, provider, policy, source);
    }

    private static String getStringValue(Map<String, Object> map, String key, String empty) {
        Object object = map.get(key);
        if (object instanceof String) {
            return (String)object;
        }
        return empty;
    }
}

