/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.jface.resource;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.osgi.service.prefs.BackingStoreException;

public class LicensingColors {
    public static final String COLOR_LEVEL_OK = "COLOR_LEVEL_OK";
    public static final String COLOR_LEVEL_INFO = "COLOR_LEVEL_INFO";
    public static final String COLOR_LEVEL_WARN = "COLOR_LEVEL_WARN";
    public static final String COLOR_LEVEL_ERROR = "COLOR_LEVEL_ERROR";
    public static final String COLOR_LEVEL_FATAL = "COLOR_LEVEL_FATAL";
    public static final RGB RGB_LEVEL_OK = new RGB(0, 128, 0);
    public static final RGB RGB_LEVEL_INFO = new RGB(0, 0, 255);
    public static final RGB RGB_LEVEL_WARN = new RGB(255, 255, 0);
    public static final RGB RGB_LEVEL_ERROR = new RGB(255, 0, 0);
    public static final RGB RGB_LEVEL_FATAL = new RGB(128, 0, 0);
    private static final String BUNDLE_ID = "org.eclipse.passage.lic.jface";
    private static ColorRegistry colorRegistry = null;
    private static Map<String, RGB> colorToRgb = new HashMap<String, RGB>();
    private static IScopeContext[] context;

    static {
        colorToRgb.put(COLOR_LEVEL_OK, RGB_LEVEL_OK);
        colorToRgb.put(COLOR_LEVEL_INFO, RGB_LEVEL_INFO);
        colorToRgb.put(COLOR_LEVEL_WARN, RGB_LEVEL_WARN);
        colorToRgb.put(COLOR_LEVEL_ERROR, RGB_LEVEL_ERROR);
        colorToRgb.put(COLOR_LEVEL_FATAL, RGB_LEVEL_FATAL);
        context = new IScopeContext[]{DefaultScope.INSTANCE, InstanceScope.INSTANCE};
    }

    public static Color getColor(String key) {
        return LicensingColors.getColorRegistry().get(key);
    }

    public static ColorDescriptor getColorDescriptor(String key) {
        return LicensingColors.getColorRegistry().getColorDescriptor(key);
    }

    public static ColorRegistry getColorRegistry() {
        if (colorRegistry == null) {
            colorRegistry = new ColorRegistry(Display.getCurrent());
            LicensingColors.initializeDefaultColors();
            LicensingColors.loadColors();
        }
        return colorRegistry;
    }

    private static void initializeDefaultColors() {
        LicensingColors.declareColors(LicensingColors.class, colorToRgb);
    }

    public static IStatus declareColors(Class<?> location, Map<String, RGB> rgbs) {
        ColorRegistry registry = LicensingColors.getColorRegistry();
        Set<Map.Entry<String, RGB>> entries = rgbs.entrySet();
        for (Map.Entry<String, RGB> entry : entries) {
            String key = entry.getKey();
            RGB rgb = entry.getValue();
            registry.put(key, rgb);
        }
        return Status.OK_STATUS;
    }

    public static IStatus storeColors() {
        IEclipsePreferences node = LicensingColors.getPreferences();
        if (node == null) {
            return Status.CANCEL_STATUS;
        }
        ColorRegistry registry = LicensingColors.getColorRegistry();
        for (String colorKey : registry.getKeySet()) {
            RGB rgb = registry.getRGB(colorKey);
            node.put(colorKey, rgb.toString());
        }
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    public static IStatus loadColors() {
        ColorRegistry registry = LicensingColors.getColorRegistry();
        for (String colorKey : registry.getKeySet()) {
            String storedValue = LicensingColors.getLicensingColor(colorKey);
            if (storedValue == null || storedValue.isEmpty()) continue;
            registry.put(colorKey, LicensingColors.stringToRgb(storedValue));
        }
        return Status.OK_STATUS;
    }

    private static RGB stringToRgb(String storedValue) {
        String pattern = "\\d{1,3}";
        Matcher matcher = Pattern.compile(pattern).matcher(storedValue);
        int red = 255;
        int green = 255;
        int blue = 255;
        try {
            if (matcher.find()) {
                red = Integer.valueOf(matcher.group(0));
            }
            if (matcher.find()) {
                green = Integer.valueOf(matcher.group(0));
            }
            if (matcher.find()) {
                blue = Integer.valueOf(matcher.group(0));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return new RGB(red, green, blue);
    }

    public static IStatus acceptColors(Map<String, RGB> colors) {
        ColorRegistry registry = LicensingColors.getColorRegistry();
        for (Map.Entry<String, RGB> color : colors.entrySet()) {
            registry.put(color.getKey(), color.getValue());
        }
        if (!colors.isEmpty()) {
            return LicensingColors.storeColors();
        }
        return Status.OK_STATUS;
    }

    public static String getLicensingColor(String colorKey) {
        String colorDefault = "";
        if (colorToRgb.containsKey(colorKey)) {
            colorDefault = colorToRgb.get(colorKey).toString();
        }
        return Platform.getPreferencesService().getString(BUNDLE_ID, colorKey, colorDefault, context);
    }

    public static IEclipsePreferences getPreferences() {
        return InstanceScope.INSTANCE.getNode(BUNDLE_ID);
    }
}

