/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.equinox;

import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.passage.lic.equinox.LicensingEquinox;
import org.eclipse.passage.lic.internal.equinox.EquinoxEvents;
import org.eclipse.passage.lic.runtime.LicensingReporter;
import org.eclipse.passage.lic.runtime.LicensingResult;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

@Component
public class EquinoxLicensingReporter
implements LicensingReporter {
    private EventAdmin eventAdmin;

    @Reference
    public void bindEventAdmin(EventAdmin admin) {
        this.eventAdmin = admin;
    }

    public void unbindEventAdmin(EventAdmin admin) {
        this.eventAdmin = admin;
    }

    public void logResult(LicensingResult result) {
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        ILog log = Platform.getLog((Bundle)bundle);
        IStatus status = LicensingEquinox.toStatus(result);
        log.log(status);
    }

    public void postResult(LicensingResult result) {
        Event event = EquinoxEvents.extractEvent(result);
        if (event != null) {
            this.eventAdmin.postEvent(event);
        } else {
            this.logResult(result);
        }
    }

    public void sendResult(LicensingResult result) {
        Event event = EquinoxEvents.extractEvent(result);
        if (event != null) {
            this.eventAdmin.sendEvent(event);
        } else {
            this.logResult(result);
        }
    }
}

