/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.conditions;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.passage.lic.base.LicensingResults;
import org.eclipse.passage.lic.runtime.LicensingConfiguration;
import org.eclipse.passage.lic.runtime.LicensingException;
import org.eclipse.passage.lic.runtime.LicensingResult;
import org.eclipse.passage.lic.runtime.conditions.ConditionTransport;
import org.eclipse.passage.lic.runtime.conditions.LicensingCondition;
import org.eclipse.passage.lic.runtime.io.KeyKeeper;
import org.eclipse.passage.lic.runtime.io.StreamCodec;

public class ConditionMiners {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LicensingResult mine(String source, LicensingConfiguration configuration, List<LicensingCondition> mined, KeyKeeper keyKeeper, StreamCodec streamCodec, ConditionTransport transport, Iterable<String> packs) {
        String task = String.format("Mined licensing conditions for configuration: %s (%s)", configuration.getProductIdentifier(), configuration.getProductVersion());
        ArrayList<LicensingResult> errors = new ArrayList<LicensingResult>();
        Iterator<String> iterator = packs.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                if (!errors.isEmpty()) return LicensingResults.createError(task, source, errors);
                return LicensingResults.createOK(task, source);
            }
            String path = iterator.next();
            try {
                Throwable throwable = null;
                Object var12_14 = null;
                try {
                    FileInputStream encoded = new FileInputStream(path);
                    try {
                        block30: {
                            ByteArrayOutputStream decoded = new ByteArrayOutputStream();
                            try {
                                try (InputStream keyRing = keyKeeper.openKeyStream(configuration);){
                                    streamCodec.decodeStream((InputStream)encoded, (OutputStream)decoded, keyRing, null);
                                    byte[] byteArray = decoded.toByteArray();
                                    Throwable throwable2 = null;
                                    Object var18_24 = null;
                                    try (ByteArrayInputStream input = new ByteArrayInputStream(byteArray);){
                                        Iterable extracted = transport.readConditions((InputStream)input);
                                        for (LicensingCondition condition : extracted) {
                                            mined.add(condition);
                                        }
                                    }
                                    catch (Throwable throwable3) {
                                        if (throwable2 == null) {
                                            throwable2 = throwable3;
                                            throw throwable2;
                                        }
                                        if (throwable2 == throwable3) throw throwable2;
                                        throwable2.addSuppressed(throwable3);
                                        throw throwable2;
                                    }
                                }
                                if (decoded == null) break block30;
                            }
                            catch (Throwable throwable4) {
                                if (throwable == null) {
                                    throwable = throwable4;
                                } else if (throwable != throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                                if (decoded == null) throw throwable;
                                decoded.close();
                                throw throwable;
                            }
                            decoded.close();
                        }
                        if (encoded == null) continue;
                    }
                    catch (Throwable throwable5) {
                        if (throwable == null) {
                            throwable = throwable5;
                        } else if (throwable != throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        if (encoded == null) throw throwable;
                        encoded.close();
                        throw throwable;
                    }
                    encoded.close();
                    continue;
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                        throw throwable;
                    }
                    if (throwable == throwable6) throw throwable;
                    throwable.addSuppressed(throwable6);
                    throw throwable;
                }
            }
            catch (Exception e) {
                String message = String.format("Failed to to extract conditions from %s for configuration %s", path, configuration);
                errors.add(LicensingResults.createError(message, source, (Throwable)e));
                continue;
            }
            break;
        }
    }

    public static List<String> collectPacks(Path configurationPath, final String ... extensions) throws LicensingException {
        String message = String.format("Failed to collect packs at %s", configurationPath);
        String source = ConditionMiners.class.getName();
        if (configurationPath == null) {
            IllegalArgumentException e = new IllegalArgumentException();
            throw new LicensingException(LicensingResults.createError(message, source, (Throwable)e));
        }
        final ArrayList<String> licenseFiles = new ArrayList<String>();
        try {
            Files.walkFileTree(configurationPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                    File file = path.toFile();
                    String filePath = file.getPath();
                    String lowerCase = filePath.toLowerCase();
                    String[] stringArray = extensions;
                    int n = extensions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String extension = stringArray[n2];
                        if (lowerCase.endsWith(extension)) {
                            licenseFiles.add(filePath);
                        }
                        ++n2;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new LicensingException(LicensingResults.createError(message, source, (Throwable)e));
        }
        return licenseFiles;
    }
}

