/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console.util;

import com.sun.messaging.jmq.admin.apps.console.util.LongField;
import com.sun.messaging.jmq.admin.resources.AdminConsoleResources;
import com.sun.messaging.jmq.admin.util.Globals;
import com.sun.messaging.jmq.util.SizeString;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class BytesField
extends JPanel {
    private static final long serialVersionUID = -2782976214611678202L;
    public static final int BYTES = 0;
    public static final int KILOBYTES = 1;
    public static final int MEGABYTES = 2;
    private static AdminConsoleResources acr = Globals.getAdminConsoleResources();
    private LongField lf;
    private JComboBox unitCB;

    public BytesField(long min, long max, String text) {
        this(min, max, text, 0);
    }

    public BytesField(long min, long max, int columns) {
        this(min, max, null, columns);
    }

    public BytesField(long min, long max, String text, int columns) {
        this.initGui(min, max, text, columns);
        this.setUnit(1);
    }

    public void addActionListener(ActionListener l) {
        this.lf.addActionListener(l);
    }

    public void setText(String s) {
        this.lf.setText(s);
    }

    public String getText() {
        return this.lf.getText();
    }

    @Override
    public void setEnabled(boolean b) {
        this.lf.setEnabled(b);
        this.unitCB.setEnabled(b);
    }

    public void setUnit(int unit) {
        if (unit < 0 || unit > 2) {
            return;
        }
        this.unitCB.setSelectedIndex(unit);
    }

    public int getUnit() {
        int selIndex = this.unitCB.getSelectedIndex();
        return selIndex;
    }

    public void setSizeString(String strVal) {
        int unit;
        long val;
        SizeString ss;
        String tmp = strVal.trim();
        try {
            ss = new SizeString(tmp);
        }
        catch (Exception e) {
            return;
        }
        char c = tmp.charAt(tmp.length() - 1);
        if (Character.isLetter(c)) {
            switch (c) {
                case 'M': 
                case 'm': {
                    val = ss.getMBytes();
                    unit = 2;
                    break;
                }
                case 'K': 
                case 'k': {
                    val = ss.getKBytes();
                    unit = 1;
                    break;
                }
                case 'B': 
                case 'b': {
                    val = ss.getBytes();
                    unit = 0;
                    break;
                }
                default: {
                    val = 0L;
                    unit = 0;
                    break;
                }
            }
        } else {
            val = ss.getBytes();
            unit = 0;
        }
        this.setText(Long.toString(val));
        this.setUnit(unit);
    }

    public String getSizeString() {
        String strValue = this.getText();
        int unit = this.getUnit();
        return strValue + (switch (unit) {
            case 0 -> "b";
            case 1 -> "k";
            case 2 -> "m";
            default -> "b";
        });
    }

    public long getValue() {
        long tmpLong;
        String s = this.lf.getText();
        try {
            tmpLong = Long.parseLong(s);
        }
        catch (Exception e) {
            return -1L;
        }
        int selIndex = this.unitCB.getSelectedIndex();
        switch (selIndex) {
            case 2: {
                return tmpLong * 0x100000L;
            }
            case 1: {
                return tmpLong * 1024L;
            }
            case 0: {
                return tmpLong;
            }
        }
        return -1L;
    }

    private void initGui(long min, long max, String text, int collumns) {
        this.lf = new LongField(min, max, text, collumns);
        String[] units = new String[3];
        units[2] = acr.getString("A1219");
        units[1] = acr.getString("A1220");
        units[0] = acr.getString("A1221");
        this.unitCB = new JComboBox<String>(units);
        this.setLayout(new BorderLayout());
        this.add((Component)this.lf, "Center");
        this.add((Component)this.unitCB, "East");
    }
}

