/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.time.Duration;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressIndicator;
import org.eclipse.jface.util.Throttler;
import org.eclipse.jface.util.Util;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.progress.AnimationItem;
import org.eclipse.ui.internal.progress.AnimationManager;
import org.eclipse.ui.internal.progress.FinishedJobs;
import org.eclipse.ui.internal.progress.JobInfo;
import org.eclipse.ui.internal.progress.JobTreeElement;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.internal.progress.ProgressRegion;
import org.eclipse.ui.internal.progress.StatusAdapterHelper;
import org.eclipse.ui.progress.IProgressConstants;
import org.eclipse.ui.progress.IProgressConstants2;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;

public class ProgressAnimationItem
extends AnimationItem
implements FinishedJobs.KeptJobsListener {
    ProgressIndicator bar;
    MouseListener mouseListener;
    Composite top;
    ToolBar toolbar;
    ToolItem toolButton;
    ProgressRegion progressRegion;
    Image noneImage;
    Image okImage;
    Image errorImage;
    boolean animationRunning;
    private final int flags;
    private AccessibleListener currentAccessibleListener;
    private final Throttler throttledRefresh = new Throttler(PlatformUI.getWorkbench().getDisplay(), Duration.ofMillis(100L), this::refresh);

    ProgressAnimationItem(ProgressRegion region, int flags) {
        super(region.workbenchWindow);
        this.flags = flags;
        FinishedJobs.getInstance().addListener(this);
        this.progressRegion = region;
        this.mouseListener = new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                ProgressAnimationItem.this.doAction();
            }
        };
    }

    void doAction() {
        JobTreeElement[] jobTreeElements = FinishedJobs.getInstance().getKeptElements();
        int i = jobTreeElements.length - 1;
        while (i >= 0) {
            JobInfo ji;
            Job job;
            JobTreeElement jobTreeElement = jobTreeElements[i];
            if (jobTreeElement instanceof JobInfo && (job = (ji = (JobInfo)jobTreeElement).getJob()) != null) {
                IStatus status = job.getResult();
                if (status != null && status.getSeverity() == 4) {
                    StatusAdapter statusAdapter = StatusAdapterHelper.getInstance().getStatusAdapter(ji);
                    if (statusAdapter == null) {
                        statusAdapter = new StatusAdapter(status);
                    }
                    StatusManager.getManager().handle(statusAdapter, 2);
                    this.removeTopElement(ji);
                }
                if (this.execute(ji, job)) {
                    return;
                }
            }
            --i;
        }
        this.progressRegion.processDoubleClick();
        this.refresh();
    }

    private boolean execute(JobInfo ji, Job job) {
        IAction action;
        Object prop = job.getProperty(IProgressConstants.ACTION_PROPERTY);
        if (prop instanceof IAction && (action = (IAction)prop).isEnabled()) {
            action.run();
            this.removeTopElement(ji);
            return true;
        }
        prop = job.getProperty(IProgressConstants2.COMMAND_PROPERTY);
        if (prop instanceof ParameterizedCommand) {
            ParameterizedCommand command = (ParameterizedCommand)prop;
            IWorkbenchWindow window = this.getWindow();
            IHandlerService service = (IHandlerService)window.getService(IHandlerService.class);
            Throwable exception = null;
            try {
                service.executeCommand(command, null);
                this.removeTopElement(ji);
            }
            catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
                exception = e;
            }
            if (exception != null) {
                Status status = new Status(4, "org.eclipse.ui", exception.getMessage(), exception);
                StatusManager.getManager().handle((IStatus)status, 3);
            }
            return true;
        }
        return false;
    }

    private void removeTopElement(JobInfo ji) {
        JobTreeElement topElement = ji.getParent();
        if (topElement == null) {
            topElement = ji;
        }
        FinishedJobs.getInstance().remove(topElement);
    }

    private IAction getAction(Job job) {
        Object property = job.getProperty(IProgressConstants.ACTION_PROPERTY);
        if (property instanceof IAction) {
            return (IAction)property;
        }
        return null;
    }

    private void refresh() {
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        if (this.toolbar == null || this.toolbar.isDisposed()) {
            return;
        }
        if (this.bar != null && !this.bar.isDisposed()) {
            JobInfo[] jobInfos = ProgressManager.getInstance().getJobInfos(false);
            int percentSum = 0;
            int percentCount = 0;
            JobInfo[] jobInfoArray = jobInfos;
            int n = jobInfos.length;
            int n2 = 0;
            while (n2 < n) {
                int percentDone;
                JobInfo jobInfo = jobInfoArray[n2];
                if (jobInfo != null && !jobInfo.isBlocked() && jobInfo.getJob().getState() != 2 && (percentDone = jobInfo.getPercentDone()) >= 0) {
                    percentSum += percentDone;
                    ++percentCount;
                }
                ++n2;
            }
            if (percentCount > 0) {
                this.bar.setWork(100, percentSum / percentCount);
                AnimationManager.getInstance().setAnimated(true);
            } else if (jobInfos.length > 0) {
                this.bar.beginAnimatedTask();
            }
        }
        JobTreeElement[] jobTreeElements = FinishedJobs.getInstance().getKeptElements();
        int i = jobTreeElements.length - 1;
        while (i >= 0) {
            JobInfo ji;
            Job job;
            JobTreeElement jobTreeElement = jobTreeElements[i];
            if (jobTreeElement instanceof JobInfo && (job = (ji = (JobInfo)jobTreeElement).getJob()) != null) {
                IStatus status = job.getResult();
                if (status != null && status.getSeverity() == 4) {
                    this.initButton(this.errorImage, NLS.bind((String)ProgressMessages.ProgressAnimationItem_error, (Object)job.getName()));
                    return;
                }
                IAction action = this.getAction(job);
                if (action != null && action.isEnabled()) {
                    String tt = action.getToolTipText();
                    if (tt == null || tt.trim().isEmpty()) {
                        tt = NLS.bind((String)ProgressMessages.ProgressAnimationItem_ok, (Object)job.getName());
                    }
                    this.initButton(this.okImage, tt);
                    return;
                }
                this.initButton(this.noneImage, ProgressMessages.ProgressAnimationItem_tasks);
                return;
            }
            --i;
        }
        if (this.animationRunning) {
            this.initButton(this.noneImage, ProgressMessages.ProgressAnimationItem_tasks);
            return;
        }
        this.toolbar.setVisible(false);
    }

    boolean isImageSizeChanged(Image oldImage, Image image) {
        boolean changed = true;
        if (oldImage != null && !oldImage.isDisposed() && image != null && !image.isDisposed()) {
            changed = !oldImage.getBounds().equals((Object)image.getBounds());
        }
        return changed;
    }

    private void initButton(Image im, final String tt) {
        boolean isLayoutRequired = this.isImageSizeChanged(im, this.toolButton.getImage());
        this.toolButton.setImage(im);
        this.toolButton.setToolTipText(tt);
        this.toolbar.setVisible(true);
        this.toolbar.getParent().layout(isLayoutRequired);
        if (this.currentAccessibleListener != null) {
            this.toolbar.getAccessible().removeAccessibleListener(this.currentAccessibleListener);
        }
        this.currentAccessibleListener = new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = tt;
            }
        };
        this.toolbar.getAccessible().addAccessibleListener(this.currentAccessibleListener);
    }

    @Override
    protected Control createAnimationItem(Composite parent) {
        GridData gd;
        if (this.okImage == null) {
            Display display = parent.getDisplay();
            this.noneImage = WorkbenchImages.getWorkbenchImageDescriptor("progress/progress_none.svg").createImage((Device)display);
            this.okImage = WorkbenchImages.getWorkbenchImageDescriptor("progress/progress_ok.svg").createImage((Device)display);
            this.errorImage = WorkbenchImages.getWorkbenchImageDescriptor("progress/progress_error.svg").createImage((Device)display);
        }
        this.top = new Composite(parent, 0);
        this.top.addDisposeListener(e -> {
            FinishedJobs.getInstance().removeListener(this);
            this.noneImage.dispose();
            this.okImage.dispose();
            this.errorImage.dispose();
        });
        boolean isCarbon = Util.isMac();
        GridLayout gl = new GridLayout();
        if (this.isHorizontal()) {
            gl.numColumns = isCarbon ? 3 : 2;
        }
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        if (this.isHorizontal()) {
            gl.horizontalSpacing = 2;
        } else {
            gl.verticalSpacing = 2;
        }
        this.top.setLayout((Layout)gl);
        this.bar = new ProgressIndicator(this.top, this.flags);
        this.bar.setVisible(false);
        this.bar.addMouseListener(this.mouseListener);
        int hh = 12;
        if (this.isHorizontal()) {
            gd = new GridData(1, 0x1000000, true, false);
            gd.heightHint = hh;
        } else {
            gd = new GridData(0x1000000, 1, false, true);
            gd.widthHint = hh;
        }
        this.bar.setLayoutData((Object)gd);
        this.toolbar = new ToolBar(this.top, 0x800000);
        this.toolbar.setVisible(false);
        this.toolButton = new ToolItem(this.toolbar, 0);
        this.toolButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.doAction()));
        if (isCarbon) {
            new Label(this.top, 0).setLayoutData((Object)new GridData(4, 4));
        }
        this.refresh();
        return this.top;
    }

    private boolean isHorizontal() {
        return (this.flags & 0x100) != 0;
    }

    @Override
    public Control getControl() {
        return this.top;
    }

    @Override
    void animationDone() {
        super.animationDone();
        this.animationRunning = false;
        if (this.bar.isDisposed()) {
            return;
        }
        this.bar.setVisible(false);
        this.refresh();
    }

    public boolean animationRunning() {
        return this.animationRunning;
    }

    @Override
    void animationStart() {
        super.animationStart();
        this.animationRunning = true;
        if (this.bar.isDisposed()) {
            return;
        }
        this.bar.setVisible(true);
        this.refresh();
    }

    @Override
    public void removed(JobTreeElement info) {
        this.throttledRefresh.throttledExec();
    }

    @Override
    public void finished(JobTreeElement jte) {
        this.throttledRefresh.throttledExec();
    }
}

