/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.e4.core.commands.ExpressionContext;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.ui.internal.workbench.ContributionsAnalyzer;
import org.eclipse.e4.ui.internal.workbench.swt.AbstractPartRenderer;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MTrimContribution;
import org.eclipse.e4.ui.model.application.ui.menu.impl.ToolBarImpl;
import org.eclipse.e4.ui.workbench.renderers.swt.SWTPartRenderer;
import org.eclipse.e4.ui.workbench.renderers.swt.ToolBarManagerRenderer;
import org.eclipse.e4.ui.workbench.renderers.swt.TrimBarLayout;
import org.eclipse.e4.ui.workbench.renderers.swt.TrimmedPartLayout;
import org.eclipse.e4.ui.workbench.swt.factories.IRendererFactory;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class TrimBarRenderer
extends SWTPartRenderer {
    private MApplication application;

    private synchronized void layoutTrim(MTrimBar trimBar) {
        Composite comp = (Composite)trimBar.getWidget();
        if (comp != null && !comp.isDisposed()) {
            comp.requestLayout();
        }
    }

    @Override
    public void init(IEclipseContext context) {
        super.init(context);
        this.application = (MApplication)context.get(MApplication.class);
    }

    /*
     * WARNING - void declaration
     */
    public Object createWidget(MUIElement element, Object parent) {
        void parentComp;
        if (!(element instanceof MTrimBar) || !(parent instanceof Composite)) {
            return null;
        }
        Composite composite = (Composite)parent;
        Composite trimComposite = null;
        MTrimBar trimModel = (MTrimBar)element;
        if (parentComp.getLayout() instanceof TrimmedPartLayout) {
            TrimmedPartLayout tpl = (TrimmedPartLayout)parentComp.getLayout();
            switch (trimModel.getSide().getValue()) {
                case 0: {
                    trimComposite = tpl.getTrimComposite((Composite)parentComp, 128);
                    break;
                }
                case 1: {
                    trimComposite = tpl.getTrimComposite((Composite)parentComp, 1024);
                    break;
                }
                case 2: {
                    trimComposite = tpl.getTrimComposite((Composite)parentComp, 16384);
                    break;
                }
                case 3: {
                    trimComposite = tpl.getTrimComposite((Composite)parentComp, 131072);
                    break;
                }
                default: {
                    return null;
                }
            }
            trimComposite.addDisposeListener(e -> this.cleanUp(trimModel));
        } else {
            trimComposite = new Composite((Composite)parentComp, 0);
            trimComposite.setLayout((Layout)new TrimBarLayout(true));
        }
        return trimComposite;
    }

    public void hideChild(MElementContainer<MUIElement> parentElement, MUIElement child) {
        super.hideChild(parentElement, child);
        MElementContainer<MUIElement> downCast = parentElement;
        this.layoutTrim((MTrimBar)downCast);
    }

    @Override
    public void processContents(MElementContainer<MUIElement> me) {
        if (!(me instanceof MTrimBar)) {
            return;
        }
        super.processContents(me);
        IEclipseContext ctx = this.getContext((MUIElement)me);
        ExpressionContext eContext = new ExpressionContext(ctx);
        MElementContainer<MUIElement> trimObj = me;
        MTrimBar trimModel = (MTrimBar)trimObj;
        ArrayList<MTrimContribution> toContribute = new ArrayList<MTrimContribution>();
        ContributionsAnalyzer.gatherTrimContributions((List)this.application.getTrimContributions(), (String)trimModel.getElementId(), toContribute);
        this.addTrimContributions(trimModel, toContribute, ctx, eContext);
    }

    private void addTrimContributions(final MTrimBar trimModel, ArrayList<MTrimContribution> toContribute, IEclipseContext ctx, final ExpressionContext eContext) {
        HashSet<String> existingToolbarIds = new HashSet<String>();
        MTrimmedWindow topWin = (MTrimmedWindow)this.modelService.getTopLevelWindowFor((MUIElement)trimModel);
        for (MTrimBar bar : topWin.getTrimBars()) {
            for (MTrimElement item : bar.getChildren()) {
                String id = item.getElementId();
                if (id == null) continue;
                existingToolbarIds.add(id);
            }
        }
        boolean done = toContribute.isEmpty();
        while (!done) {
            ArrayList<MTrimContribution> curList = new ArrayList<MTrimContribution>(toContribute);
            int retryCount = toContribute.size();
            toContribute.clear();
            for (final MTrimContribution contribution : curList) {
                ArrayList toRemove;
                if (!ContributionsAnalyzer.processAddition((MTrimBar)trimModel, (MTrimContribution)contribution, toRemove = new ArrayList(), existingToolbarIds)) {
                    toContribute.add(contribution);
                    continue;
                }
                if (contribution.getVisibleWhen() != null) {
                    ctx.runAndTrack(new RunAndTrack(){

                        public boolean changed(IEclipseContext context) {
                            if (!trimModel.isToBeRendered() || !trimModel.isVisible() || trimModel.getWidget() == null) {
                                return false;
                            }
                            boolean rc = ContributionsAnalyzer.isVisible((MTrimContribution)contribution, (ExpressionContext)eContext);
                            for (MTrimElement child : toRemove) {
                                child.setToBeRendered(rc);
                            }
                            return true;
                        }
                    });
                }
                trimModel.getPendingCleanup().addAll(toRemove);
            }
            boolean bl = done = toContribute.isEmpty() || toContribute.size() == retryCount;
        }
    }

    protected void cleanUp(MTrimBar element) {
        IRendererFactory rendererFactory = (IRendererFactory)this.context.get(IRendererFactory.class);
        for (MTrimElement child : element.getPendingCleanup()) {
            element.getChildren().remove(child);
            if (!(child instanceof ToolBarImpl)) continue;
            ToolBarImpl tb = (ToolBarImpl)child;
            this.releaseToolbar(rendererFactory, tb);
        }
        element.getPendingCleanup().clear();
        List children = element.getChildren();
        for (MTrimElement mTrimElement : children) {
            if (!(mTrimElement instanceof ToolBarImpl)) continue;
            ToolBarImpl tb = (ToolBarImpl)mTrimElement;
            this.releaseToolbar(rendererFactory, tb);
        }
    }

    private void releaseToolbar(IRendererFactory rendererFactory, ToolBarImpl tb) {
        AbstractPartRenderer apr = rendererFactory.getRenderer((MUIElement)tb, null);
        if (apr instanceof ToolBarManagerRenderer) {
            ToolBarManagerRenderer tbmr = (ToolBarManagerRenderer)apr;
            ToolBarManager tbm = tbmr.getManager((MToolBar)tb);
            tbmr.clearModelToManager((MToolBar)tb, null);
            if (tbm != null) {
                tbm.dispose();
                tbm.removeAll();
            }
        }
    }
}

