/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.set;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.core.databinding.observable.IDiff;

public abstract class SetDiff<E>
implements IDiff {
    public abstract Set<E> getAdditions();

    public abstract Set<E> getRemovals();

    public boolean isEmpty() {
        return this.getAdditions().isEmpty() && this.getRemovals().isEmpty();
    }

    public void applyTo(Set<? super E> set) {
        set.addAll(this.getAdditions());
        set.removeAll(this.getRemovals());
    }

    public Set<E> simulateOn(Set<E> set) {
        return new DeltaSet<E>(set, this);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getClass().getName()).append("{additions [").append(this.getAdditions() != null ? this.getAdditions().toString() : "null").append("], removals [").append(this.getRemovals() != null ? this.getRemovals().toString() : "null").append("]}");
        return buffer.toString();
    }

    private static class DeltaSet<E>
    extends AbstractSet<E> {
        private Set<E> original;
        private final SetDiff<E> diff;

        public DeltaSet(Set<E> original, SetDiff<E> diff) {
            this.original = original;
            this.diff = diff;
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                Iterator<E> orig;
                Iterator<E> add;
                boolean haveNext;
                E next;
                {
                    this.orig = deltaSet.original.iterator();
                    this.add = deltaSet.diff.getAdditions().iterator();
                    this.haveNext = false;
                }

                @Override
                public boolean hasNext() {
                    return this.findNext();
                }

                @Override
                public E next() {
                    if (!this.findNext()) {
                        throw new NoSuchElementException();
                    }
                    Object myNext = this.next;
                    this.haveNext = false;
                    this.next = null;
                    return myNext;
                }

                private boolean findNext() {
                    Object candidate;
                    if (this.haveNext) {
                        return true;
                    }
                    do {
                        if (this.orig.hasNext()) {
                            candidate = this.orig.next();
                            continue;
                        }
                        if (this.add.hasNext()) {
                            candidate = this.add.next();
                            continue;
                        }
                        return false;
                    } while (diff.getRemovals().contains(candidate));
                    this.haveNext = true;
                    this.next = candidate;
                    return true;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public boolean contains(Object o) {
            return (this.original.contains(o) || this.diff.getAdditions().contains(o)) && !this.diff.getRemovals().contains(o);
        }

        @Override
        public int size() {
            return this.original.size() + this.diff.getAdditions().size() - this.diff.getRemovals().size();
        }
    }
}

