/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.repository.helpers;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Objects;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.repository.helpers.Messages;
import org.eclipse.equinox.p2.repository.IRepository;
import org.eclipse.osgi.util.NLS;

public class RepositoryHelper {
    protected static final String FILE_SCHEME = "file";

    public static URI localRepoURIHelper(URI location) {
        if (location == null) {
            return null;
        }
        if (location.getScheme() == null) {
            location = new File(location.getPath()).getAbsoluteFile().toURI();
        } else if (location.getScheme().length() == 1) {
            location = new File(URIUtil.toUnencodedString((URI)location)).toURI();
        } else if (!FILE_SCHEME.equalsIgnoreCase(location.getScheme())) {
            return location;
        }
        String lowerCase = location.toString().toLowerCase();
        if (lowerCase.endsWith(".jar") || lowerCase.endsWith(".zip")) {
            return URIUtil.toJarURI((URI)location, null);
        }
        return location;
    }

    public static <T> IRepository<T> validDestinationRepository(IRepository<T> repository) {
        if (!repository.isModifiable()) {
            throw new IllegalStateException(NLS.bind((String)Messages.DestinationNotModifiable, (Object)repository.getLocation()));
        }
        return repository;
    }

    /*
     * Unable to fully structure code
     */
    public static IStatus checkRepositoryLocationSyntax(URI location) {
        block7: {
            block8: {
                if (location == null) {
                    throw new IllegalArgumentException("Location cannot be null");
                }
                if (!location.isAbsolute()) {
                    return new Status(4, "org.eclipse.equinox.p2.repository", Messages.locationMustBeAbsolute);
                }
                scheme = location.getScheme();
                if (scheme == null) {
                    return Status.error((String)Messages.schemeNotProvided);
                }
                try {
                    new URL(scheme, "dummy.com", -1, "dummy.txt");
                    break block7;
                }
                catch (MalformedURLException e) {
                    reg = RegistryFactory.getRegistry();
                    if (reg == null) break block8;
                    handlersExtensionPoint = reg.getExtensionPoint("org.eclipse.ecf.filetransfer.urlStreamHandlerService");
                    var9_6 = configurationElements = handlersExtensionPoint.getConfigurationElements();
                    var8_7 = configurationElements.length;
                    var7_8 = 0;
                    ** while (var7_8 < var8_7)
                }
lbl-1000:
                // 1 sources

                {
                    configurationElement = var9_6[var7_8];
                    protocol = configurationElement.getAttribute("protocol");
                    if (Objects.equals(scheme, protocol)) {
                        return Status.OK_STATUS;
                    }
                    ++var7_8;
                    continue;
                }
            }
            return new Status(4, "org.eclipse.equinox.p2.repository", Messages.schemeNotSupported, (Throwable)e);
        }
        return Status.OK_STATUS;
    }
}

