/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.tests;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.repository.AuthenticationFailedException;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.oomph.internal.util.HTTPServer;
import org.eclipse.oomph.p2.P2Factory;
import org.eclipse.oomph.p2.ProfileDefinition;
import org.eclipse.oomph.p2.core.Agent;
import org.eclipse.oomph.p2.core.AgentManager;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.p2.core.Profile;
import org.eclipse.oomph.p2.core.ProfileTransaction;
import org.eclipse.oomph.p2.internal.core.CachingTransport;
import org.eclipse.oomph.p2.tests.AbstractP2Test;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.PropertiesUtil;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.JVM)
public class TransportTests
extends AbstractP2Test {
    private static final boolean ASSERT_REQUESTS = true;
    private static HTTPServer httpServer;
    private List<HTTPServer.Context> contexts = new ArrayList<HTTPServer.Context>();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        httpServer = new HTTPServer(2345, 5000);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        if (httpServer != null) {
            httpServer.stop();
            httpServer = null;
        }
    }

    @Override
    public void tearDown() throws Exception {
        for (HTTPServer.Context context : this.contexts) {
            httpServer.removeContext(context);
        }
        super.tearDown();
    }

    private HTTPServer.FileContext addRepo(String path, File folder, boolean composite, boolean p2Index) throws Exception {
        if (composite) {
            IOUtil.copyTree((File)CDO_NEW, (File)new File(folder, "child"));
            IOUtil.writeUTF8((File)new File(folder, "compositeContent.xml"), (String)"<?xml version='1.0' encoding='UTF-8'?>\n<?compositeMetadataRepository version='1.0.0'?>\n<repository name='Eclipse Mars repository' type='org.eclipse.equinox.internal.p2.metadata.repository.CompositeMetadataRepository' version='1.0.0'>\n    <properties size='3'>\n        <property name='p2.timestamp' value='1313779613760'/>\n        <property name='p2.atomic.composite.loading' value='true'/>\n    </properties>\n    <children size='1'>\n        <child location='child' />\n    </children>    \n</repository>\n");
            IOUtil.writeUTF8((File)new File(folder, "compositeArtifacts.xml"), (String)"<?xml version='1.0' encoding='UTF-8'?>\n<?compositeArtifactRepository version='1.0.0'?>\n<repository name='Eclipse Mars repository' type='org.eclipse.equinox.internal.p2.artifact.repository.CompositeArtifactRepository' version='1.0.0'>\n    <properties size='3'>\n        <property name='p2.timestamp' value='1313779613118'/>\n        <property name='p2.atomic.composite.loading' value='true'/>\n    </properties>\n    <children size='1'>\n        <child location='child' />\n    </children>\n</repository>\n");
            if (p2Index) {
                IOUtil.writeUTF8((File)new File(folder, "p2.index"), (String)"version=1\nmetadata.repository.factory.order=compositeContent.xml,\\!\nartifact.repository.factory.order=compositeArtifacts.xml,\\!\n");
            }
        } else {
            IOUtil.copyTree((File)CDO_NEW, (File)folder);
            if (p2Index) {
                IOUtil.writeUTF8((File)new File(folder, "p2.index"), (String)"version=1\nmetadata.repository.factory.order=content.xml,\\!\nartifact.repository.factory.order=artifacts.xml,\\!\n");
            }
        }
        HTTPServer.FileContext context = new HTTPServer.FileContext(path, false, folder);
        httpServer.addContext((HTTPServer.Context)context);
        this.contexts.add((HTTPServer.Context)context);
        return context;
    }

    private void removeRepo(HTTPServer.FileContext context) {
        httpServer.removeContext((HTTPServer.Context)context);
        IOUtil.deleteBestEffort((File)context.getRoot());
    }

    private String removePort(String request) {
        return request.replace(":" + httpServer.getPort() + "/", "/");
    }

    private List<String> install(int installation) throws Exception {
        String url = httpServer + "/cdo";
        File installFolder = new File(this.getUserHome(), "app" + installation);
        AgentManager agentManager = P2Util.getAgentManager();
        Agent agent = agentManager.addAgent(new File(installFolder, "p2"));
        CachingTransport cachingTransport = (CachingTransport)agent.getProvisioningAgent().getService(CachingTransport.SERVICE_NAME);
        CountingTransport countingTransport = new CountingTransport(cachingTransport.getDelegate());
        cachingTransport.setDelegate((Transport)countingTransport);
        Profile profile = agent.addProfile("profile-app" + installation, "Installation").setCacheFolder(installFolder).setInstallFolder(installFolder).create();
        ProfileTransaction transaction = profile.change();
        transaction.setMirrors(false);
        ProfileDefinition profileDefinition = transaction.getProfileDefinition();
        profileDefinition.getRequirements().add((Object)P2Factory.eINSTANCE.createRequirement("org.eclipse.net4j.util"));
        profileDefinition.getRepositories().add((Object)P2Factory.eINSTANCE.createRepository(url));
        this.commitProfileTransaction(transaction, true, (IProgressMonitor)new NullProgressMonitor());
        MatcherAssert.assertThat((Object)installFolder.isDirectory(), (Matcher)TransportTests.is((Object)true));
        MatcherAssert.assertThat((Object)installFolder.list().length, (Matcher)TransportTests.is((Object)3));
        MatcherAssert.assertThat((Object)new File(installFolder, "p2").isDirectory(), (Matcher)TransportTests.is((Object)true));
        MatcherAssert.assertThat((Object)new File(installFolder, "artifacts.xml").isFile(), (Matcher)TransportTests.is((Object)true));
        File plugins = new File(installFolder, "plugins");
        MatcherAssert.assertThat((Object)plugins.isDirectory(), (Matcher)TransportTests.is((Object)true));
        MatcherAssert.assertThat((Object)plugins.list().length, (Matcher)TransportTests.is((Object)1));
        ArrayList<String> results = new ArrayList<String>();
        results.addAll(countingTransport.getRequests());
        File cacheFile = cachingTransport.getCacheFile(new URI(String.valueOf(url) + "/p2.index"));
        Map p2Index = PropertiesUtil.loadProperties((File)cacheFile);
        for (Map.Entry entry : p2Index.entrySet()) {
            results.add("     " + (String)entry.getKey() + "=" + (String)entry.getValue());
        }
        return results;
    }

    private List<String> test(boolean startWithComposite, boolean startWithP2Index, boolean endWithP2Index) throws Exception {
        ArrayList<String> results = new ArrayList<String>();
        File root = new File(this.getUserHome(), "cdo");
        System.out.println(root);
        System.out.println();
        HTTPServer.FileContext context1 = this.addRepo("/cdo", root, startWithComposite, startWithP2Index);
        try {
            results.add("INSTALL 1");
            results.addAll(this.install(1));
        }
        finally {
            this.removeRepo(context1);
        }
        HTTPServer.FileContext context2 = this.addRepo("/cdo", root, !startWithComposite, endWithP2Index);
        try {
            results.add("INSTALL 2");
            results.addAll(this.install(2));
        }
        finally {
            this.removeRepo(context2);
        }
        return results;
    }

    private void assertResults(List<String> results, String ... expectedResults) {
        System.out.println("assertResults(results //");
        int i = 0;
        boolean failed = false;
        for (String result : results) {
            result = this.removePort(result);
            System.out.print(", \"" + result + "\" //");
            int index = i++;
            if (index >= expectedResults.length) {
                System.out.println(" -------------------> UNEXPECTED");
                failed = true;
                continue;
            }
            String expectedResult = this.removePort(expectedResults[index]);
            if (result.equals(expectedResult)) {
                System.out.println();
                continue;
            }
            System.out.println(" ------------------->  " + expectedResult);
            failed = true;
        }
        System.out.println(");\n\n");
        int j = i;
        while (j < expectedResults.length) {
            System.out.println("MISSING: " + expectedResults[j]);
            failed = true;
            ++j;
        }
        if (failed) {
            throw new AssertionError((Object)"Unexpected Results");
        }
    }

    @Test
    public void test_1_CompositeToSimpleWithoutIndex() throws Exception {
        List<String> results = this.test(true, false, false);
        this.assertResults(results, "INSTALL 1", "GET  http://127.0.0.1/cdo/p2.index", "HEAD http://127.0.0.1/cdo/content.jar", "HEAD http://127.0.0.1/cdo/content.xml", "HEAD http://127.0.0.1/cdo/content.xml.xz", "HEAD http://127.0.0.1/cdo/compositeContent.jar", "HEAD http://127.0.0.1/cdo/compositeContent.xml", "GET  http://127.0.0.1/cdo/compositeContent.xml", "GET  http://127.0.0.1/cdo/child/p2.index", "HEAD http://127.0.0.1/cdo/child/content.jar", "GET  http://127.0.0.1/cdo/child/content.jar", "HEAD http://127.0.0.1/cdo/artifacts.jar", "HEAD http://127.0.0.1/cdo/artifacts.xml", "HEAD http://127.0.0.1/cdo/artifacts.xml.xz", "HEAD http://127.0.0.1/cdo/compositeArtifacts.jar", "HEAD http://127.0.0.1/cdo/compositeArtifacts.xml", "GET  http://127.0.0.1/cdo/compositeArtifacts.xml", "HEAD http://127.0.0.1/cdo/child/artifacts.jar", "GET  http://127.0.0.1/cdo/child/artifacts.jar", "GET  http://127.0.0.1/cdo/child/plugins/org.eclipse.net4j.util_3.3.1.v20140218-1709.jar", "     version=1", "     metadata.repository.factory.order=compositeContent.xml", "     artifact.repository.factory.order=compositeArtifacts.xml", "INSTALL 2", "HEAD http://127.0.0.1/cdo/compositeContent.jar", "HEAD http://127.0.0.1/cdo/compositeContent.xml", "HEAD http://127.0.0.1/cdo/content.jar", "GET  http://127.0.0.1/cdo/content.jar", "HEAD http://127.0.0.1/cdo/compositeArtifacts.jar", "HEAD http://127.0.0.1/cdo/compositeArtifacts.xml", "HEAD http://127.0.0.1/cdo/artifacts.jar", "GET  http://127.0.0.1/cdo/artifacts.jar", "GET  http://127.0.0.1/cdo/plugins/org.eclipse.net4j.util_3.3.1.v20140218-1709.jar", "     version=1", "     metadata.repository.factory.order=content.xml", "     artifact.repository.factory.order=artifacts.xml");
    }

    @Test
    public void test_2_CompositeToSimpleRemoveIndex() throws Exception {
        List<String> results = this.test(true, true, false);
        this.assertResults(results, "INSTALL 1", "GET  http://127.0.0.1/cdo/p2.index", "HEAD http://127.0.0.1/cdo/compositeContent.jar", "HEAD http://127.0.0.1/cdo/compositeContent.xml", "GET  http://127.0.0.1/cdo/compositeContent.xml", "GET  http://127.0.0.1/cdo/child/p2.index", "HEAD http://127.0.0.1/cdo/child/content.jar", "GET  http://127.0.0.1/cdo/child/content.jar", "HEAD http://127.0.0.1/cdo/compositeArtifacts.jar", "HEAD http://127.0.0.1/cdo/compositeArtifacts.xml", "GET  http://127.0.0.1/cdo/compositeArtifacts.xml", "HEAD http://127.0.0.1/cdo/child/artifacts.jar", "GET  http://127.0.0.1/cdo/child/artifacts.jar", "GET  http://127.0.0.1/cdo/child/plugins/org.eclipse.net4j.util_3.3.1.v20140218-1709.jar", "     version=1", "     metadata.repository.factory.order=compositeContent.xml", "     artifact.repository.factory.order=compositeArtifacts.xml", "INSTALL 2", "HEAD http://127.0.0.1/cdo/compositeContent.jar", "HEAD http://127.0.0.1/cdo/compositeContent.xml", "HEAD http://127.0.0.1/cdo/content.jar", "GET  http://127.0.0.1/cdo/content.jar", "HEAD http://127.0.0.1/cdo/compositeArtifacts.jar", "HEAD http://127.0.0.1/cdo/compositeArtifacts.xml", "HEAD http://127.0.0.1/cdo/artifacts.jar", "GET  http://127.0.0.1/cdo/artifacts.jar", "GET  http://127.0.0.1/cdo/plugins/org.eclipse.net4j.util_3.3.1.v20140218-1709.jar", "     version=1", "     metadata.repository.factory.order=content.xml", "     artifact.repository.factory.order=artifacts.xml");
    }

    @Test
    public void test_3_CompositeToSimpleAddIndex() throws Exception {
        List<String> results = this.test(true, false, true);
        this.assertResults(results, "INSTALL 1", "GET  http://127.0.0.1/cdo/p2.index", "HEAD http://127.0.0.1/cdo/content.jar", "HEAD http://127.0.0.1/cdo/content.xml", "HEAD http://127.0.0.1/cdo/content.xml.xz", "HEAD http://127.0.0.1/cdo/compositeContent.jar", "HEAD http://127.0.0.1/cdo/compositeContent.xml", "GET  http://127.0.0.1/cdo/compositeContent.xml", "GET  http://127.0.0.1/cdo/child/p2.index", "HEAD http://127.0.0.1/cdo/child/content.jar", "GET  http://127.0.0.1/cdo/child/content.jar", "HEAD http://127.0.0.1/cdo/artifacts.jar", "HEAD http://127.0.0.1/cdo/artifacts.xml", "HEAD http://127.0.0.1/cdo/artifacts.xml.xz", "HEAD http://127.0.0.1/cdo/compositeArtifacts.jar", "HEAD http://127.0.0.1/cdo/compositeArtifacts.xml", "GET  http://127.0.0.1/cdo/compositeArtifacts.xml", "HEAD http://127.0.0.1/cdo/child/artifacts.jar", "GET  http://127.0.0.1/cdo/child/artifacts.jar", "GET  http://127.0.0.1/cdo/child/plugins/org.eclipse.net4j.util_3.3.1.v20140218-1709.jar", "     version=1", "     metadata.repository.factory.order=compositeContent.xml", "     artifact.repository.factory.order=compositeArtifacts.xml", "INSTALL 2", "HEAD http://127.0.0.1/cdo/compositeContent.jar", "HEAD http://127.0.0.1/cdo/compositeContent.xml", "HEAD http://127.0.0.1/cdo/content.jar", "GET  http://127.0.0.1/cdo/content.jar", "HEAD http://127.0.0.1/cdo/compositeArtifacts.jar", "HEAD http://127.0.0.1/cdo/compositeArtifacts.xml", "HEAD http://127.0.0.1/cdo/artifacts.jar", "GET  http://127.0.0.1/cdo/artifacts.jar", "GET  http://127.0.0.1/cdo/plugins/org.eclipse.net4j.util_3.3.1.v20140218-1709.jar", "     version=1", "     metadata.repository.factory.order=content.xml", "     artifact.repository.factory.order=artifacts.xml");
    }

    @Test
    public void test_4_CompositeToSimpleWithIndex() throws Exception {
        List<String> results = this.test(true, true, true);
        this.assertResults(results, "INSTALL 1", "GET  http://127.0.0.1/cdo/p2.index", "HEAD http://127.0.0.1/cdo/compositeContent.jar", "HEAD http://127.0.0.1/cdo/compositeContent.xml", "GET  http://127.0.0.1/cdo/compositeContent.xml", "GET  http://127.0.0.1/cdo/child/p2.index", "HEAD http://127.0.0.1/cdo/child/content.jar", "GET  http://127.0.0.1/cdo/child/content.jar", "HEAD http://127.0.0.1/cdo/compositeArtifacts.jar", "HEAD http://127.0.0.1/cdo/compositeArtifacts.xml", "GET  http://127.0.0.1/cdo/compositeArtifacts.xml", "HEAD http://127.0.0.1/cdo/child/artifacts.jar", "GET  http://127.0.0.1/cdo/child/artifacts.jar", "GET  http://127.0.0.1/cdo/child/plugins/org.eclipse.net4j.util_3.3.1.v20140218-1709.jar", "     version=1", "     metadata.repository.factory.order=compositeContent.xml", "     artifact.repository.factory.order=compositeArtifacts.xml", "INSTALL 2", "HEAD http://127.0.0.1/cdo/compositeContent.jar", "HEAD http://127.0.0.1/cdo/compositeContent.xml", "HEAD http://127.0.0.1/cdo/content.jar", "GET  http://127.0.0.1/cdo/content.jar", "HEAD http://127.0.0.1/cdo/compositeArtifacts.jar", "HEAD http://127.0.0.1/cdo/compositeArtifacts.xml", "HEAD http://127.0.0.1/cdo/artifacts.jar", "GET  http://127.0.0.1/cdo/artifacts.jar", "GET  http://127.0.0.1/cdo/plugins/org.eclipse.net4j.util_3.3.1.v20140218-1709.jar", "     version=1", "     metadata.repository.factory.order=content.xml", "     artifact.repository.factory.order=artifacts.xml");
    }

    @Test
    public void test_5_SimpleToCompositeWithoutIndex() throws Exception {
        List<String> results = this.test(false, false, false);
        this.assertResults(results, "INSTALL 1", "GET  http://127.0.0.1/cdo/p2.index", "HEAD http://127.0.0.1/cdo/content.jar", "GET  http://127.0.0.1/cdo/content.jar", "HEAD http://127.0.0.1/cdo/artifacts.jar", "GET  http://127.0.0.1/cdo/artifacts.jar", "GET  http://127.0.0.1/cdo/plugins/org.eclipse.net4j.util_3.3.1.v20140218-1709.jar", "     version=1", "     metadata.repository.factory.order=content.xml", "     artifact.repository.factory.order=artifacts.xml", "INSTALL 2", "HEAD http://127.0.0.1/cdo/content.jar", "HEAD http://127.0.0.1/cdo/content.xml", "HEAD http://127.0.0.1/cdo/content.xml.xz", "HEAD http://127.0.0.1/cdo/compositeContent.jar", "HEAD http://127.0.0.1/cdo/compositeContent.xml", "GET  http://127.0.0.1/cdo/compositeContent.xml", "GET  http://127.0.0.1/cdo/child/p2.index", "HEAD http://127.0.0.1/cdo/child/content.jar", "GET  http://127.0.0.1/cdo/child/content.jar", "HEAD http://127.0.0.1/cdo/artifacts.jar", "HEAD http://127.0.0.1/cdo/artifacts.xml", "HEAD http://127.0.0.1/cdo/artifacts.xml.xz", "HEAD http://127.0.0.1/cdo/compositeArtifacts.jar", "HEAD http://127.0.0.1/cdo/compositeArtifacts.xml", "GET  http://127.0.0.1/cdo/compositeArtifacts.xml", "HEAD http://127.0.0.1/cdo/child/artifacts.jar", "GET  http://127.0.0.1/cdo/child/artifacts.jar", "GET  http://127.0.0.1/cdo/child/plugins/org.eclipse.net4j.util_3.3.1.v20140218-1709.jar", "     version=1", "     metadata.repository.factory.order=compositeContent.xml", "     artifact.repository.factory.order=compositeArtifacts.xml");
    }

    @Test
    public void test_6_SimpleToCompositeRemoveIndex() throws Exception {
        List<String> results = this.test(false, true, false);
        this.assertResults(results, "INSTALL 1", "GET  http://127.0.0.1/cdo/p2.index", "HEAD http://127.0.0.1/cdo/content.jar", "GET  http://127.0.0.1/cdo/content.jar", "HEAD http://127.0.0.1/cdo/artifacts.jar", "GET  http://127.0.0.1/cdo/artifacts.jar", "GET  http://127.0.0.1/cdo/plugins/org.eclipse.net4j.util_3.3.1.v20140218-1709.jar", "     version=1", "     metadata.repository.factory.order=content.xml", "     artifact.repository.factory.order=artifacts.xml", "INSTALL 2", "HEAD http://127.0.0.1/cdo/content.jar", "HEAD http://127.0.0.1/cdo/content.xml", "HEAD http://127.0.0.1/cdo/content.xml.xz", "HEAD http://127.0.0.1/cdo/compositeContent.jar", "HEAD http://127.0.0.1/cdo/compositeContent.xml", "GET  http://127.0.0.1/cdo/compositeContent.xml", "GET  http://127.0.0.1/cdo/child/p2.index", "HEAD http://127.0.0.1/cdo/child/content.jar", "GET  http://127.0.0.1/cdo/child/content.jar", "HEAD http://127.0.0.1/cdo/artifacts.jar", "HEAD http://127.0.0.1/cdo/artifacts.xml", "HEAD http://127.0.0.1/cdo/artifacts.xml.xz", "HEAD http://127.0.0.1/cdo/compositeArtifacts.jar", "HEAD http://127.0.0.1/cdo/compositeArtifacts.xml", "GET  http://127.0.0.1/cdo/compositeArtifacts.xml", "HEAD http://127.0.0.1/cdo/child/artifacts.jar", "GET  http://127.0.0.1/cdo/child/artifacts.jar", "GET  http://127.0.0.1/cdo/child/plugins/org.eclipse.net4j.util_3.3.1.v20140218-1709.jar", "     version=1", "     metadata.repository.factory.order=compositeContent.xml", "     artifact.repository.factory.order=compositeArtifacts.xml");
    }

    @Test
    public void test_7_SimpleToCompositeAddIndex() throws Exception {
        List<String> results = this.test(false, false, true);
        this.assertResults(results, "INSTALL 1", "GET  http://127.0.0.1/cdo/p2.index", "HEAD http://127.0.0.1/cdo/content.jar", "GET  http://127.0.0.1/cdo/content.jar", "HEAD http://127.0.0.1/cdo/artifacts.jar", "GET  http://127.0.0.1/cdo/artifacts.jar", "GET  http://127.0.0.1/cdo/plugins/org.eclipse.net4j.util_3.3.1.v20140218-1709.jar", "     version=1", "     metadata.repository.factory.order=content.xml", "     artifact.repository.factory.order=artifacts.xml", "INSTALL 2", "HEAD http://127.0.0.1/cdo/content.jar", "HEAD http://127.0.0.1/cdo/content.xml", "HEAD http://127.0.0.1/cdo/content.xml.xz", "HEAD http://127.0.0.1/cdo/compositeContent.jar", "HEAD http://127.0.0.1/cdo/compositeContent.xml", "GET  http://127.0.0.1/cdo/compositeContent.xml", "GET  http://127.0.0.1/cdo/child/p2.index", "HEAD http://127.0.0.1/cdo/child/content.jar", "GET  http://127.0.0.1/cdo/child/content.jar", "HEAD http://127.0.0.1/cdo/artifacts.jar", "HEAD http://127.0.0.1/cdo/artifacts.xml", "HEAD http://127.0.0.1/cdo/artifacts.xml.xz", "HEAD http://127.0.0.1/cdo/compositeArtifacts.jar", "HEAD http://127.0.0.1/cdo/compositeArtifacts.xml", "GET  http://127.0.0.1/cdo/compositeArtifacts.xml", "HEAD http://127.0.0.1/cdo/child/artifacts.jar", "GET  http://127.0.0.1/cdo/child/artifacts.jar", "GET  http://127.0.0.1/cdo/child/plugins/org.eclipse.net4j.util_3.3.1.v20140218-1709.jar", "     version=1", "     metadata.repository.factory.order=compositeContent.xml", "     artifact.repository.factory.order=compositeArtifacts.xml");
    }

    @Test
    public void test_8_SimpleToCompositeWithIndex() throws Exception {
        List<String> results = this.test(false, true, true);
        this.assertResults(results, "INSTALL 1", "GET  http://127.0.0.1/cdo/p2.index", "HEAD http://127.0.0.1/cdo/content.jar", "GET  http://127.0.0.1/cdo/content.jar", "HEAD http://127.0.0.1/cdo/artifacts.jar", "GET  http://127.0.0.1/cdo/artifacts.jar", "GET  http://127.0.0.1/cdo/plugins/org.eclipse.net4j.util_3.3.1.v20140218-1709.jar", "     version=1", "     metadata.repository.factory.order=content.xml", "     artifact.repository.factory.order=artifacts.xml", "INSTALL 2", "HEAD http://127.0.0.1/cdo/content.jar", "HEAD http://127.0.0.1/cdo/content.xml", "HEAD http://127.0.0.1/cdo/content.xml.xz", "HEAD http://127.0.0.1/cdo/compositeContent.jar", "HEAD http://127.0.0.1/cdo/compositeContent.xml", "GET  http://127.0.0.1/cdo/compositeContent.xml", "GET  http://127.0.0.1/cdo/child/p2.index", "HEAD http://127.0.0.1/cdo/child/content.jar", "GET  http://127.0.0.1/cdo/child/content.jar", "HEAD http://127.0.0.1/cdo/artifacts.jar", "HEAD http://127.0.0.1/cdo/artifacts.xml", "HEAD http://127.0.0.1/cdo/artifacts.xml.xz", "HEAD http://127.0.0.1/cdo/compositeArtifacts.jar", "HEAD http://127.0.0.1/cdo/compositeArtifacts.xml", "GET  http://127.0.0.1/cdo/compositeArtifacts.xml", "HEAD http://127.0.0.1/cdo/child/artifacts.jar", "GET  http://127.0.0.1/cdo/child/artifacts.jar", "GET  http://127.0.0.1/cdo/child/plugins/org.eclipse.net4j.util_3.3.1.v20140218-1709.jar", "     version=1", "     metadata.repository.factory.order=compositeContent.xml", "     artifact.repository.factory.order=compositeArtifacts.xml");
    }

    private static final class CountingTransport
    extends Transport {
        private final Transport delegate;
        private final List<String> requests = new ArrayList<String>();

        private CountingTransport(Transport delegate) {
            this.delegate = delegate;
        }

        public List<String> getRequests() {
            return this.requests;
        }

        public IStatus download(URI uri, OutputStream target, long startPos, IProgressMonitor monitor) {
            this.requests.add("GET  " + uri);
            return this.delegate.download(uri, target, startPos, monitor);
        }

        public IStatus download(URI uri, OutputStream target, IProgressMonitor monitor) {
            this.requests.add("GET  " + uri);
            return this.delegate.download(uri, target, monitor);
        }

        public InputStream stream(URI uri, IProgressMonitor monitor) throws FileNotFoundException, CoreException, AuthenticationFailedException {
            this.requests.add("GET  " + uri);
            return this.delegate.stream(uri, monitor);
        }

        public long getLastModified(URI uri, IProgressMonitor monitor) throws CoreException, FileNotFoundException, AuthenticationFailedException {
            this.requests.add("HEAD " + uri);
            return this.delegate.getLastModified(uri, monitor);
        }

        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public String toString() {
            return this.requests.toString();
        }
    }
}

