/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.util;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StringExpander {
    public static final Pattern STRING_EXPANSION_PATTERN = Pattern.compile("\\$(\\{([^${}|/]+)(\\|([^{}/]+))?([^{}]*)}|\\$)");
    static final String[] CONTROL_CHARACTER_REPLACEMENTS = new String[]{"${0x0}", "${0x1}", "${0x2}", "${0x3}", "${0x4}", "${0x5}", "${0x6}", "${0x7}", "${0x8}", "${0x9}", "${0xA}", "${0xB}", "${0xC}", "${0xD}", "${0xE}", "${0xF}", "${0x10}", "${0x11}", "${0x12}", "${0x13}", "${0x14}", "${0x15}", "${0x16}", "${0x17}", "${0x18}", "${0x19}", "${0x1A}", "${0x1B}", "${0x1C}", "${0x1D}", "${0x1E}", "${0x1F}"};
    private static boolean NEEDS_PATH_SEPARATOR_CONVERSION = File.separatorChar == '\\';
    protected static final Map<String, String> CONTROL_CHARACTER_VALUES = new HashMap<String, String>();

    static {
        int i = 0;
        int length = CONTROL_CHARACTER_REPLACEMENTS.length;
        while (i < length) {
            CONTROL_CHARACTER_VALUES.put(CONTROL_CHARACTER_REPLACEMENTS[i].substring(2, 5), Character.toString((char)i));
            ++i;
        }
    }

    protected static String resolve(StringExpander stringExpander, String key) {
        return stringExpander.resolve(key);
    }

    protected static boolean isUnexpanded(StringExpander stringExpander, String key) {
        return stringExpander.isUnexpanded(key);
    }

    protected static String filter(StringExpander stringExpander, String value, String filterName) {
        return stringExpander.filter(value, filterName);
    }

    protected abstract String resolve(String var1);

    protected abstract boolean isUnexpanded(String var1);

    protected abstract String filter(String var1, String var2);

    public String expandString(String string) {
        return this.expandString(string, null);
    }

    public String expandString(String string, Set<String> keys) {
        if (string == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        int previous = 0;
        boolean unresolved = false;
        Matcher matcher = STRING_EXPANSION_PATTERN.matcher(string);
        while (matcher.find()) {
            result.append(string.substring(previous, matcher.start()));
            String key = matcher.group(1);
            if ("$".equals(key)) {
                result.append('$');
            } else {
                boolean isUnexpanded;
                String value;
                key = matcher.group(2);
                String suffix = matcher.group(5);
                if (NEEDS_PATH_SEPARATOR_CONVERSION) {
                    suffix = suffix.replace('/', File.separatorChar);
                }
                String string2 = value = (isUnexpanded = this.isUnexpanded(key)) ? null : this.resolve(key);
                if (value == null) {
                    if (keys != null) {
                        unresolved = true;
                        if (!isUnexpanded) {
                            keys.add(key);
                        }
                    } else if (!unresolved) {
                        result.append(matcher.group());
                    }
                } else {
                    String filters = matcher.group(4);
                    if (filters != null) {
                        String[] stringArray = filters.split("\\|");
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String filterName = stringArray[n2];
                            if ((value = this.filter(value, filterName)) == null) {
                                if (keys != null) {
                                    unresolved = true;
                                    if (!isUnexpanded) {
                                        keys.add(key);
                                    }
                                } else if (!unresolved) {
                                    result.append(matcher.group());
                                }
                            }
                            ++n2;
                        }
                    }
                    if (!unresolved) {
                        result.append(value);
                        result.append(suffix);
                    }
                }
            }
            previous = matcher.end();
        }
        if (unresolved) {
            return null;
        }
        result.append(string.substring(previous));
        return result.toString();
    }
}

