/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.presentation.handlers;

import java.net.URL;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.oomph.base.provider.BaseEditUtil;
import org.eclipse.oomph.setup.Index;
import org.eclipse.oomph.setup.ProductCatalog;
import org.eclipse.oomph.setup.ProductVersion;
import org.eclipse.oomph.setup.Project;
import org.eclipse.oomph.setup.ProjectCatalog;
import org.eclipse.oomph.setup.SetupFactory;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.Stream;
import org.eclipse.oomph.setup.User;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.presentation.handlers.AbstractDropdownHandler;
import org.eclipse.oomph.setup.provider.SetupEditPlugin;
import org.eclipse.oomph.setup.ui.SetupEditorSupport;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class OpenEditorDropdownHandler
extends AbstractDropdownHandler {
    public static final String COMMAND_ID = "org.eclipse.oomph.setup.editor.openEditorDropdown";

    public OpenEditorDropdownHandler() {
        super(COMMAND_ID);
    }

    protected AbstractDropdownHandler.ActionDescriptor createActionDescriptor() throws Exception {
        final User user = SetupFactory.eINSTANCE.createUser();
        ((InternalEObject)user).eSetProxyURI(SetupContext.USER_SETUP_URI.appendFragment("/"));
        ComposedAdapterFactory adapterFactory = BaseEditUtil.createAdapterFactory();
        ItemProviderAdapter labelProvider = (ItemProviderAdapter)adapterFactory.adapt((Notifier)user, IItemLabelProvider.class);
        ImageDescriptor imageDescriptor = OpenEditorDropdownHandler.getLabelImage(labelProvider, (EObject)user);
        String text = OpenEditorDropdownHandler.getLabelText(labelProvider, (EObject)user);
        Runnable runnable = new Runnable(){

            public void run() {
                OpenEditorDropdownHandler.openEditor((EObject)user);
            }
        };
        return new AbstractDropdownHandler.ActionDescriptor(imageDescriptor, text, runnable);
    }

    public static ImageDescriptor getLabelImage(ItemProviderAdapter labelProvider, EObject object) {
        Object key = labelProvider.getImage((Object)object);
        if (key instanceof ComposedImage) {
            ComposedImage composedImage = (ComposedImage)key;
            List images = composedImage.getImages();
            key = images.get(0);
        }
        return ImageDescriptor.createFromURL((URL)((URL)key));
    }

    public static String getLabelText(ItemProviderAdapter itemProvider, EObject object) {
        EClass eClass = object.eClass();
        if (eClass == SetupPackage.Literals.USER || eClass == SetupPackage.Literals.INSTALLATION || eClass == SetupPackage.Literals.WORKSPACE) {
            return "Open " + SetupEditPlugin.getPlugin().getString("_UI_" + eClass.getName() + "_type");
        }
        if (object instanceof ProductVersion) {
            ProductVersion version = (ProductVersion)object;
            return "Open " + itemProvider.getText((Object)version.getProduct()) + " - " + itemProvider.getText((Object)version);
        }
        if (object instanceof Stream) {
            StringBuilder builder = new StringBuilder("Open ");
            OpenEditorDropdownHandler.getLabel(itemProvider, builder, ((Stream)object).getProject());
            builder.append(itemProvider.getText((Object)object));
            return builder.toString();
        }
        if (object instanceof ProjectCatalog) {
            return "Open Project Catalog " + itemProvider.getText((Object)object);
        }
        if (object instanceof ProductCatalog) {
            return "Open Product Catalog " + itemProvider.getText((Object)object);
        }
        if (object instanceof Index) {
            return "Open Catalog " + itemProvider.getText((Object)object);
        }
        return "Open " + itemProvider.getText((Object)object);
    }

    private static void getLabel(ItemProviderAdapter itemProvider, StringBuilder builder, Project project) {
        Project parentProject = project.getParentProject();
        if (parentProject != null) {
            OpenEditorDropdownHandler.getLabel(itemProvider, builder, parentProject);
        }
        builder.append(itemProvider.getText((Object)project));
        builder.append(" - ");
    }

    public static void openEditor(EObject object) {
        URI uri = EcoreUtil.getURI((EObject)object);
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        SetupEditorSupport.getEditor((IWorkbenchPage)page, (URI)uri, (boolean)true, (SetupEditorSupport.LoadHandler[])new SetupEditorSupport.LoadHandler[0]);
    }
}

