/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.internal.osgi.weaving;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.objectteams.otequinox.AspectPermission;
import org.eclipse.objectteams.otequinox.TransformerPlugin;

public class ForcedExportsDelegate {
    Class<?> registryClass;
    Method getForcedExportsByAspect;
    Method parseForcedExportsFile;

    public ForcedExportsDelegate() {
        try {
            this.registryClass = this.getClass().getClassLoader().loadClass("org.eclipse.objectteams.otequinox.turbo.ForcedExportsRegistry");
            this.getForcedExportsByAspect = this.registryClass.getMethod("getForcedExportsByAspect", String.class, Integer.TYPE);
            this.parseForcedExportsFile = this.registryClass.getMethod("parseForcedExportsFile", File.class, Integer.TYPE);
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
    }

    public boolean isAvailable() {
        return this.registryClass != null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NonNullByDefault
    public List<@NonNull String[]> getForcedExportsByAspect(String aspectBundleId, AspectPermission perm) {
        if (this.getForcedExportsByAspect != null) {
            try {
                @NonNull @NonNull List result = (List)this.getForcedExportsByAspect.invoke(null, aspectBundleId, perm.ordinal());
                return result;
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
                TransformerPlugin.log(e, "Failed to access forced exports");
            }
        }
        return Collections.emptyList();
    }

    public void parseForcedExportsFile(File configFile, AspectPermission perm) {
        if (this.parseForcedExportsFile != null) {
            try {
                this.parseForcedExportsFile.invoke(null, configFile, perm.ordinal());
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
                TransformerPlugin.log(e, "Failed to access forced exports file");
            }
        }
    }
}

