/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otequinox.turbo;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Dictionary;
import org.eclipse.objectteams.otequinox.turbo.ForcedExportsRegistry;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.framework.util.Headers;
import org.eclipse.osgi.internal.hookregistry.HookConfigurator;
import org.eclipse.osgi.internal.hookregistry.HookRegistry;
import org.eclipse.osgi.internal.hookregistry.StorageHookFactory;
import org.eclipse.osgi.storage.BundleInfo;
import org.osgi.framework.BundleException;

public class OTStorageHook
extends StorageHookFactory<Object, Object, StorageHookImpl>
implements HookConfigurator {
    private FrameworkLog fwLog;

    public void addHooks(HookRegistry hookRegistry) {
        hookRegistry.addStorageHookFactory((StorageHookFactory)this);
        this.fwLog = hookRegistry.getContainer().getLogServices().getFrameworkLog();
        ForcedExportsRegistry.install(this.fwLog);
    }

    protected StorageHookImpl createStorageHook(BundleInfo.Generation generation) {
        return new StorageHookImpl(generation);
    }

    public int getStorageVersion() {
        return 0;
    }

    public boolean isCompatibleWith(int version) {
        return false;
    }

    class StorageHookImpl
    extends StorageHookFactory.StorageHook<Object, Object> {
        public StorageHookImpl(BundleInfo.Generation generation) {
            super(generation, OTStorageHook.class);
        }

        public void initialize(Dictionary<String, String> manifest) throws BundleException {
            String packages;
            String[] id = manifest.get("Bundle-SymbolicName").split(";");
            if (id.length > 0 && (packages = ForcedExportsRegistry.getGrantedForcedExportsByBase(id[0])) != null && !packages.isEmpty()) {
                Object exportedPackages = manifest.get("Export-Package");
                exportedPackages = exportedPackages != null && !((String)exportedPackages).isEmpty() ? (String)exportedPackages + "," + packages : packages;
                this.putHeader(id[0], "Export-Package", (String)exportedPackages, packages);
            }
        }

        void putHeader(String id, String header, String value, String added) {
            try {
                BundleInfo.Generation gen = this.getGeneration();
                Method getRawHeaders = gen.getClass().getDeclaredMethod("getRawHeaders", new Class[0]);
                getRawHeaders.setAccessible(true);
                Headers headers = (Headers)getRawHeaders.invoke((Object)gen, new Object[0]);
                Field readOnly = headers.getClass().getDeclaredField("readOnly");
                readOnly.setAccessible(true);
                readOnly.set(headers, false);
                headers.put((Object)header, (Object)value);
                readOnly.setAccessible(false);
                getRawHeaders.setAccessible(false);
                OTStorageHook.this.fwLog.log(new FrameworkLogEntry(OTStorageHook.class.getName(), "OT/Equinox Turbo: added forced export into base bundle " + id + ":\n\t" + added, 1, null, null));
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                OTStorageHook.this.fwLog.log(new FrameworkLogEntry(OTStorageHook.class.getName(), "Unable to inject forced exports", 4, (Throwable)e, null));
            }
        }

        public void load(Object loadContext, DataInputStream is) throws IOException {
        }

        public void save(Object saveContext, DataOutputStream os) throws IOException {
        }
    }
}

