/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.bytecode;

import java.util.Arrays;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileConstants;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.ConstantPoolObject;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.ConstantPoolObjectReader;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Config;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.RoleTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.mappings.CallinImplementorDyn;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.copyinheritance.CopyInheritance;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TypeAnalyzer;

public class ConstantPoolObjectMapper
implements ClassFileConstants {
    private MethodBinding _srcMethod;
    private MethodBinding _dstMethod;

    public ConstantPoolObjectMapper(MethodBinding srcMethodBinding, MethodBinding dstMethodBinding) {
        this._srcMethod = srcMethodBinding.original();
        this._dstMethod = dstMethodBinding.original();
    }

    public ConstantPoolObject mapConstantPoolObject(ConstantPoolObject src_cpo) {
        return this.mapConstantPoolObject(src_cpo, false);
    }

    public ConstantPoolObject mapConstantPoolObject(ConstantPoolObject src_cpo, boolean addMarkerArgAllowed) {
        int type = src_cpo.getType();
        ReferenceBinding dstTeam = ConstantPoolObjectMapper.getTeam(this._dstMethod);
        ReferenceBinding declaringClass = null;
        switch (type) {
            case 10: 
            case 11: {
                declaringClass = src_cpo.getMethodRef().declaringClass;
                break;
            }
            case 9: {
                declaringClass = src_cpo.getFieldRef().declaringClass;
            }
        }
        if (RoleTypeBinding.isRoleWithExplicitAnchor(declaringClass)) {
            return src_cpo;
        }
        switch (type) {
            case 9: {
                return new ConstantPoolObject(9, ConstantPoolObjectMapper.mapField(this._srcMethod, src_cpo.getFieldRef().original(), dstTeam));
            }
            case 10: {
                return new ConstantPoolObject(10, ConstantPoolObjectMapper.mapMethod(this._srcMethod, src_cpo.getMethodRef().original(), this._dstMethod, dstTeam, addMarkerArgAllowed));
            }
            case 11: {
                return new ConstantPoolObject(11, ConstantPoolObjectMapper.mapMethod(this._srcMethod, src_cpo.getMethodRef().original(), this._dstMethod, dstTeam, addMarkerArgAllowed));
            }
            case 7: {
                return new ConstantPoolObject(7, ConstantPoolObjectMapper.mapClass(this._srcMethod, src_cpo.getClassObject(), dstTeam));
            }
        }
        return src_cpo;
    }

    public ConstantPoolObject mapTypeUtf8(TypeBinding typeBinding, boolean useGenerics) {
        char[] signature;
        char[] prefix = null;
        if (typeBinding.isArrayType()) {
            ArrayBinding array = (ArrayBinding)typeBinding;
            prefix = new char[array.dimensions()];
            Arrays.fill(prefix, '[');
            typeBinding = array.leafComponentType;
        }
        if (typeBinding.isClass() || typeBinding.isInterface()) {
            ConstantPoolObject clazzCPO = new ConstantPoolObject(7, ConstantPoolObjectMapper.mapClass(this._srcMethod, typeBinding, ConstantPoolObjectMapper.getTeam(this._dstMethod)));
            typeBinding = clazzCPO.getClassObject();
        }
        char[] cArray = signature = useGenerics ? typeBinding.genericTypeSignature() : typeBinding.signature();
        if (prefix != null) {
            signature = CharOperation.concat(prefix, signature);
        }
        return new ConstantPoolObject(1, signature);
    }

    private static TypeBinding mapClass(MethodBinding srcMethod, TypeBinding typeBinding, ReferenceBinding dstTeam) {
        return ConstantPoolObjectMapper.mapClass(ConstantPoolObjectMapper.getTeam(srcMethod), typeBinding, dstTeam);
    }

    public static TypeBinding mapClass(ReferenceBinding srcTeamBinding, TypeBinding typeBinding, ReferenceBinding dstTeam) {
        ReferenceBinding refTeamBinding;
        ReferenceBinding refTypeBinding;
        boolean isArrayBinding = typeBinding instanceof ArrayBinding;
        int dimension = 0;
        TypeBinding originalType = typeBinding;
        if (isArrayBinding) {
            ArrayBinding formerType = (ArrayBinding)typeBinding;
            typeBinding = formerType.leafComponentType();
            dimension = formerType.dimensions;
            if (typeBinding.isBaseType()) {
                return formerType;
            }
        }
        if (ConstantPoolObjectMapper.isMappableClass(refTypeBinding = (ReferenceBinding)typeBinding) && (refTeamBinding = ConstantPoolObjectMapper.getTeam(refTypeBinding = (ReferenceBinding)refTypeBinding.erasure())) != null && srcTeamBinding != null) {
            srcTeamBinding = (ReferenceBinding)srcTeamBinding.erasure();
            TypeBinding newBinding = null;
            ReferenceBinding currentSrcTeam = srcTeamBinding;
            ReferenceBinding currentDstTeam = dstTeam;
            while (currentSrcTeam != null && currentDstTeam != null) {
                if (TypeBinding.equalsEquals(refTeamBinding, currentSrcTeam)) {
                    if (TypeBinding.equalsEquals(refTypeBinding, refTeamBinding) && refTypeBinding.isRole()) {
                        newBinding = currentDstTeam;
                        break;
                    }
                    newBinding = ConstantPoolObjectMapper.searchRoleClass(refTypeBinding, currentDstTeam);
                    break;
                }
                ReferenceBinding srcBase = currentSrcTeam.baseclass();
                if (srcBase != null && (srcBase.isTeam() || srcBase.isRole()) && (newBinding = TypeBinding.equalsEquals(srcBase, refTypeBinding) ? currentDstTeam.baseclass() : ConstantPoolObjectMapper.searchRoleClass(refTypeBinding, currentDstTeam.baseclass())) != null || !currentSrcTeam.isRole()) break;
                currentSrcTeam = currentSrcTeam.enclosingType();
                currentDstTeam = currentDstTeam.enclosingType();
            }
            if (newBinding != null) {
                if (isArrayBinding) {
                    try {
                        newBinding = new ArrayBinding(newBinding, dimension, Config.getLookupEnvironment());
                    }
                    catch (Config.NotConfiguredException e) {
                        e.logWarning("Cannot create array binding");
                    }
                }
                return newBinding;
            }
        }
        return originalType;
    }

    public static FieldBinding mapField(MethodBinding srcMethod, FieldBinding refFieldBinding, ReferenceBinding dstTeam) {
        if (dstTeam != null && ConstantPoolObjectMapper.isMappableField(refFieldBinding)) {
            ReferenceBinding srcTeamBinding;
            FieldBinding dstField;
            RoleModel role;
            if (refFieldBinding.isSynthetic() && (role = ((ReferenceBinding)ConstantPoolObjectMapper.mapClass((MethodBinding)srcMethod, (TypeBinding)refFieldBinding.declaringClass, (ReferenceBinding)dstTeam)).roleModel) != null && (dstField = role.mapSyntheticField(refFieldBinding)) != null) {
                return dstField;
            }
            ReferenceBinding refTeamBinding = ConstantPoolObjectMapper.getTeam(refFieldBinding);
            if (refTeamBinding != null && (srcTeamBinding = ConstantPoolObjectMapper.getTeam(srcMethod)) != null && TypeBinding.equalsEquals(refTeamBinding, srcTeamBinding)) {
                ReferenceBinding updatedClass;
                FieldBinding newBinding = ConstantPoolObjectMapper.searchRoleField(refFieldBinding, dstTeam);
                if (newBinding != null && TypeBinding.notEquals(newBinding.declaringClass, dstTeam) && !TeamModel.isTeamContainingRole(dstTeam, newBinding.declaringClass) && TypeBinding.notEquals(newBinding.declaringClass, updatedClass = (ReferenceBinding)ConstantPoolObjectMapper.mapClass(srcMethod, (TypeBinding)newBinding.declaringClass, dstTeam))) {
                    newBinding = new FieldBinding(newBinding, updatedClass);
                }
                return newBinding;
            }
        }
        return refFieldBinding;
    }

    public static MethodBinding mapMethod(MethodBinding srcMethod, MethodBinding refMethodBinding, MethodBinding dstMethod, ReferenceBinding dstTeam) {
        return ConstantPoolObjectMapper.mapMethod(srcMethod, refMethodBinding, dstMethod, dstTeam, false);
    }

    public static MethodBinding mapMethod(MethodBinding srcMethod, MethodBinding refMethodBinding, MethodBinding dstMethod, ReferenceBinding dstTeam, boolean addMarkerArgAllowed) {
        if (dstMethod != null) {
            if (dstMethod.model != null && dstMethod.model.oldSelfcall == refMethodBinding) {
                return dstMethod.model.adjustedSelfcall;
            }
            if (ConstantPoolObjectMapper.isConfinedSuperCtor(srcMethod, refMethodBinding)) {
                return ConstantPoolObjectMapper.getConfinedSuperCtor(dstMethod);
            }
        }
        if (ConstantPoolObjectMapper.isMappableMethod(refMethodBinding)) {
            MethodBinding foundMethod;
            RoleModel role;
            if (refMethodBinding.isSynthetic() && (role = ((ReferenceBinding)ConstantPoolObjectMapper.mapClass((MethodBinding)srcMethod, (TypeBinding)refMethodBinding.declaringClass, (ReferenceBinding)dstTeam)).roleModel) != null && (foundMethod = role.mapSyntheticMethod(refMethodBinding)) != null) {
                return foundMethod;
            }
            boolean isDecapsAccessor = false;
            if (CharOperation.prefixEquals(IOTConstants.OT_DECAPS, refMethodBinding.selector)) {
                refMethodBinding = new MethodBinding(refMethodBinding, refMethodBinding.declaringClass);
                refMethodBinding.selector = CharOperation.subarray(refMethodBinding.selector, IOTConstants.OT_DECAPS.length, -1);
                isDecapsAccessor = true;
            }
            if ((foundMethod = ConstantPoolObjectMapper.doMapMethod(srcMethod, refMethodBinding, dstMethod, dstTeam, addMarkerArgAllowed)) != null && isDecapsAccessor) {
                foundMethod = new MethodBinding(foundMethod, foundMethod.declaringClass);
                foundMethod.selector = CharOperation.concat(IOTConstants.OT_DECAPS, foundMethod.selector);
            }
            return foundMethod;
        }
        return refMethodBinding;
    }

    static MethodBinding doMapMethod(MethodBinding srcMethod, MethodBinding refMethodBinding, MethodBinding dstMethod, ReferenceBinding dstTeam, boolean addMarkerArgAllowed) {
        ReferenceBinding refTeamBinding = ConstantPoolObjectMapper.getTeam(refMethodBinding);
        if (refTeamBinding != null) {
            MethodBinding newBinding;
            refTeamBinding = (ReferenceBinding)refTeamBinding.erasure();
            ReferenceBinding srcTeamBinding = ConstantPoolObjectMapper.getTeam(srcMethod);
            if (srcTeamBinding != null && srcTeamBinding.isCompatibleWith(refTeamBinding) && dstTeam != null && (newBinding = ConstantPoolObjectMapper.searchRoleMethodInTeam(dstTeam, refMethodBinding, addMarkerArgAllowed)) != null) {
                return newBinding;
            }
        }
        return refMethodBinding;
    }

    private static boolean isConfinedSuperCtor(MethodBinding srcMethod, MethodBinding refMethodBinding) {
        if (!refMethodBinding.isConstructor()) {
            return false;
        }
        if (!CharOperation.equals(refMethodBinding.declaringClass.compoundName, IOTConstants.ORG_OBJECTTEAMS_TEAM_OTCONFINED)) {
            return false;
        }
        if (TypeBinding.equalsEquals(refMethodBinding.declaringClass, srcMethod.declaringClass.superclass())) {
            return true;
        }
        return srcMethod.declaringClass.superclass() == null && CharOperation.equals(IOTConstants.ORG_OBJECTTEAMS_TEAM_OTCONFINED, refMethodBinding.declaringClass.compoundName);
    }

    private static MethodBinding getConfinedSuperCtor(MethodBinding dstMethod) {
        ReferenceBinding newSuperclass = dstMethod.declaringClass.superclass();
        if (newSuperclass == null) {
            throw new InternalCompilerError("copying byte code to class without superclass?");
        }
        return newSuperclass.getExactConstructor(new TypeBinding[0]);
    }

    private static FieldBinding searchRoleField(FieldBinding refFieldBinding, ReferenceBinding dstTeamBinding) {
        ReferenceBinding refRoleBinding = refFieldBinding.declaringClass;
        if (ConstantPoolObjectMapper.isMappableClass(refRoleBinding)) {
            ReferenceBinding dstRefRoleBinding = ConstantPoolObjectMapper.searchRoleClass(refRoleBinding, dstTeamBinding);
            return ConstantPoolObjectReader.findFieldByBinding(dstRefRoleBinding, refFieldBinding);
        }
        return null;
    }

    private static MethodBinding searchRoleMethodInTeam(ReferenceBinding dstTeam, MethodBinding refMethod, boolean addMarkerArgAllowed) {
        ReferenceBinding refRoleBinding = refMethod.declaringClass;
        if (ConstantPoolObjectMapper.isMappableClass(refRoleBinding)) {
            ReferenceBinding dstRefRoleBinding = ConstantPoolObjectMapper.searchRoleClass(refRoleBinding, dstTeam);
            MethodBinding roleMethod = ConstantPoolObjectMapper.searchRoleMethodInRole(dstRefRoleBinding, refMethod, addMarkerArgAllowed);
            if (roleMethod != null) {
                return roleMethod;
            }
            if (dstRefRoleBinding.isCompatibleWith(refRoleBinding) || ConstantPoolObjectReader.isFakedOTREMethod(refMethod.selector) != 0) {
                return new MethodBinding(refMethod, dstRefRoleBinding);
            }
        } else if (ConstantPoolObjectMapper.isStaticBasecallSurrogate(refMethod)) {
            MethodBinding[] methods = dstTeam.getMethods(refMethod.selector);
            int i = 0;
            while (i < methods.length) {
                if (methods[i].parameters.length == refMethod.parameters.length) {
                    int j = 0;
                    while (j < methods[i].parameters.length) {
                        if (TypeBinding.notEquals(methods[i].parameters[j], refMethod.parameters[j])) {
                            // empty if block
                        }
                        ++j;
                    }
                    return methods[i];
                }
                ++i;
            }
            return refMethod;
        }
        return null;
    }

    private static MethodBinding searchRoleMethodInRole(ReferenceBinding role, MethodBinding refMethod, boolean addMarkerArgAllowed) {
        MethodBinding result;
        if (CopyInheritance.isCreator(refMethod)) {
            MethodBinding[] methods = role.getMethods(refMethod.selector);
            assert (methods.length == 1);
            return methods[0];
        }
        if (role.isLocalType() && CharOperation.equals(refMethod.selector, IOTConstants.INIT_METHOD_NAME)) {
            return role.getMethods(IOTConstants.INIT_METHOD_NAME)[0];
        }
        int bestRank = Integer.MAX_VALUE;
        MethodBinding bestMethod = null;
        MethodBinding[] methods = role.getMethods(refMethod.selector);
        int i = 0;
        while (i < methods.length) {
            if (refMethod.parameters.length == methods[i].parameters.length || addMarkerArgAllowed && refMethod.parameters.length + 1 == methods[i].parameters.length) {
                int rank = ConstantPoolObjectMapper.rankMethod(refMethod, methods[i], 0);
                if (rank < bestRank) {
                    bestMethod = methods[i];
                    bestRank = rank;
                } else if (CharOperation.equals(CallinImplementorDyn.OT_CALL_AFTER, methods[i].selector) || CharOperation.equals(CallinImplementorDyn.OT_CALL_BEFORE, methods[i].selector)) {
                    return methods[i];
                }
            }
            ++i;
        }
        if (bestMethod != null) {
            return bestMethod;
        }
        if (role.superclass() != null && !CharOperation.equals(role.superclass().compoundName, TypeConstants.JAVA_LANG_OBJECT) && ConstantPoolObjectMapper.haveCommonEnclosingType(role.superclass(), role) && (result = ConstantPoolObjectMapper.searchRoleMethodInRole(role.superclass(), refMethod, addMarkerArgAllowed)) != null) {
            return result;
        }
        ReferenceBinding[] superInterfaces = role.superInterfaces();
        if (superInterfaces != null) {
            int i2 = 0;
            while (i2 < superInterfaces.length) {
                MethodBinding binding;
                if (ConstantPoolObjectMapper.haveCommonEnclosingType(superInterfaces[i2], role.enclosingType()) && (binding = ConstantPoolObjectMapper.searchRoleMethodInRole(superInterfaces[i2], refMethod, addMarkerArgAllowed)) != null) {
                    return binding;
                }
                ++i2;
            }
        }
        return null;
    }

    private static boolean haveCommonEnclosingType(ReferenceBinding left, ReferenceBinding right) {
        ReferenceBinding leftEnclosing = left.enclosingType();
        ReferenceBinding rightEnclosing = right.enclosingType();
        if (leftEnclosing == null || rightEnclosing == null) {
            return false;
        }
        if (TypeBinding.equalsEquals(leftEnclosing, rightEnclosing)) {
            return true;
        }
        return ConstantPoolObjectMapper.haveCommonEnclosingType(leftEnclosing, rightEnclosing);
    }

    private static int rankMethod(MethodBinding toLookFor, MethodBinding candidate, int currentRank) {
        int rank;
        ++currentRank;
        if (candidate == null || toLookFor == null) {
            return Integer.MAX_VALUE;
        }
        toLookFor = toLookFor.original();
        if ((candidate = candidate.original()) == toLookFor) {
            return currentRank;
        }
        if (currentRank > 0 && (candidate.modifiers & 0x40) != 0) {
            MethodBinding[] otherMethods;
            MethodBinding[] methodBindingArray = otherMethods = candidate.declaringClass.getMethods(candidate.selector);
            int n = otherMethods.length;
            int n2 = 0;
            while (n2 < n) {
                block15: {
                    MethodBinding other = methodBindingArray[n2];
                    if (other != candidate && other.parameters.length == candidate.parameters.length) {
                        int i = 0;
                        while (i < other.parameters.length) {
                            if (!TypeBinding.notEquals(other.parameters[i], candidate.parameters[i])) {
                                ++i;
                                continue;
                            }
                            break block15;
                        }
                        if (other != toLookFor) break;
                        return currentRank;
                    }
                }
                ++n2;
            }
        }
        if ((rank = ConstantPoolObjectMapper.rankMethod(toLookFor, candidate.copyInheritanceSrc, currentRank)) < Integer.MAX_VALUE) {
            return rank;
        }
        rank = ConstantPoolObjectMapper.rankMethod(toLookFor.copyInheritanceSrc, candidate, currentRank);
        if (rank < Integer.MAX_VALUE) {
            return rank;
        }
        if (candidate.overriddenTSupers != null) {
            int i = 0;
            while (i < candidate.overriddenTSupers.length) {
                rank = ConstantPoolObjectMapper.rankMethod(toLookFor, candidate.overriddenTSupers[i], currentRank);
                if (rank < Integer.MAX_VALUE) {
                    return rank;
                }
                ++i;
            }
        }
        if (toLookFor.overriddenTSupers != null) {
            int i = 0;
            while (i < toLookFor.overriddenTSupers.length) {
                rank = ConstantPoolObjectMapper.rankMethod(toLookFor.overriddenTSupers[i], candidate, currentRank);
                if (rank < Integer.MAX_VALUE) {
                    return rank;
                }
                ++i;
            }
        }
        return Integer.MAX_VALUE;
    }

    private static ReferenceBinding getTeam(MethodBinding binding) {
        return ConstantPoolObjectMapper.getTeam(binding.declaringClass);
    }

    private static ReferenceBinding getTeam(FieldBinding binding) {
        return ConstantPoolObjectMapper.getTeam(binding.declaringClass);
    }

    private static ReferenceBinding getTeam(ReferenceBinding binding) {
        if (binding.isTeam()) {
            return binding;
        }
        return TeamModel.getEnclosingTeam(binding);
    }

    private static boolean isMappableMethod(MethodBinding refMethodBinding) {
        if (ConstantPoolObjectMapper.isMappableClass(refMethodBinding.declaringClass)) {
            return true;
        }
        return ConstantPoolObjectMapper.isStaticBasecallSurrogate(refMethodBinding);
    }

    private static boolean isStaticBasecallSurrogate(MethodBinding refMethodBinding) {
        return CharOperation.endsWith(refMethodBinding.selector, "$base".toCharArray()) && !refMethodBinding.declaringClass.isRole();
    }

    private static boolean isMappableField(FieldBinding refFieldBinding) {
        return ConstantPoolObjectMapper.isMappableClass(refFieldBinding.declaringClass);
    }

    public static boolean isMappableClass(ReferenceBinding type) {
        if (type.isInterface()) {
            return false;
        }
        return TeamModel.getEnclosingTeam(type) != null;
    }

    public static ReferenceBinding searchRoleClass(ReferenceBinding template, ReferenceBinding site) {
        if (!template.isRole()) {
            return template;
        }
        ReferenceBinding srcTeam = TeamModel.getEnclosingTeam(template);
        if (template.isLocalType()) {
            return ConstantPoolObjectMapper.searchRoleClass(template.constantPoolName(), srcTeam, site);
        }
        return ConstantPoolObjectMapper.searchRoleClass(template.internalName(), srcTeam, site);
    }

    private static ReferenceBinding searchRoleClass(char[] roleName, ReferenceBinding srcTeam, ReferenceBinding site) {
        if (site.isLocalType() && CharOperation.equals(site.constantPoolName(), roleName)) {
            return site;
        }
        ReferenceBinding[] members = site.memberTypes();
        ReferenceBinding candidate = null;
        int i = 0;
        while (i < members.length) {
            if (CharOperation.equals(members[i].internalName(), roleName)) {
                if (members[i].isBinaryBinding() && candidate == null) {
                    candidate = members[i];
                } else {
                    return members[i];
                }
            }
            ++i;
        }
        if (candidate != null) {
            return candidate;
        }
        i = 0;
        while (i < members.length) {
            ReferenceBinding result = ConstantPoolObjectMapper.searchRoleClass(roleName, srcTeam, members[i]);
            if (result != null && result.isValidBinding()) {
                return result;
            }
            ++i;
        }
        if (site.isRole()) {
            return site.roleModel.findTypeRelative(TypeAnalyzer.constantPoolNameRelativeToTeam(srcTeam, roleName));
        }
        return null;
    }
}

