/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.util;

import java.util.Arrays;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.MarkerAnnotation;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedThisReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.Wildcard;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.LiftingTypeReference;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.QualifiedBaseReference;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.TypeAnchorReference;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.TypeValueParameter;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.DependentTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.ITeamAnchor;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstGenerator;

public class AstClone {
    public static TypeReference copyTypeReference(TypeReference typeReference, AstGenerator gen) {
        if (typeReference == null) {
            return null;
        }
        if (gen == null) {
            return AstClone.copyTypeReference(typeReference);
        }
        TypeReference result = null;
        int dims = typeReference.dimensions();
        if (typeReference instanceof Wildcard) {
            Wildcard wildcard = (Wildcard)typeReference;
            Wildcard newWildcard = gen.wildcard(wildcard.kind);
            newWildcard.bound = AstClone.copyTypeReference(wildcard.bound);
            result = newWildcard;
        } else if (typeReference instanceof SingleTypeReference) {
            char[] name = ((SingleTypeReference)typeReference).token;
            if (typeReference instanceof ParameterizedSingleTypeReference) {
                ParameterizedSingleTypeReference pTypeReference = (ParameterizedSingleTypeReference)typeReference;
                TypeReference[] newArgs = AstClone.copyTypeArguments(typeReference, gen.pos, pTypeReference.typeArguments);
                result = gen.parameterizedSingleTypeReference(name, newArgs, dims);
            } else {
                result = dims > 0 ? gen.arrayTypeReference(name, dims) : gen.singleTypeReference(name);
            }
        } else if (typeReference instanceof QualifiedTypeReference) {
            QualifiedTypeReference qualifiedTypeReference = (QualifiedTypeReference)typeReference;
            char[][] typeName = CharOperation.deepCopy(qualifiedTypeReference.tokens);
            if (typeReference instanceof ParameterizedQualifiedTypeReference) {
                ParameterizedQualifiedTypeReference pqTypeReference = (ParameterizedQualifiedTypeReference)typeReference;
                int len = pqTypeReference.typeArguments.length;
                TypeReference[][] newArgs = new TypeReference[len][];
                int i = 0;
                while (i < len) {
                    newArgs[i] = AstClone.copyTypeArray(pqTypeReference.typeArguments[i]);
                    ++i;
                }
                result = gen.parameterizedQualifiedTypeReference(typeName, newArgs, dims);
            } else {
                QualifiedTypeReference qualifiedResult = dims > 0 ? gen.qualifiedArrayTypeReference(typeName, dims) : gen.qualifiedTypeReference(typeName);
                qualifiedResult.isGenerated = qualifiedTypeReference.isGenerated;
                result = qualifiedResult;
            }
        } else if (typeReference instanceof LiftingTypeReference) {
            LiftingTypeReference liftingRef = (LiftingTypeReference)typeReference;
            result = gen.liftingTypeReference(AstClone.copyTypeReference(liftingRef.baseReference), AstClone.copyTypeReference(liftingRef.roleReference), liftingRef.roleToken, liftingRef.baseTokens);
        } else if (typeReference instanceof TypeAnchorReference) {
            TypeAnchorReference anchorRef = (TypeAnchorReference)typeReference;
            result = new TypeAnchorReference(AstClone.copyReference(anchorRef.anchor), gen.sourceStart);
        }
        if (result != null) {
            result.setBaseclassDecapsulation(typeReference.getBaseclassDecapsulation());
            result.bits = typeReference.bits;
            return result;
        }
        throw new InternalCompilerError("Unexpected kind of type reference: " + typeReference.getClass().getName());
    }

    public static TypeReference copyTypeReference(TypeReference typeReference) {
        if (typeReference == null) {
            return null;
        }
        TypeReference result = null;
        int dims = typeReference.dimensions();
        if (typeReference instanceof Wildcard) {
            Wildcard wildcard = (Wildcard)typeReference;
            Wildcard newWildcard = new Wildcard(wildcard.kind);
            newWildcard.sourceStart = wildcard.sourceStart;
            newWildcard.sourceEnd = wildcard.sourceEnd;
            newWildcard.bound = AstClone.copyTypeReference(wildcard.bound);
            result = newWildcard;
        } else if (typeReference instanceof SingleTypeReference) {
            char[] name = ((SingleTypeReference)typeReference).token;
            long pos = ((long)typeReference.sourceStart << 32) + (long)typeReference.sourceEnd;
            if (typeReference instanceof ParameterizedSingleTypeReference) {
                ParameterizedSingleTypeReference pTypeReference = (ParameterizedSingleTypeReference)typeReference;
                TypeReference[] newArgs = AstClone.copyTypeArguments(typeReference, pos, pTypeReference.typeArguments);
                result = new ParameterizedSingleTypeReference(name, newArgs, dims, pos);
            } else {
                result = dims > 0 ? new ArrayTypeReference(name, dims, pos) : new SingleTypeReference(name, pos);
            }
        } else if (typeReference instanceof QualifiedTypeReference) {
            QualifiedTypeReference qualifiedTypeReference = (QualifiedTypeReference)typeReference;
            char[][] typeName = CharOperation.deepCopy(qualifiedTypeReference.tokens);
            long[] poss = qualifiedTypeReference.sourcePositions;
            if (typeReference instanceof ParameterizedQualifiedTypeReference) {
                ParameterizedQualifiedTypeReference pqTypeReference = (ParameterizedQualifiedTypeReference)typeReference;
                int len = pqTypeReference.typeArguments.length;
                TypeReference[][] newArgs = new TypeReference[len][];
                int i = 0;
                while (i < len) {
                    newArgs[i] = AstClone.copyTypeArray(pqTypeReference.typeArguments[i]);
                    ++i;
                }
                result = new ParameterizedQualifiedTypeReference(typeName, newArgs, dims, poss);
            } else {
                result = dims > 0 ? new ArrayQualifiedTypeReference(typeName, dims, poss) : new QualifiedTypeReference(typeName, poss);
            }
        } else if (typeReference instanceof LiftingTypeReference) {
            LiftingTypeReference liftingRef = (LiftingTypeReference)typeReference;
            LiftingTypeReference newLiftingRef = new LiftingTypeReference();
            newLiftingRef.baseReference = AstClone.copyTypeReference(liftingRef.baseReference);
            newLiftingRef.roleReference = AstClone.copyTypeReference(liftingRef.roleReference);
            newLiftingRef.sourceStart = liftingRef.sourceStart;
            newLiftingRef.sourceEnd = liftingRef.sourceEnd;
            newLiftingRef.roleToken = liftingRef.roleToken;
            newLiftingRef.baseTokens = new char[liftingRef.baseTokens.length][];
            System.arraycopy(liftingRef.baseTokens, 0, newLiftingRef.baseTokens, 0, liftingRef.baseTokens.length);
            result = newLiftingRef;
        } else if (typeReference instanceof TypeAnchorReference) {
            TypeAnchorReference anchorRef = (TypeAnchorReference)typeReference;
            result = new TypeAnchorReference(AstClone.copyReference(anchorRef.anchor), anchorRef.sourceStart);
        }
        if (result != null) {
            result.setBaseclassDecapsulation(typeReference.getBaseclassDecapsulation());
            result.bits = typeReference.bits;
            result.isGenerated = true;
            return result;
        }
        throw new InternalCompilerError("Unexpected kind of type reference: " + typeReference.getClass().getName());
    }

    public static TypeReference[] copyTypeArguments(TypeReference typeReference, long pos, TypeReference[] arguments) {
        DependentTypeBinding dependentTypeBinding;
        TypeReference[] newArgs = AstClone.copyTypeArray(arguments);
        if (typeReference.resolvedType != null && typeReference.resolvedType instanceof DependentTypeBinding && (dependentTypeBinding = (DependentTypeBinding)typeReference.resolvedType).hasExplicitAnchor()) {
            AstGenerator gen = new AstGenerator(pos);
            ITeamAnchor anchor = dependentTypeBinding._teamAnchor;
            TypeAnchorReference anchorRef = gen.typeAnchorReference(anchor);
            int len = newArgs.length;
            TypeReference[] typeReferenceArray = newArgs;
            newArgs = new TypeReference[len + 1];
            System.arraycopy(typeReferenceArray, 0, newArgs, 1, len);
            newArgs[0] = anchorRef;
        }
        return newArgs;
    }

    public static TypeReference[] copyTypeArray(TypeReference[] references) {
        if (references == null) {
            return null;
        }
        TypeReference[] result = new TypeReference[references.length];
        int i = 0;
        while (i < references.length) {
            result[i] = AstClone.copyTypeReference(references[i]);
            ++i;
        }
        return result;
    }

    public static Reference copyReference(Reference nameRef) {
        if (nameRef instanceof SingleNameReference) {
            SingleNameReference singleRef = (SingleNameReference)nameRef;
            return new SingleNameReference(singleRef.token, ((long)singleRef.sourceStart << 32) + (long)singleRef.sourceEnd);
        }
        if (nameRef instanceof QualifiedNameReference) {
            QualifiedNameReference qualRef = (QualifiedNameReference)nameRef;
            return new QualifiedNameReference(qualRef.tokens, qualRef.sourcePositions, qualRef.sourceStart, qualRef.sourceEnd);
        }
        if (nameRef instanceof FieldReference) {
            FieldReference fieldRef = (FieldReference)nameRef;
            FieldReference clone = new FieldReference(fieldRef.token, fieldRef.nameSourcePosition);
            clone.receiver = AstClone.copyReference((Reference)fieldRef.receiver);
            return clone;
        }
        if (nameRef instanceof QualifiedBaseReference) {
            QualifiedBaseReference baseRef = (QualifiedBaseReference)nameRef;
            return new QualifiedBaseReference(AstClone.copyTypeReference(baseRef.qualification), baseRef.sourceStart, baseRef.sourceEnd);
        }
        if (nameRef instanceof QualifiedThisReference) {
            QualifiedThisReference thisRef = (QualifiedThisReference)nameRef;
            return new QualifiedThisReference(AstClone.copyTypeReference(thisRef.qualification), thisRef.sourceStart, thisRef.sourceEnd);
        }
        throw new InternalCompilerError("Unexpected reference type " + nameRef.getClass() + " for " + nameRef);
    }

    public static TypeReference[] copyExceptions(MethodBinding method, AstGenerator gen) {
        TypeBinding[] types = method.thrownExceptions;
        if (types == null || types == Binding.NO_EXCEPTIONS) {
            return null;
        }
        return AstClone.copyTypeArray(types, gen);
    }

    private static TypeReference[] copyTypeArray(TypeBinding[] types, AstGenerator gen) {
        if (types == null) {
            return null;
        }
        TypeReference[] result = new TypeReference[types.length];
        int i = 0;
        while (i < types.length) {
            result[i] = gen.typeReference(types[i]);
            ++i;
        }
        return result;
    }

    public static Argument[] copyArguments(Argument[] arguments, AstGenerator gen) {
        if (arguments == null) {
            return null;
        }
        Argument[] result = new Argument[arguments.length];
        int i = 0;
        while (i < arguments.length) {
            Argument argument = arguments[i];
            result[i] = gen != null ? gen.argument(argument.name, AstClone.copyTypeReference(argument.type, gen), argument.modifiers) : new Argument(argument.name, ((long)argument.sourceStart << 32) + (long)argument.sourceEnd, AstClone.copyTypeReference(argument.type), argument.modifiers);
            if (argument.annotations != null) {
                result[i].annotations = AstClone.copyAnnotations(argument.annotations, gen);
            }
            ++i;
        }
        return result;
    }

    private static Annotation[] copyAnnotations(Annotation[] annotations, AstGenerator gen) {
        int length = annotations.length;
        Annotation[] result = new Annotation[length];
        int count = 0;
        int i = 0;
        while (i < annotations.length) {
            if (annotations[i] instanceof MarkerAnnotation && !(annotations[i].resolvedType != null ? annotations[i].resolvedType.id == 47 : CharOperation.equals(annotations[i].type.getLastToken(), TypeConstants.JAVA_LANG_OVERRIDE[2]))) {
                TypeReference ref = AstClone.copyTypeReference(annotations[i].type);
                result[count++] = new MarkerAnnotation(ref, annotations[i].sourceStart);
            }
            ++i;
        }
        if (count < length) {
            Annotation[] annotationArray = result;
            result = new Annotation[count];
            System.arraycopy(annotationArray, 0, result, 0, count);
        }
        return result;
    }

    public static void copySrcLocation(AbstractMethodDeclaration srcMethod, AbstractMethodDeclaration tgtMethod) {
        tgtMethod.sourceStart = srcMethod.sourceStart;
        tgtMethod.sourceEnd = srcMethod.sourceEnd;
        tgtMethod.declarationSourceStart = srcMethod.declarationSourceStart;
        tgtMethod.declarationSourceEnd = srcMethod.declarationSourceEnd;
        tgtMethod.bodyStart = srcMethod.bodyStart;
        tgtMethod.bodyEnd = srcMethod.bodyEnd;
        tgtMethod.modifiersSourceStart = srcMethod.modifiersSourceStart;
    }

    public static MethodDeclaration copyMethod(TypeDeclaration type, MethodDeclaration md, AstGenerator gen) {
        MethodDeclaration newmethod = new MethodDeclaration(type.compilationResult);
        newmethod.selector = md.selector;
        newmethod.isGenerated = true;
        newmethod.arguments = AstClone.copyArguments(md.arguments, gen);
        newmethod.returnType = AstClone.copyTypeReference(md.returnType, gen);
        newmethod.thrownExceptions = AstClone.copyTypeArray(md.thrownExceptions);
        newmethod.typeParameters = AstClone.copyTypeParameters(md.typeParameters);
        if (md.annotations != null) {
            newmethod.annotations = AstClone.copyAnnotations(md.annotations, gen);
        }
        if (gen != null) {
            gen.setMethodPositions(newmethod);
        } else {
            AstClone.copySrcLocation(md, newmethod);
        }
        return newmethod;
    }

    public static TypeParameter[] copyTypeParameters(TypeParameter[] typeParameters) {
        if (typeParameters == null) {
            return null;
        }
        int len = typeParameters.length;
        TypeParameter[] result = new TypeParameter[len];
        int i = 0;
        while (i < len) {
            if (typeParameters[i] instanceof TypeValueParameter) {
                long poss = (long)typeParameters[i].sourceStart << (int)(32L + (long)typeParameters[i].sourceEnd);
                result[i] = new TypeValueParameter(typeParameters[i].name, poss);
                result[i].declarationSourceStart = typeParameters[i].declarationSourceStart;
            } else {
                result[i] = new TypeParameter();
                result[i].bounds = AstClone.copyTypeArray(typeParameters[i].bounds);
                result[i].bits = typeParameters[i].bits;
                result[i].declarationSourceStart = typeParameters[i].declarationSourceStart;
                result[i].declarationSourceEnd = typeParameters[i].declarationSourceEnd;
                result[i].sourceStart = typeParameters[i].sourceStart;
                result[i].sourceEnd = typeParameters[i].sourceEnd;
                result[i].declarationEnd = typeParameters[i].declarationEnd;
                result[i].name = typeParameters[i].name;
                result[i].type = AstClone.copyTypeReference(typeParameters[i].type);
            }
            ++i;
        }
        return result;
    }

    public static ImportReference copyImportReference(char[][] currentPackageName) {
        int len = currentPackageName.length;
        if (len == 0) {
            return null;
        }
        long[] poss = new long[len];
        Arrays.fill(poss, 0L);
        return new ImportReference(currentPackageName, poss, false, 0);
    }
}

