/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.lifting;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ArrayAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.ArrayReference;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.BinaryExpression;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.ContinueStatement;
import org.eclipse.jdt.internal.compiler.ast.EqualExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.ForStatement;
import org.eclipse.jdt.internal.compiler.ast.IfStatement;
import org.eclipse.jdt.internal.compiler.ast.IntLiteral;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.eclipse.jdt.internal.compiler.ast.PostfixExpression;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.ast.ReturnStatement;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstConverter;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstEdit;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstGenerator;

public abstract class ArrayTranslations {
    private static final char[] ROLE_ARRAY_ARG = "_OT$roleArray".toCharArray();
    BlockScope _scope;
    TypeBinding _providedType;
    TypeBinding _requiredType;
    Expression _teamExpr;
    Expression _expression;
    boolean _isLifting;

    Expression translateArray(BlockScope scope, Expression expression, TypeBinding providedType, TypeBinding requiredType, boolean isLifting, boolean deferredResolve) {
        this._scope = scope;
        this._expression = expression;
        MethodBinding methodBinding = this.ensureTransformMethod(scope, this._teamExpr, providedType, requiredType, isLifting);
        AstGenerator.IRunInScope hook = null;
        if (!isLifting && deferredResolve && expression.resolvedType != null && this._teamExpr.resolvedType == null) {
            hook = new AstGenerator.IRunInScope(){

                @Override
                public void run(BlockScope blockScope) {
                    ArrayTranslations.this._teamExpr.resolve(blockScope);
                }
            };
        }
        AstGenerator gen = new AstGenerator(expression.sourceStart, expression.sourceEnd);
        MessageSend send = hook != null ? gen.messageSendWithResolveHook(this._teamExpr, methodBinding.selector, new Expression[]{expression}, hook) : gen.messageSend(this._teamExpr, methodBinding.selector, new Expression[]{expression});
        send.binding = methodBinding;
        send.actualReceiverType = expression.resolvedType;
        send.resolvedType = methodBinding.returnType;
        send.constant = Constant.NotAConstant;
        return send;
    }

    public MethodBinding ensureTransformMethod(BlockScope scope, Expression teamExpr, TypeBinding providedType, TypeBinding requiredType, boolean isLifting) {
        this._providedType = providedType;
        this._requiredType = requiredType;
        this._isLifting = isLifting;
        this._teamExpr = teamExpr;
        this._scope = scope;
        ReferenceBinding roleType = isLifting ? (ReferenceBinding)requiredType.leafComponentType() : (ReferenceBinding)providedType.leafComponentType();
        char[] transformMethodName = ArrayTranslations.getTransformMethodName(roleType, providedType.dimensions(), isLifting);
        ReferenceBinding enclosingTeam = roleType.enclosingType().getRealType();
        MethodBinding[] transformMethods = enclosingTeam.getMethods(transformMethodName);
        MethodBinding methodBinding = null;
        if (transformMethods != null && transformMethods.length != 0) {
            if (transformMethods.length > 1) {
                throw new InternalCompilerError("duplicate transform methods generated");
            }
            methodBinding = transformMethods[0];
        } else {
            TeamModel teamModel = roleType.roleModel.getTeamModel();
            TypeDeclaration teamDecl = teamModel.getAst();
            if (teamDecl == null) {
                throw new InternalCompilerError("need to create transform method, but have no source type: " + new String(teamModel.getBinding().readableName()));
            }
            MethodDeclaration transformMethod = this.generateTransformArrayMethod(teamDecl, transformMethodName, providedType.dimensions());
            if (teamDecl.isRole()) {
                transformMethod.modifiers |= 1;
            }
            AstEdit.addMethod(teamDecl, transformMethod);
            methodBinding = transformMethod.binding;
            if (teamDecl.isRole()) {
                TypeDeclaration ifcPart = teamDecl.getRoleModel().getInterfaceAst();
                MethodDeclaration ifcMethod = AstConverter.genRoleIfcMethod(ifcPart, transformMethod);
                AstEdit.addMethod(ifcPart, ifcMethod);
                methodBinding = ifcMethod.binding;
            }
        }
        return methodBinding;
    }

    public static char[] getTransformMethodName(ReferenceBinding roleType, int dimensions, boolean isLifting) {
        return CharOperation.concat(CharOperation.concat(isLifting ? IOTConstants._OT_LIFT_TO : IOTConstants.OT_TRANSFORM_ARRAY, roleType.sourceName()), CharOperation.concat(IOTConstants.OT_DOLLAR_NAME, ("" + dimensions).toCharArray()));
    }

    private NameReference decapsulationInput(NameReference nameRef) {
        if (this._isLifting) {
            nameRef.baseclassDecapsulation = Expression.DecapsulationState.REPORTED;
        }
        return nameRef;
    }

    private NameReference decapsulationOutput(NameReference nameRef) {
        if (!this._isLifting) {
            nameRef.baseclassDecapsulation = Expression.DecapsulationState.REPORTED;
        }
        return nameRef;
    }

    private void decapsulationInput(TypeReference typeRef) {
        if (this._isLifting) {
            typeRef.setBaseclassDecapsulation(Expression.DecapsulationState.REPORTED);
        }
    }

    private void decapsulationOutput(TypeReference typeRef) {
        if (!this._isLifting) {
            typeRef.setBaseclassDecapsulation(Expression.DecapsulationState.REPORTED);
        }
    }

    private IfStatement generateIfStatement(int currentDimension, int arrayDimensions) {
        SingleNameReference condLeft = new SingleNameReference(ROLE_ARRAY_ARG, 0L);
        this.decapsulationInput(condLeft);
        Reference lastArrayReference = condLeft;
        int idx = 0;
        while (idx < currentDimension) {
            SingleNameReference pos = new SingleNameReference(ArrayTranslations.generateArrayIndexName(idx), 0L);
            ArrayReference nextArray = new ArrayReference(lastArrayReference, pos);
            lastArrayReference = nextArray;
            ++idx;
        }
        NullLiteral condRight = new NullLiteral(0, 0);
        EqualExpression condition = new EqualExpression(lastArrayReference, condRight, 18);
        Statement thenStatement = null;
        thenStatement = currentDimension == 0 ? new ReturnStatement(new NullLiteral(0, 0), 0, 0) : new ContinueStatement(null, 0, 0);
        IfStatement ifStatement = new IfStatement(condition, thenStatement, 0, 0);
        return ifStatement;
    }

    private static char[] generateArrayIndexName(int dimension) {
        return new String("_OT$").concat("i".concat(String.valueOf(dimension))).toCharArray();
    }

    private ForStatement generateForStatement(int currentDimension, int arrayDimensions, AstGenerator gen) {
        Statement[] init = new Statement[1];
        char[] name = ArrayTranslations.generateArrayIndexName(currentDimension);
        LocalDeclaration initializer = new LocalDeclaration(name, 0, 0);
        initializer.initialization = IntLiteral.buildIntLiteral("0".toCharArray(), 0, 0);
        initializer.type = new SingleTypeReference(TypeConstants.INT, 0L);
        init[0] = initializer;
        SingleNameReference condLeft = new SingleNameReference(name, 0L);
        FieldReference condRight = new FieldReference(IOTConstants.LENGTH, 0L);
        SingleNameReference roleNameReference = gen.singleNameReference(ROLE_ARRAY_ARG);
        this.decapsulationInput(roleNameReference);
        Reference lastArrayReference = roleNameReference;
        int idx = 0;
        while (idx < currentDimension) {
            SingleNameReference pos = new SingleNameReference(ArrayTranslations.generateArrayIndexName(idx), 0L);
            ArrayReference nextArray = new ArrayReference(lastArrayReference, pos);
            lastArrayReference = nextArray;
            ++idx;
        }
        condRight.receiver = lastArrayReference;
        BinaryExpression cond = new BinaryExpression(condLeft, condRight, 4);
        Statement[] inc = new Statement[]{new PostfixExpression(new SingleNameReference(name, 0L), IntLiteral.One, 14, 0)};
        Block action = new Block(0);
        Assignment arrayInstantiation = this.generateArrayInstantiation(currentDimension + 1, arrayDimensions, gen);
        IfStatement ifStatement = this.generateIfStatement(currentDimension + 1, arrayDimensions);
        if (currentDimension < arrayDimensions - 1) {
            ForStatement innerForStatement = this.generateForStatement(currentDimension + 1, arrayDimensions, gen);
            action.statements = new Statement[3];
            action.statements[0] = ifStatement;
            action.statements[1] = arrayInstantiation;
            action.statements[2] = innerForStatement;
        } else {
            action.statements = new Statement[2];
            action.statements[0] = ifStatement;
            action.statements[1] = arrayInstantiation;
        }
        ForStatement outerForStatement = new ForStatement(init, cond, inc, action, true, 0, 0);
        return outerForStatement;
    }

    private Assignment generateArrayInstantiation(int currentDimension, int arrayDimensions, AstGenerator gen) {
        SingleNameReference resultNameReference = new SingleNameReference(IOTConstants.OT_RESULT, 0L);
        this.decapsulationOutput(resultNameReference);
        Reference lastArrayReference = resultNameReference;
        int idx = 0;
        while (idx < currentDimension) {
            SingleNameReference pos = new SingleNameReference(ArrayTranslations.generateArrayIndexName(idx), 0L);
            ArrayReference nextArray = new ArrayReference(lastArrayReference, pos);
            lastArrayReference = nextArray;
            ++idx;
        }
        SingleNameReference lhsReference = lastArrayReference;
        lastArrayReference = this.decapsulationInput(gen.singleNameReference(ROLE_ARRAY_ARG));
        int idx2 = 0;
        while (idx2 < currentDimension) {
            SingleNameReference pos = new SingleNameReference(ArrayTranslations.generateArrayIndexName(idx2), 0L);
            ArrayReference nextArray = new ArrayReference(lastArrayReference, pos);
            lastArrayReference = nextArray;
            ++idx2;
        }
        NameReference rhsReference = lastArrayReference;
        if (currentDimension == arrayDimensions) {
            return new Assignment(lhsReference, this.translation(rhsReference, this._providedType.leafComponentType(), this._requiredType.leafComponentType(), gen), 0);
        }
        FieldReference lengthFieldReference = new FieldReference(IOTConstants.LENGTH, 0L);
        lengthFieldReference.receiver = rhsReference;
        TypeReference reqTypeReference = gen.typeReference(this._requiredType.leafComponentType());
        this.decapsulationOutput(reqTypeReference);
        ArrayAllocationExpression reqAllocationExpression = new ArrayAllocationExpression();
        reqAllocationExpression.type = reqTypeReference;
        reqAllocationExpression.dimensions = new Expression[arrayDimensions - currentDimension];
        reqAllocationExpression.dimensions[0] = lengthFieldReference;
        Assignment assignment = new Assignment(lhsReference, reqAllocationExpression, 0);
        return assignment;
    }

    abstract Expression translation(Expression var1, TypeBinding var2, TypeBinding var3, AstGenerator var4);

    private MethodDeclaration generateTransformArrayMethod(TypeDeclaration teamType, char[] transformMethodName, int arrayDimensions) {
        AstGenerator gen = new AstGenerator(teamType.sourceStart, teamType.sourceEnd);
        MethodDeclaration transformArrayMethod = gen.method(teamType.compilationResult(), 0, this._requiredType, transformMethodName, new Argument[]{gen.argument(ROLE_ARRAY_ARG, gen.typeReference(this._providedType))});
        this.decapsulationInput(transformArrayMethod.arguments[0].type);
        this.decapsulationOutput(transformArrayMethod.returnType);
        IfStatement ifStatement = this.generateIfStatement(0, arrayDimensions);
        LocalDeclaration reqArrayDeclaration = gen.localVariable(IOTConstants.OT_RESULT, this._requiredType, (Expression)gen.nullLiteral());
        this.decapsulationOutput(reqArrayDeclaration.type);
        Assignment arrayInstantiation = this.generateArrayInstantiation(0, arrayDimensions, gen);
        ForStatement forStatement = this.generateForStatement(0, arrayDimensions, gen);
        ReturnStatement returnStatement = gen.returnStatement(gen.singleNameReference(IOTConstants.OT_RESULT));
        transformArrayMethod.setStatements(new Statement[]{ifStatement, reqArrayDeclaration, arrayInstantiation, forStatement, returnStatement});
        return transformArrayMethod;
    }
}

