/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Config;

public abstract class PotentialTranslationExpression
extends Expression
implements IOTConstants {
    public Expression expression;
    protected TypeBinding expectedType;
    protected boolean checked = false;
    protected Expression rawExpression = null;
    protected String operator;

    public PotentialTranslationExpression(Expression expression, TypeBinding expectedType) {
        this.expression = expression;
        this.expectedType = expectedType;
        this.sourceStart = expression.sourceStart;
        this.sourceEnd = expression.sourceEnd;
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        this.expression.traverse(visitor, scope);
    }

    @Override
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        return this.expression.analyseCode(currentScope, flowContext, flowInfo);
    }

    @Override
    public int nullStatus(FlowInfo flowInfo, FlowContext flowContext) {
        return this.expression.nullStatus(flowInfo, flowContext);
    }

    @Override
    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        this.expression.generateCode(currentScope, codeStream, valueRequired);
    }

    protected TypeBinding compatibleType(BlockScope scope, TypeBinding rawType) {
        Config oldConfig = Config.createOrResetConfig(this);
        try {
            if (this.areTypesCompatible(rawType, this.expectedType) && !Config.requireTypeAdjustment()) {
                TypeBinding resultType = this.resolvedType;
                if (this.resolvedType.isBaseType() && TypeBinding.notEquals(rawType, this.expectedType)) {
                    this.rawExpression = this.expression;
                    this.rawExpression.computeConversion(scope, rawType, rawType);
                    this.expression = new CastExpression(this.expression, TypeReference.baseTypeReference(this.expectedType.id, 0, null));
                    this.expression.constant = Constant.NotAConstant;
                    ((CastExpression)this.expression).checkCastTypesCompatibility(scope, this.expectedType, rawType, this.expression);
                    this.operator = "(convert to " + new String(this.expectedType.readableName()) + ")";
                    resultType = this.expectedType;
                }
                if (BaseTypeBinding.isWidening(this.expectedType.id, rawType.id) && this.expression.constant != Constant.NotAConstant) {
                    this.expression.computeConversion(scope, this.expectedType, rawType);
                }
                TypeBinding typeBinding = resultType;
                return typeBinding;
            }
        }
        finally {
            Config.removeOrRestore(oldConfig, this);
        }
        return null;
    }

    private boolean areTypesCompatible(TypeBinding thisType, TypeBinding thatType) {
        if (thisType.isRoleType() && thatType.isRoleType()) {
            thisType = ((ReferenceBinding)thisType).getRealClass();
            thatType = ((ReferenceBinding)thatType).getRealClass();
        }
        return thisType.isCompatibleWith(thatType);
    }

    @Override
    public StringBuffer printExpression(int indent, StringBuffer output) {
        if (this.checked && this.rawExpression != null) {
            output.append(String.valueOf(this.operator) + "(");
            this.rawExpression.printExpression(indent, output);
            output.append(")");
        } else {
            output.append(String.valueOf(this.operator) + "?(");
            this.expression.printExpression(indent, output);
            output.append(")");
        }
        return output;
    }

    protected TypeBinding reportIncompatibility(BlockScope scope, TypeBinding rawType) {
        AbstractMethodDeclaration enclosingMethod = scope.methodScope().referenceMethod();
        if (enclosingMethod != null && enclosingMethod.isMappingWrapper.any()) {
            scope.problemReporter().typeMismatchInMethodMapping(this.expression, rawType, this.expectedType, enclosingMethod.isMappingWrapper.callout());
        } else {
            scope.problemReporter().typeMismatchError(rawType, this.expectedType, this.expression, null);
        }
        this.resolvedType = null;
        return null;
    }

    protected void checkOtherConversions(BlockScope scope, TypeBinding requiredType, TypeBinding providedType) {
        this.expression.computeConversion(scope, requiredType, providedType);
        if (providedType.needsUncheckedConversion(requiredType)) {
            scope.problemReporter().unsafeTypeConversion(this.expression, requiredType, providedType);
        }
        if (this.expression instanceof CastExpression && (this.expression.bits & 0x4020) == 0) {
            CastExpression.checkNeedForAssignedCast(scope, providedType, (CastExpression)this.expression);
        }
    }

    public static boolean usesAutoboxing(Expression expression) {
        return (expression.implicitConversion & 0x600) != 0;
    }
}

