/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.AbstractExpressionWrapper;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.BaseReference;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.SyntheticBaseCallSurrogate;
import org.eclipse.objectteams.otdt.internal.core.compiler.mappings.CallinImplementorDyn;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.MethodModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.problem.BaseCallProblemReporterWrapper;
import org.eclipse.objectteams.otdt.internal.core.compiler.problem.BlockScopeWrapper;
import org.eclipse.objectteams.otdt.internal.core.compiler.problem.ProblemReporterWrapper;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.MethodSignatureEnhancer;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstGenerator;

public class BaseCallMessageSend
extends AbstractExpressionWrapper {
    public char[] sourceSelector;
    public Expression[] sourceArgs;
    protected MessageSend _sendOrig;
    BaseReference _receiver;
    public boolean isSuperAccess;
    private CompilerOptions.WeavingScheme _weavingScheme = CompilerOptions.WeavingScheme.OTRE;

    public BaseCallMessageSend(MessageSend wrappee, int baseEndPos) {
        super(wrappee, wrappee.sourceStart, wrappee.sourceEnd);
        this._receiver = new BaseReference(wrappee.sourceStart, baseEndPos);
        wrappee.receiver = this._receiver;
        this._sendOrig = wrappee;
        this.sourceSelector = wrappee.selector;
        this.sourceArgs = wrappee.arguments;
    }

    public void setSuperAccess(boolean isSuperAccess, ProblemReporter problemReporter) {
        this.isSuperAccess = isSuperAccess;
        if (isSuperAccess) {
            problemReporter.baseSuperCallDecapsulation(this);
        }
    }

    public void prepareSuperAccess(CompilerOptions.WeavingScheme weavingScheme) {
        int extra;
        Expression[] args = this._sendOrig.arguments;
        this.sourceArgs = args;
        int len = 0;
        int n = extra = weavingScheme == CompilerOptions.WeavingScheme.OTRE ? 1 : 0;
        if (args == null) {
            args = new Expression[extra];
        } else {
            len = args.length;
            Expression[] expressionArray = args;
            args = new Expression[len + extra];
            System.arraycopy(expressionArray, 0, args, extra, len);
        }
        if (weavingScheme == CompilerOptions.WeavingScheme.OTRE) {
            args[0] = new AstGenerator(this).booleanLiteral(this.isSuperAccess);
        }
        this._sendOrig.arguments = args;
        this._weavingScheme = weavingScheme;
    }

    @Override
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        MethodModel methodModel;
        flowInfo = super.analyseCode(currentScope, flowContext, flowInfo);
        MethodDeclaration callinMethod = this.getEnclosingCallinMethod(currentScope);
        LocalVariableBinding trackingVariable = callinMethod.baseCallTrackingVariable.binding;
        if (flowInfo.isDefinitelyAssigned(callinMethod.baseCallTrackingVariable)) {
            currentScope.problemReporter().definitelyDuplicateBasecall(this._wrappee);
        } else if (flowInfo.isPotentiallyAssigned(trackingVariable)) {
            currentScope.problemReporter().potentiallyDuplicateBasecall(this._wrappee);
        } else {
            flowInfo.markAsDefinitelyAssigned(trackingVariable);
        }
        MethodScope methodScope = currentScope.methodScope();
        if (methodScope != null && (methodModel = methodScope.referenceMethod().binding.model) != null && methodModel._baseExceptions != null) {
            for (ReferenceBinding exceptionType : methodModel._baseExceptions) {
                flowContext.checkExceptionHandlers(exceptionType, (ASTNode)this, flowInfo, currentScope);
            }
        }
        if (this.isSuperAccess) {
            MethodModel.addCallinFlag(currentScope.methodScope().referenceMethod(), 32);
        }
        return flowInfo;
    }

    @Override
    public int nullStatus(FlowInfo flowInfo, FlowContext flowContext) {
        return 1;
    }

    private MethodDeclaration getEnclosingCallinMethod(BlockScope currentScope) {
        MethodDeclaration candidate = (MethodDeclaration)currentScope.methodScope().referenceContext;
        if (candidate.isCallin()) {
            return candidate;
        }
        assert (BaseCallMessageSend.nestedInCallin(currentScope.methodScope())) : "Not nested in a callin method";
        return (MethodDeclaration)currentScope.methodScope().parent.methodScope().referenceMethod();
    }

    public static MethodDeclaration getOuterCallinMethod(MethodScope scope) {
        Scope parent = scope.parent;
        if (parent != null) {
            MethodScope outerMethodScope = parent.methodScope();
            if (outerMethodScope == null) {
                return null;
            }
            AbstractMethodDeclaration outerMethod = outerMethodScope.referenceMethod();
            if (outerMethod.isCallin()) {
                return (MethodDeclaration)outerMethod;
            }
        }
        return null;
    }

    public static boolean nestedInCallin(MethodScope scope) {
        return BaseCallMessageSend.getOuterCallinMethod(scope) != null;
    }

    @Override
    public TypeBinding resolveType(BlockScope scope) {
        MethodBinding methodBinding;
        MethodBinding enclosingCallinMethod;
        CompilerOptions.WeavingScheme weavingScheme = scope.compilerOptions().weavingScheme;
        AstGenerator gen = new AstGenerator(this._wrappee.sourceStart, this._wrappee.sourceEnd);
        MessageSend wrappedSend = this._sendOrig;
        AbstractMethodDeclaration referenceMethod = scope.methodScope().referenceMethod();
        boolean isStatic = scope.methodScope().isStatic;
        MethodDeclaration outerCallinMethod = BaseCallMessageSend.getOuterCallinMethod(scope.methodScope());
        MethodBinding methodBinding2 = enclosingCallinMethod = outerCallinMethod != null ? outerCallinMethod.binding : scope.methodScope().referenceMethodBinding();
        if (outerCallinMethod != null && outerCallinMethod.binding == null) {
            return null;
        }
        SourceTypeBinding roleType = scope.enclosingSourceType();
        this._receiver.adjustReceiver(roleType, isStatic, outerCallinMethod, gen, weavingScheme);
        boolean isCallinBound = false;
        isCallinBound = enclosingCallinMethod != null ? SyntheticBaseCallSurrogate.isCallinMethodBoundIn(enclosingCallinMethod, enclosingCallinMethod.declaringClass) : roleType.roleModel.isBound();
        if (!isCallinBound && weavingScheme == CompilerOptions.WeavingScheme.OTRE) {
            this.resolveSyntheticBaseCallSurrogate(outerCallinMethod, scope, weavingScheme);
            return this.resolvedType;
        }
        wrappedSend.selector = weavingScheme == CompilerOptions.WeavingScheme.OTDRE ? CallinImplementorDyn.OT_CALL_NEXT : SyntheticBaseCallSurrogate.genSurrogateName(wrappedSend.selector, roleType.sourceName(), isStatic);
        TypeBinding returnType = null;
        if (referenceMethod != null && (methodBinding = referenceMethod.binding) != null && (returnType = MethodModel.getReturnType(methodBinding)) != null && returnType.isBaseType()) {
            if (returnType != TypeBinding.VOID) {
                this._wrappee = gen.createUnboxing(this._wrappee, (BaseTypeBinding)returnType);
            } else if (outerCallinMethod == null) {
                this._wrappee = gen.assignment(gen.singleNameReference(IOTConstants.OT_RESULT), this._wrappee);
            }
        }
        if (outerCallinMethod == null && !this.checkContext(scope)) {
            return null;
        }
        BlockScopeWrapper baseCallScope = new BlockScopeWrapper(scope, this);
        super.resolveType(baseCallScope);
        if (weavingScheme == CompilerOptions.WeavingScheme.OTDRE && returnType != null && !returnType.isBaseType()) {
            this.resolvedType = returnType;
            this._sendOrig.valueCast = returnType;
        }
        return this.resolvedType;
    }

    private void resolveSyntheticBaseCallSurrogate(MethodDeclaration outerCallinMethod, BlockScope scope, CompilerOptions.WeavingScheme weavingScheme) {
        TypeBinding[] methodParams;
        MethodBinding callinMethod;
        AbstractMethodDeclaration callinMethodDecl = outerCallinMethod;
        if (callinMethodDecl == null) {
            if (this.checkContext(scope)) {
                callinMethodDecl = scope.methodScope().referenceMethod();
            } else {
                return;
            }
        }
        if ((callinMethod = callinMethodDecl.binding) == null) {
            if (callinMethodDecl.ignoreFurtherInvestigation) {
                return;
            }
            throw new InternalCompilerError("Unresolved method without an error");
        }
        if (!CharOperation.equals(this._sendOrig.selector, callinMethod.selector)) {
            scope.problemReporter().baseCallNotSameMethod(callinMethodDecl, this._sendOrig);
        }
        this._receiver.resolve(scope);
        int depth = 0;
        while (this._receiver.resolvedType.isLocalType()) {
            this._receiver.resolvedType = this._receiver.resolvedType.enclosingType();
            ++depth;
        }
        this._receiver.bits |= depth << 5;
        if (this._receiver.resolvedType instanceof ReferenceBinding) {
            ReferenceBinding receiverType = (ReferenceBinding)this._receiver.resolvedType;
            this._receiver.resolvedType = receiverType.getRealClass();
        }
        TypeBinding[] sendparams = new TypeBinding[this._sendOrig.arguments.length];
        int i = 0;
        while (i < sendparams.length) {
            sendparams[i] = this._sendOrig.arguments[i].resolveType(scope);
            ++i;
        }
        int sourceArgsLen = 0;
        if (this.sourceArgs != null) {
            sourceArgsLen = this.sourceArgs.length;
        }
        if (sourceArgsLen != (methodParams = callinMethod.getSourceParameters()).length) {
            scope.problemReporter().baseCallDoesntMatchRoleMethodSignature(this);
        } else {
            int i2 = 0;
            while (i2 < sourceArgsLen) {
                TypeBinding srcArgType = this.sourceArgs[i2].resolvedType;
                if (srcArgType == null) {
                    if (!callinMethodDecl.hasErrors()) {
                        throw new InternalCompilerError("Unexpected: srcArgType should only ever be missing in declarations with reported errors");
                    }
                } else if (!srcArgType.isCompatibleWith(methodParams[i2])) {
                    if (this.isBoxingCompatible(srcArgType, methodParams[i2], this.sourceArgs[i2], scope)) {
                        int enhancedArgIdx = i2 + MethodSignatureEnhancer.getEnhancingArgLen(weavingScheme) + 1;
                        this._sendOrig.arguments[enhancedArgIdx].computeConversion(scope, methodParams[i2], srcArgType);
                    } else {
                        scope.problemReporter().baseCallDoesntMatchRoleMethodSignature(this);
                        break;
                    }
                }
                ++i2;
            }
        }
        MethodBinding surrogate = null;
        MethodModel model = callinMethod.model;
        if (model != null) {
            surrogate = model.getBaseCallSurrogate();
        }
        if (surrogate == null) {
            SourceTypeBinding receiverClass = (SourceTypeBinding)((ReferenceBinding)this._receiver.resolvedType).getRealClass();
            if (SyntheticBaseCallSurrogate.isBindingForCallinMethodInherited(callinMethod)) {
                ReferenceBinding currentRole = callinMethod.declaringClass;
                while (surrogate == null && (currentRole = currentRole.superclass()) != null) {
                    surrogate = receiverClass.getExactMethod(SyntheticBaseCallSurrogate.genSurrogateName(this.sourceSelector, currentRole.sourceName(), callinMethod.isStatic()), sendparams, null);
                }
            } else {
                surrogate = receiverClass.addSyntheticBaseCallSurrogate(callinMethod);
            }
        }
        this._sendOrig.binding = surrogate;
        this._sendOrig.actualReceiverType = this._receiver.resolvedType;
        this._sendOrig.constant = Constant.NotAConstant;
        this.resolvedType = this._sendOrig.resolvedType = MethodModel.getReturnType(this._sendOrig.binding);
    }

    @Override
    public void computeConversion(Scope scope, TypeBinding runtimeTimeType, TypeBinding compileTimeType) {
        if (this._sendOrig.binding instanceof SyntheticBaseCallSurrogate && this._sendOrig == this._wrappee && this.resolvedType.isBaseType() && this.resolvedType != TypeBinding.VOID) {
            ReferenceBinding boxType = (ReferenceBinding)scope.getType(AstGenerator.boxTypeName((BaseTypeBinding)this.resolvedType), 3);
            this._sendOrig.valueCast = boxType;
            compileTimeType = boxType;
        }
        super.computeConversion(scope, runtimeTimeType, compileTimeType);
    }

    private boolean checkContext(BlockScope scope) {
        if (scope.methodScope() == null || !(scope.methodScope().referenceContext instanceof AbstractMethodDeclaration)) {
            scope.problemReporter().baseCallOutsideMethod(this);
            return false;
        }
        AbstractMethodDeclaration methodDecl = (AbstractMethodDeclaration)scope.methodScope().referenceContext;
        if ((methodDecl.modifiers & Integer.MIN_VALUE) == 0) {
            scope.problemReporter().basecallInRegularMethod(this, methodDecl);
            return false;
        }
        return true;
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            this._wrappee.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }

    public MessageSend getMessageSend() {
        return this._sendOrig;
    }

    @Override
    public ProblemReporterWrapper create(ProblemReporter wrappee) {
        return new BaseCallProblemReporterWrapper(wrappee, this);
    }

    @Override
    public StringBuffer printExpression(int indent, StringBuffer output) {
        char[] selectorSave = "<missing>".toCharArray();
        Expression[] argsSave = null;
        try {
            if (this._sendOrig != null) {
                selectorSave = this._sendOrig.selector;
                this._sendOrig.selector = this.sourceSelector;
                argsSave = this._sendOrig.arguments;
                boolean isEnhanced = (this._sendOrig.bits & 4) != 0;
                this._sendOrig.arguments = MethodSignatureEnhancer.retrenchBasecallArguments(argsSave, isEnhanced, this._weavingScheme);
                StringBuffer stringBuffer = this._sendOrig.printExpression(indent, output);
                return stringBuffer;
            }
        }
        finally {
            if (selectorSave != null) {
                this._sendOrig.selector = selectorSave;
            }
            if (argsSave != null) {
                this._sendOrig.arguments = argsSave;
            }
        }
        return super.printExpression(indent, output);
    }
}

