/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer;

import java.util.HashMap;
import java.util.Stack;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.AbstractTransformStatementsVisitor;

public class StackTransformStatementsVisitor
extends AbstractTransformStatementsVisitor {
    private Stack<Statement> replacements = new Stack();
    private Stack<Statement> toReplace = new Stack();
    private HashMap<Statement, Integer> stackSizes = new HashMap();

    protected void assertAllConsumed(ASTNode node) {
        Integer stackSize = this.stackSizes.get(node);
        if (stackSize == null) {
            return;
        }
        if (this.replacements.size() != stackSize.intValue()) {
            throw new InternalCompilerError("Unbalanced replacement stack.");
        }
        this.stackSizes.remove(node);
    }

    protected void enterExpression(Expression oldExpr, Expression newExpr, Statement node) {
        this.toReplace.push(oldExpr);
        this.replacements.push(newExpr);
        this.stackSizes.put(node, new Integer(this.replacements.size()));
    }

    public Expression checkConsumeExpression(Expression oldExpr, BlockScope scope) {
        Statement old;
        if (!this.toReplace.isEmpty() && (old = this.toReplace.peek()) == oldExpr) {
            this.toReplace.pop();
            return (Expression)this.replacements.pop();
        }
        return oldExpr;
    }

    protected Statement checkConsumeStatement(Statement oldStat, BlockScope scope) {
        Statement old;
        if (!this.toReplace.isEmpty() && (old = this.toReplace.peek()) == oldStat) {
            this.toReplace.pop();
            return this.replacements.pop();
        }
        return oldStat;
    }
}

