/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.AND_AND_Expression;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ArrayAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ArrayReference;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.AssertStatement;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.BinaryExpression;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.BreakStatement;
import org.eclipse.jdt.internal.compiler.ast.CaseStatement;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.CharLiteral;
import org.eclipse.jdt.internal.compiler.ast.ClassLiteralAccess;
import org.eclipse.jdt.internal.compiler.ast.Clinit;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompoundAssignment;
import org.eclipse.jdt.internal.compiler.ast.ConditionalExpression;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ContinueStatement;
import org.eclipse.jdt.internal.compiler.ast.DoStatement;
import org.eclipse.jdt.internal.compiler.ast.DoubleLiteral;
import org.eclipse.jdt.internal.compiler.ast.EmptyStatement;
import org.eclipse.jdt.internal.compiler.ast.EqualExpression;
import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ExtendedStringLiteral;
import org.eclipse.jdt.internal.compiler.ast.FalseLiteral;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.FloatLiteral;
import org.eclipse.jdt.internal.compiler.ast.ForStatement;
import org.eclipse.jdt.internal.compiler.ast.IfStatement;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.eclipse.jdt.internal.compiler.ast.InstanceOfExpression;
import org.eclipse.jdt.internal.compiler.ast.IntLiteral;
import org.eclipse.jdt.internal.compiler.ast.LabeledStatement;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.LongLiteral;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.eclipse.jdt.internal.compiler.ast.OR_OR_Expression;
import org.eclipse.jdt.internal.compiler.ast.PostfixExpression;
import org.eclipse.jdt.internal.compiler.ast.PrefixExpression;
import org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedSuperReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedThisReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ReturnStatement;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.eclipse.jdt.internal.compiler.ast.StringLiteralConcatenation;
import org.eclipse.jdt.internal.compiler.ast.SuperReference;
import org.eclipse.jdt.internal.compiler.ast.SwitchStatement;
import org.eclipse.jdt.internal.compiler.ast.SynchronizedStatement;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.ast.ThrowStatement;
import org.eclipse.jdt.internal.compiler.ast.TrueLiteral;
import org.eclipse.jdt.internal.compiler.ast.TryStatement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.UnaryExpression;
import org.eclipse.jdt.internal.compiler.ast.WhileStatement;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.BaseCallMessageSend;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.BaseReference;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.CallinMappingDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.CalloutMappingDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.LiftingTypeReference;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.MethodSpec;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.ParameterMapping;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.TsuperReference;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.WithinStatement;

public abstract class AbstractTransformStatementsVisitor
extends ASTVisitor {
    protected abstract void enterExpression(Expression var1, Expression var2, Statement var3);

    protected abstract void assertAllConsumed(ASTNode var1);

    protected abstract Expression checkConsumeExpression(Expression var1, BlockScope var2);

    protected abstract Statement checkConsumeStatement(Statement var1, BlockScope var2);

    private void replaceStatsInArray(Statement[] stats, BlockScope scope) {
        if (stats != null) {
            int i = stats.length - 1;
            while (i >= 0) {
                stats[i] = this.checkConsumeStatement(stats[i], scope);
                --i;
            }
        }
    }

    private void replaceExprsInArray(Expression[] exprs, BlockScope scope) {
        if (exprs != null) {
            int i = exprs.length - 1;
            while (i >= 0) {
                exprs[i] = this.checkConsumeExpression(exprs[i], scope);
                --i;
            }
        }
    }

    public void endVisit(AssertStatement assertStatement, BlockScope scope) {
        assertStatement.assertExpression = this.checkConsumeExpression(assertStatement.assertExpression, scope);
        this.assertAllConsumed(assertStatement);
    }

    public void endVisit(BaseCallMessageSend messageSend, BlockScope scope) {
    }

    public void endVisit(MethodSpec methodSpec, BlockScope scope) {
        this.assertAllConsumed(methodSpec);
    }

    public void endVisit(StringLiteralConcatenation literal, BlockScope scope) {
        this.assertAllConsumed(literal);
    }

    public void endVisit(TypeDeclaration localTypeDeclaration, BlockScope scope) {
        this.assertAllConsumed(localTypeDeclaration);
    }

    protected void endVisit(AbstractMethodDeclaration decl) {
        this.replaceStatsInArray(decl.statements, decl.scope);
        this.assertAllConsumed(decl);
    }

    public void endVisit(ParameterMapping mapping, BlockScope scope) {
        mapping.expression = this.checkConsumeExpression(mapping.expression, scope);
        this.assertAllConsumed(mapping);
    }

    public void endVisit(AllocationExpression alloc, BlockScope scope) {
        this.replaceExprsInArray(alloc.arguments, scope);
        this.assertAllConsumed(alloc);
    }

    public void endVisit(AND_AND_Expression expr, BlockScope scope) {
        this.endVisit((BinaryExpression)expr, scope);
    }

    public void endVisit(Argument arg, BlockScope scope) {
        this.assertAllConsumed(arg);
    }

    public void endVisit(ArrayAllocationExpression alloc, BlockScope scope) {
        this.assertAllConsumed(alloc);
    }

    public void endVisit(ArrayInitializer init, BlockScope scope) {
        this.replaceExprsInArray(init.expressions, scope);
        this.assertAllConsumed(init);
    }

    public void endVisit(ArrayQualifiedTypeReference ref, BlockScope scope) {
        this.assertAllConsumed(ref);
    }

    public void endVisit(ArrayQualifiedTypeReference ref, ClassScope scope) {
        this.assertAllConsumed(ref);
    }

    public void endVisit(ArrayReference ref, BlockScope scope) {
        this.assertAllConsumed(ref);
    }

    public void endVisit(ArrayTypeReference ref, BlockScope scope) {
        this.assertAllConsumed(ref);
    }

    public void endVisit(ArrayTypeReference ref, ClassScope scope) {
        this.assertAllConsumed(ref);
    }

    public void endVisit(Assignment ass, BlockScope scope) {
        ass.expression = this.checkConsumeExpression(ass.expression, scope);
        this.assertAllConsumed(ass);
    }

    public void endVisit(BinaryExpression expr, BlockScope scope) {
        expr.right = this.checkConsumeExpression(expr.right, scope);
        expr.left = this.checkConsumeExpression(expr.left, scope);
        this.assertAllConsumed(expr);
    }

    public void endVisit(Block b, BlockScope scope) {
        this.replaceStatsInArray(b.statements, scope);
        this.assertAllConsumed(b);
    }

    public void endVisit(BreakStatement stat, BlockScope scope) {
        this.assertAllConsumed(stat);
    }

    public void endVisit(CaseStatement stat, BlockScope scope) {
        this.assertAllConsumed(stat);
    }

    public void endVisit(CastExpression cast, BlockScope scope) {
        cast.expression = this.checkConsumeExpression(cast.expression, scope);
        this.assertAllConsumed(cast);
    }

    public void endVisit(CharLiteral ch, BlockScope scope) {
        this.assertAllConsumed(ch);
    }

    public void endVisit(ClassLiteralAccess clazz, BlockScope scope) {
        this.assertAllConsumed(clazz);
    }

    public void endVisit(Clinit block, ClassScope scope) {
        this.endVisit(block);
    }

    public void endVisit(CompilationUnitDeclaration decl, CompilationUnitScope scope) {
        this.assertAllConsumed(decl);
    }

    public void endVisit(CompoundAssignment compoundAssignment, BlockScope scope) {
        this.endVisit((Assignment)compoundAssignment, scope);
    }

    public void endVisit(ConditionalExpression expr, BlockScope scope) {
        expr.condition = this.checkConsumeExpression(expr.condition, scope);
        expr.valueIfFalse = this.checkConsumeExpression(expr.valueIfFalse, scope);
        expr.valueIfTrue = this.checkConsumeExpression(expr.valueIfTrue, scope);
        this.assertAllConsumed(expr);
    }

    public void endVisit(ConstructorDeclaration decl, ClassScope scope) {
        this.endVisit(decl);
    }

    public void endVisit(ContinueStatement continueStatement, BlockScope scope) {
        this.assertAllConsumed(continueStatement);
    }

    public void endVisit(DoStatement stat, BlockScope scope) {
        stat.condition = this.checkConsumeExpression(stat.condition, scope);
        stat.action = this.checkConsumeStatement(stat.action, scope);
        this.assertAllConsumed(stat);
    }

    public void endVisit(DoubleLiteral doubleLiteral, BlockScope scope) {
        this.assertAllConsumed(doubleLiteral);
    }

    public void endVisit(EqualExpression expr, BlockScope scope) {
        this.endVisit((BinaryExpression)expr, scope);
    }

    public void endVisit(ExplicitConstructorCall call, BlockScope scope) {
        this.replaceExprsInArray(call.arguments, scope);
        this.assertAllConsumed(call);
    }

    public void endVisit(ExtendedStringLiteral lit, BlockScope scope) {
        this.assertAllConsumed(lit);
    }

    public void endVisit(FalseLiteral falseLiteral, BlockScope scope) {
        this.assertAllConsumed(falseLiteral);
    }

    public void endVisit(FieldDeclaration fieldDeclaration, MethodScope scope) {
        fieldDeclaration.initialization = this.checkConsumeExpression(fieldDeclaration.initialization, scope);
        this.assertAllConsumed(fieldDeclaration);
    }

    public void endVisit(FieldReference fieldReference, BlockScope scope) {
        fieldReference.receiver = this.checkConsumeExpression(fieldReference.receiver, scope);
        this.assertAllConsumed(fieldReference);
    }

    public void endVisit(FloatLiteral floatLiteral, BlockScope scope) {
        this.assertAllConsumed(floatLiteral);
    }

    public void endVisit(EmptyStatement emptyStatement, BlockScope scope) {
        this.assertAllConsumed(emptyStatement);
    }

    public void endVisit(ForStatement forStatement, BlockScope scope) {
        this.replaceStatsInArray(forStatement.initializations, scope);
        forStatement.condition = this.checkConsumeExpression(forStatement.condition, scope);
        this.replaceStatsInArray(forStatement.increments, scope);
        forStatement.action = this.checkConsumeStatement(forStatement.action, scope);
        this.assertAllConsumed(forStatement);
    }

    public void endVisit(IfStatement stat, BlockScope scope) {
        stat.condition = this.checkConsumeExpression(stat.condition, scope);
        stat.elseStatement = this.checkConsumeStatement(stat.elseStatement, scope);
        stat.thenStatement = this.checkConsumeStatement(stat.thenStatement, scope);
        this.assertAllConsumed(stat);
    }

    public void endVisit(ImportReference importRef, CompilationUnitScope scope) {
        this.assertAllConsumed(importRef);
    }

    public void endVisit(Initializer initializer, MethodScope scope) {
        this.assertAllConsumed(initializer);
    }

    public void endVisit(InstanceOfExpression expr, BlockScope scope) {
        expr.expression = this.checkConsumeExpression(expr.expression, scope);
        this.assertAllConsumed(expr);
    }

    public void endVisit(IntLiteral intLiteral, BlockScope scope) {
        this.assertAllConsumed(intLiteral);
    }

    public void endVisit(LabeledStatement stat, BlockScope scope) {
        stat.statement = this.checkConsumeStatement(stat.statement, scope);
        this.assertAllConsumed(stat);
    }

    public void endVisit(LocalDeclaration decl, BlockScope scope) {
        decl.initialization = this.checkConsumeExpression(decl.initialization, scope);
        this.assertAllConsumed(decl);
    }

    public void endVisit(LongLiteral longLiteral, BlockScope scope) {
        this.assertAllConsumed(longLiteral);
    }

    public void endVisit(TypeDeclaration decl, ClassScope scope) {
        this.assertAllConsumed(decl);
    }

    public void endVisit(MessageSend msg, BlockScope scope) {
        this.replaceExprsInArray(msg.arguments, scope);
        msg.receiver = this.checkConsumeExpression(msg.receiver, scope);
        this.assertAllConsumed(msg);
    }

    public void endVisit(MethodDeclaration decl, ClassScope scope) {
        this.endVisit(decl);
    }

    public void endVisit(NullLiteral nullLiteral, BlockScope scope) {
        this.assertAllConsumed(nullLiteral);
    }

    public void endVisit(OR_OR_Expression expr, BlockScope scope) {
        this.endVisit((BinaryExpression)expr, scope);
    }

    public void endVisit(PostfixExpression postfixExpression, BlockScope scope) {
        postfixExpression.expression = this.checkConsumeExpression(postfixExpression.expression, scope);
        this.assertAllConsumed(postfixExpression);
    }

    public void endVisit(PrefixExpression prefixExpression, BlockScope scope) {
        prefixExpression.expression = this.checkConsumeExpression(prefixExpression.expression, scope);
        this.assertAllConsumed(prefixExpression);
    }

    public void endVisit(QualifiedAllocationExpression alloc, BlockScope scope) {
        this.replaceExprsInArray(alloc.arguments, scope);
        alloc.enclosingInstance = this.checkConsumeExpression(alloc.enclosingInstance, scope);
        this.assertAllConsumed(alloc);
    }

    public void endVisit(QualifiedNameReference ref, BlockScope scope) {
        this.assertAllConsumed(ref);
    }

    public void endVisit(QualifiedSuperReference ref, BlockScope scope) {
        this.assertAllConsumed(ref);
    }

    public void endVisit(QualifiedThisReference ref, BlockScope scope) {
        this.assertAllConsumed(ref);
    }

    public void endVisit(QualifiedTypeReference ref, BlockScope scope) {
        this.assertAllConsumed(ref);
    }

    public void endVisit(QualifiedTypeReference ref, ClassScope scope) {
        this.assertAllConsumed(ref);
    }

    public void endVisit(ReturnStatement ret, BlockScope scope) {
        ret.expression = this.checkConsumeExpression(ret.expression, scope);
        this.assertAllConsumed(ret);
    }

    public void endVisit(SingleNameReference ref, BlockScope scope) {
        this.assertAllConsumed(ref);
    }

    public void endVisit(SingleTypeReference ref, BlockScope scope) {
        this.assertAllConsumed(ref);
    }

    public void endVisit(SingleTypeReference ref, ClassScope scope) {
        this.assertAllConsumed(ref);
    }

    public void endVisit(StringLiteral stringLiteral, BlockScope scope) {
        this.assertAllConsumed(stringLiteral);
    }

    public void endVisit(SuperReference superReference, BlockScope scope) {
        this.assertAllConsumed(superReference);
    }

    public void endVisit(SwitchStatement stat, BlockScope scope) {
        stat.expression = this.checkConsumeExpression(stat.expression, scope);
        this.replaceStatsInArray(stat.statements, scope);
        this.assertAllConsumed(stat);
    }

    public void endVisit(SynchronizedStatement stat, BlockScope scope) {
        stat.expression = this.checkConsumeExpression(stat.expression, scope);
        this.assertAllConsumed(stat);
    }

    public void endVisit(ThisReference thisReference, BlockScope scope) {
        this.assertAllConsumed(thisReference);
    }

    public void endVisit(ThrowStatement stat, BlockScope scope) {
        stat.exception = this.checkConsumeExpression(stat.exception, scope);
        this.assertAllConsumed(stat);
    }

    public void endVisit(TrueLiteral trueLiteral, BlockScope scope) {
        this.assertAllConsumed(trueLiteral);
    }

    public void endVisit(TryStatement tryStatement, BlockScope scope) {
        this.assertAllConsumed(tryStatement);
    }

    public void endVisit(TypeDeclaration decl, CompilationUnitScope scope) {
        this.assertAllConsumed(decl);
    }

    public void endVisit(UnaryExpression unaryExpression, BlockScope scope) {
        unaryExpression.expression = this.checkConsumeExpression(unaryExpression.expression, scope);
        this.assertAllConsumed(unaryExpression);
    }

    public void endVisit(WhileStatement stat, BlockScope scope) {
        stat.condition = this.checkConsumeExpression(stat.condition, scope);
        stat.action = this.checkConsumeStatement(stat.action, scope);
        this.assertAllConsumed(stat);
    }

    public void endVisit(LiftingTypeReference liftingTypeReference, BlockScope scope) {
        this.assertAllConsumed(liftingTypeReference);
    }

    public void endVisit(LiftingTypeReference liftingTypeReference, ClassScope scope) {
        this.assertAllConsumed(liftingTypeReference);
    }

    public void endVisit(WithinStatement stat, BlockScope scope) {
        this.endVisit((Block)stat, scope);
    }

    public void endVisit(TsuperReference tsuperReference, BlockScope scope) {
        this.assertAllConsumed(tsuperReference);
    }

    public void endVisit(BaseReference baseReference, BlockScope scope) {
        this.assertAllConsumed(baseReference);
    }

    public void endVisit(CallinMappingDeclaration decl, ClassScope scope) {
        this.assertAllConsumed(decl);
    }

    public void endVisit(CalloutMappingDeclaration decl, ClassScope scope) {
        this.assertAllConsumed(decl);
    }
}

