/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.layer.cell;

import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.swt.graphics.Rectangle;

public abstract class AbstractLayerCell
implements ILayerCell {
    private boolean isDisplayModeCached = false;
    private DisplayMode displayMode = null;
    private boolean isConfigLabelsCached = false;
    private LabelStack configLabels = null;
    private boolean isDataValueCached = false;
    private Object dataValue = null;
    private boolean isBoundsCached = false;
    private Rectangle bounds = null;

    @Override
    public boolean isSpannedCell() {
        return this.getColumnSpan() > 1 || this.getRowSpan() > 1;
    }

    @Override
    public DisplayMode getDisplayMode() {
        if (!this.isDisplayModeCached) {
            this.isDisplayModeCached = true;
            this.displayMode = this.getLayer().getDisplayModeByPosition(this.getColumnPosition(), this.getRowPosition());
        }
        return this.displayMode;
    }

    @Override
    public LabelStack getConfigLabels() {
        if (!this.isConfigLabelsCached) {
            this.isConfigLabelsCached = true;
            this.configLabels = this.getLayer().getConfigLabelsByPosition(this.getColumnPosition(), this.getRowPosition());
        }
        return this.configLabels;
    }

    @Override
    public Object getDataValue() {
        if (!this.isDataValueCached) {
            this.isDataValueCached = true;
            this.dataValue = this.getLayer().getDataValueByPosition(this.getColumnPosition(), this.getRowPosition());
        }
        return this.dataValue;
    }

    @Override
    public Rectangle getBounds() {
        if (!this.isBoundsCached) {
            this.isBoundsCached = true;
            this.bounds = this.getLayer().getBoundsByPosition(this.getColumnPosition(), this.getRowPosition());
        }
        return this.bounds;
    }
}

