/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.sort.event;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.ui.matcher.MouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeDetectUtil;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeEnum;
import org.eclipse.nebula.widgets.nattable.util.ObjectUtils;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;

public class ColumnHeaderClickEventMatcher
extends MouseEventMatcher {
    public ColumnHeaderClickEventMatcher(int stateMask, int button) {
        super(stateMask, "COLUMN_HEADER", button);
    }

    @Override
    public boolean matches(NatTable natTable, MouseEvent event, LabelStack regionLabels) {
        return super.matches(natTable, event, regionLabels) && this.isNearTheHeaderEdge(natTable, event) && this.isNotFilterRegion(regionLabels) && this.isNotColumnGroupRegion(regionLabels);
    }

    private boolean isNearTheHeaderEdge(ILayer natLayer, MouseEvent event) {
        CellEdgeEnum cellEdge = CellEdgeDetectUtil.getHorizontalCellEdge(natLayer, new Point(event.x, event.y), 4);
        return cellEdge == CellEdgeEnum.NONE;
    }

    private boolean isNotFilterRegion(LabelStack regionLabels) {
        if (ObjectUtils.isNotNull(regionLabels)) {
            return !regionLabels.getLabels().contains("FILTER_ROW");
        }
        return true;
    }

    private boolean isNotColumnGroupRegion(LabelStack regionLabels) {
        if (ObjectUtils.isNotNull(regionLabels)) {
            return !regionLabels.getLabels().contains("COLUMN_GROUP_HEADER");
        }
        return true;
    }
}

