/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.map;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.core.databinding.observable.IDiff;
import org.eclipse.core.internal.databinding.observable.Util;

public abstract class MapDiff<K, V>
implements IDiff {
    public boolean isEmpty() {
        return this.getAddedKeys().isEmpty() && this.getRemovedKeys().isEmpty() && this.getChangedKeys().isEmpty();
    }

    public void applyTo(Map<K, V> map) {
        for (K key : this.getAddedKeys()) {
            map.put(key, this.getNewValue(key));
        }
        for (K key : this.getChangedKeys()) {
            map.put(key, this.getNewValue(key));
        }
        Iterator<K> it = this.getRemovedKeys().iterator();
        while (it.hasNext()) {
            map.remove(it.next());
        }
    }

    public Map<K, V> simulateOn(Map<K, V> map) {
        return new DeltaMap<K, V>(map, this);
    }

    public abstract Set<K> getAddedKeys();

    public abstract Set<K> getRemovedKeys();

    public abstract Set<K> getChangedKeys();

    public abstract V getOldValue(Object var1);

    public abstract V getNewValue(Object var1);

    private static abstract class AbstractMapEntry<K, V>
    implements Map.Entry<K, V> {
        private AbstractMapEntry() {
        }

        @Override
        public V setValue(Object arg0) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry that = (Map.Entry)obj;
            return Util.equals(this.getKey(), that.getKey()) && Util.equals(this.getValue(), that.getValue());
        }

        @Override
        public int hashCode() {
            Object key = this.getKey();
            Object value = this.getValue();
            return this.hash(key) ^ this.hash(value);
        }

        private int hash(Object key) {
            return key == null ? 0 : key.hashCode();
        }
    }

    private static class DeltaMap<K, V>
    extends AbstractMap<K, V> {
        private final Map<K, V> map;
        private final MapDiff<K, V> diff;
        private Set<Map.Entry<K, V>> entrySet;

        public DeltaMap(Map<K, V> map, MapDiff<K, V> diff) {
            this.map = map;
            this.diff = diff;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.diff.getAddedKeys().contains(key) || this.map.containsKey(key) && !this.diff.getRemovedKeys().contains(key);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            if (this.entrySet == null) {
                this.entrySet = new DeltaMapEntrySet<K, V>(this.map, this.diff);
            }
            return this.entrySet;
        }

        @Override
        public V get(Object key) {
            if (this.diff.getAddedKeys().contains(key)) {
                return this.diff.getNewValue(key);
            }
            if (this.diff.getChangedKeys().contains(key)) {
                return this.diff.getNewValue(key);
            }
            if (this.diff.getRemovedKeys().contains(key)) {
                return null;
            }
            return this.map.get(key);
        }

        @Override
        public V put(Object arg0, Object arg1) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> arg0) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V remove(Object key) {
            throw new UnsupportedOperationException();
        }
    }

    private static class DeltaMapEntry<K, V>
    extends AbstractMapEntry<K, V> {
        private final K key;
        private final MapDiff<K, V> diff;

        public DeltaMapEntry(K key, MapDiff<K, V> diff) {
            this.key = key;
            this.diff = diff;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.diff.getNewValue(this.key);
        }
    }

    private static class DeltaMapEntrySet<K, V>
    extends AbstractSet<Map.Entry<K, V>> {
        private final Map<K, V> map;
        private final MapDiff<K, V> diff;

        public DeltaMapEntrySet(Map<K, V> map, MapDiff<K, V> diff) {
            this.map = map;
            this.diff = diff;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iterator<Map.Entry<K, V>>(){
                Iterator<Map.Entry<K, V>> origEntries;
                Iterator<? extends K> addedKeys;
                boolean haveNext;
                Map.Entry<K, V> next;
                {
                    this.origEntries = deltaMapEntrySet.map.entrySet().iterator();
                    this.addedKeys = deltaMapEntrySet.diff.getAddedKeys().iterator();
                    this.haveNext = false;
                }

                @Override
                public boolean hasNext() {
                    return this.findNext();
                }

                @Override
                public Map.Entry<K, V> next() {
                    if (!this.findNext()) {
                        throw new NoSuchElementException();
                    }
                    Map.Entry myNext = this.next;
                    this.haveNext = false;
                    this.next = null;
                    return myNext;
                }

                private boolean findNext() {
                    AbstractMapEntry candidateEntry;
                    block4: {
                        Object candidateKey;
                        if (this.haveNext) {
                            return true;
                        }
                        while (this.origEntries.hasNext()) {
                            candidateEntry = this.origEntries.next();
                            candidateKey = candidateEntry.getKey();
                            if (diff.getRemovedKeys().contains(candidateKey)) continue;
                            candidateEntry = diff.getChangedKeys().contains(candidateKey) ? new DeltaMapEntry(candidateKey, diff) : new MapEntryWrapper(candidateEntry);
                            break block4;
                        }
                        if (this.addedKeys.hasNext()) {
                            candidateKey = this.addedKeys.next();
                            candidateEntry = new DeltaMapEntry(candidateKey, diff);
                        } else {
                            return false;
                        }
                    }
                    this.haveNext = true;
                    this.next = candidateEntry;
                    return true;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            return this.map.size() + this.diff.getAddedKeys().size() - this.diff.getRemovedKeys().size();
        }
    }

    private static class MapEntryWrapper<K, V>
    extends AbstractMapEntry<K, V> {
        private final Map.Entry<K, V> entry;

        public MapEntryWrapper(Map.Entry<K, V> entry) {
            this.entry = entry;
        }

        @Override
        public K getKey() {
            return this.entry.getKey();
        }

        @Override
        public V getValue() {
            return this.entry.getValue();
        }
    }
}

