/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.richtext.painter.instructions;

import org.eclipse.nebula.widgets.richtext.painter.ResourceHelper;
import org.eclipse.nebula.widgets.richtext.painter.TagProcessingState;
import org.eclipse.nebula.widgets.richtext.painter.instructions.FontMetricsProvider;
import org.eclipse.nebula.widgets.richtext.painter.instructions.PaintInstruction;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class SpanStylePaintInstruction
implements PaintInstruction,
FontMetricsProvider {
    private TagProcessingState state;
    private Color foregroundColor;
    private Color backgroundColor;
    private Integer fontSize;
    private String fontType;

    public SpanStylePaintInstruction(TagProcessingState state) {
        this.state = state;
    }

    @Override
    public void paint(GC gc, Rectangle area) {
        if (this.foregroundColor != null) {
            this.state.setPrevColor(gc.getForeground());
            gc.setForeground(this.foregroundColor);
        }
        if (this.backgroundColor != null) {
            this.state.setPrevBgColor(gc.getBackground());
            gc.setBackground(this.backgroundColor);
        }
        if (this.fontSize != null || this.fontType != null) {
            Font currentFont = gc.getFont();
            this.state.addPreviousFont(currentFont);
            gc.setFont(ResourceHelper.getFont(currentFont, this.fontType, this.fontSize));
        }
    }

    @Override
    public FontMetrics getFontMetrics(GC gc) {
        Font currentFont = gc.getFont();
        this.state.addPreviousFont(currentFont);
        gc.setFont(ResourceHelper.getFont(currentFont, this.fontType, this.fontSize));
        return gc.getFontMetrics();
    }

    public void setForegroundColor(Color foregroundColor) {
        this.foregroundColor = foregroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setFontSize(Integer fontSize) {
        this.fontSize = fontSize;
    }

    public void setFontType(String fontType) {
        this.fontType = fontType;
    }
}

