/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples.fixtures;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ReflectiveColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.GlazedListsEventLayer;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.GlazedListsSortModel;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultColumnHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultRowHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ColumnOverrideLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.event.ColumnStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralDiff;
import org.eclipse.nebula.widgets.nattable.layer.stack.DefaultBodyLayerStack;
import org.eclipse.nebula.widgets.nattable.sort.ISortModel;
import org.eclipse.nebula.widgets.nattable.sort.SortHeaderLayer;
import org.eclipse.nebula.widgets.nattable.util.IClientAreaProvider;

public class ColumnStructureUpdatesExampleGridLayer<T>
extends GridLayer {
    private ColumnOverrideLabelAccumulator columnLabelAccumulator;
    private DataLayer bodyDataLayer;
    private DataLayer columnHeaderDataLayer;
    public ListDataProviderExample<T> bodyDataProvider;

    public ColumnStructureUpdatesExampleGridLayer(EventList<T> eventList, String[] propertyNames, Map<String, String> propertyToLabelMap, IConfigRegistry configRegistry) {
        this(eventList, propertyNames, propertyToLabelMap, configRegistry, true);
    }

    public ColumnStructureUpdatesExampleGridLayer(EventList<T> eventList, String[] propertyNames, Map<String, String> propertyToLabelMap, IConfigRegistry configRegistry, boolean useDefaultConfiguration) {
        super(useDefaultConfiguration);
        SortedList sortedList = new SortedList(eventList, null);
        ReflectiveColumnPropertyAccessor columnPropertyAccessor = new ReflectiveColumnPropertyAccessor(propertyNames);
        this.bodyDataProvider = new ListDataProviderExample(sortedList, columnPropertyAccessor);
        this.bodyDataLayer = new DataLayer(this.bodyDataProvider);
        GlazedListsEventLayer glazedListsEventLayer = new GlazedListsEventLayer((IUniqueIndexLayer)this.bodyDataLayer, eventList);
        DefaultBodyLayerStack bodyLayer = new DefaultBodyLayerStack((IUniqueIndexLayer)glazedListsEventLayer);
        DefaultColumnHeaderDataProvider columnHeaderDataProvider = new DefaultColumnHeaderDataProvider(propertyNames, propertyToLabelMap);
        this.columnHeaderDataLayer = new DefaultColumnHeaderDataLayer((IDataProvider)columnHeaderDataProvider);
        ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)this.columnHeaderDataLayer, (ILayer)bodyLayer, bodyLayer.getSelectionLayer());
        SortHeaderLayer columnHeaderSortableLayer = new SortHeaderLayer((ILayer)columnHeaderLayer, (ISortModel)new GlazedListsSortModel(sortedList, (IColumnPropertyAccessor)columnPropertyAccessor, configRegistry, (ILayer)this.columnHeaderDataLayer), false);
        DefaultRowHeaderDataProvider rowHeaderDataProvider = new DefaultRowHeaderDataProvider(this.bodyDataProvider);
        DefaultRowHeaderDataLayer rowHeaderDataLayer = new DefaultRowHeaderDataLayer((IDataProvider)rowHeaderDataProvider);
        RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)rowHeaderDataLayer, (ILayer)bodyLayer, bodyLayer.getSelectionLayer());
        DefaultCornerDataProvider cornerDataProvider = new DefaultCornerDataProvider((IDataProvider)columnHeaderDataProvider, (IDataProvider)rowHeaderDataProvider);
        DataLayer cornerDataLayer = new DataLayer((IDataProvider)cornerDataProvider);
        CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)cornerDataLayer, (ILayer)rowHeaderLayer, (ILayer)columnHeaderLayer);
        this.setBodyLayer((ILayer)bodyLayer);
        this.setColumnHeaderLayer((ILayer)columnHeaderSortableLayer);
        this.setRowHeaderLayer((ILayer)rowHeaderLayer);
        this.setCornerLayer((ILayer)cornerLayer);
    }

    public ColumnOverrideLabelAccumulator getColumnLabelAccumulator() {
        return this.columnLabelAccumulator;
    }

    public void setClientAreaProvider(IClientAreaProvider clientAreaProvider) {
        super.setClientAreaProvider(clientAreaProvider);
    }

    public DataLayer getBodyDataLayer() {
        return this.bodyDataLayer;
    }

    public AbstractLayer getColumnHeaderDataLayer() {
        return this.columnHeaderDataLayer;
    }

    public class ListDataProviderExample<E>
    extends ListDataProvider<E> {
        private int mColumnCount;

        public ListDataProviderExample(SortedList<E> sortedList, IColumnPropertyAccessor<E> columnPropertyAccessor) {
            super(sortedList, columnPropertyAccessor);
            this.mColumnCount = 0;
        }

        public int getColumnCount() {
            return this.mColumnCount == 0 ? 2 : this.mColumnCount;
        }

        public void setColumnCount(int pColumnCount) {
            this.mColumnCount = pColumnCount;
            this.fireColumnCountChangeEvent((ILayer)ColumnStructureUpdatesExampleGridLayer.this.bodyDataLayer);
        }

        private void fireColumnCountChangeEvent(ILayer layer) {
            if (layer instanceof AbstractLayer) {
                AbstractLayer alay = (AbstractLayer)layer;
                alay.fireLayerEvent((ILayerEvent)new MultiColumnStructuralChangeEventExtension(layer));
            }
        }

        private final class MultiColumnStructuralChangeEventExtension
        extends ColumnStructuralChangeEvent {
            private MultiColumnStructuralChangeEventExtension(ILayer layer) {
                super(layer, new Range[0]);
            }

            public Collection<StructuralDiff> getColumnDiffs() {
                return null;
            }

            public boolean isHorizontalStructureChanged() {
                return true;
            }

            public boolean convertToLocal(ILayer localLayer) {
                return true;
            }

            public ILayerEvent cloneEvent() {
                return new MultiColumnStructuralChangeEventExtension(this.getLayer());
            }
        }
    }
}

