/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples.examples._102_Configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ReflectiveColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.painter.cell.AutomaticRowHeightTextPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.ImagePainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.CellPainterDecorator;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.LineBorderDecorator;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.PaddingDecorator;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.HorizontalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeEnum;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class AutomaticRowHeightExample
extends AbstractNatExample {
    private static final Display DISPLAY = Display.getDefault();
    private final List<LogRecord> logMessages = new ArrayList<LogRecord>();

    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(new AutomaticRowHeightExample());
    }

    @Override
    public String getDescription() {
        return "Demonstrates how to implement a log viewer using NatTable with the percentage sizing and the automatic row height calculation feature. If you resize the window you will see the rows growing/shrinking to always show the whole content by wrapping the text and resizing the row heights.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridData layoutData = GridDataFactory.fillDefaults().grab(true, true).create();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)layoutData);
        this.loadMessages();
        ListDataProvider dataProvider = new ListDataProvider(this.logMessages, (IColumnAccessor)new ReflectiveColumnPropertyAccessor(new String[]{"message"}));
        DataLayer dataLayer = new DataLayer((IDataProvider)dataProvider);
        dataLayer.setColumnPercentageSizing(true);
        dataLayer.setColumnWidthPercentageByPosition(0, 100);
        dataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)new ValidatorMessageLabelAccumulator());
        ViewportLayer layer = new ViewportLayer((IUniqueIndexLayer)dataLayer);
        layer.setRegionName("BODY");
        NatTable natTable = new NatTable(panel, 538184448, (ILayer)layer, false);
        natTable.addConfiguration((IConfiguration)new ValidationMessageTableStyleConfiguration());
        natTable.configure();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)natTable);
        return panel;
    }

    private void loadMessages() {
        String text = "Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.";
        Level[] levels = new Level[]{Level.SEVERE, Level.WARNING, Level.INFO};
        String[] words = text.split(" ");
        Random levelRandom = new Random();
        Random wordRandom = new Random();
        int i = 0;
        while (i < 100) {
            int randWords = wordRandom.nextInt(words.length);
            String msg = "";
            int j = 0;
            while (j < randWords) {
                msg = String.valueOf(msg) + words[j] + " ";
                ++j;
            }
            this.logMessages.add(new LogRecord(levels[levelRandom.nextInt(levels.length)], msg));
            ++i;
        }
    }

    public class ValidationMessageTableStyleConfiguration
    extends DefaultNatTableStyleConfiguration {
        private int IMAGE_SIZE = GUIHelper.convertHorizontalPixelToDpi((int)16);

        public ValidationMessageTableStyleConfiguration() {
            JFaceResources.getImageRegistry().put("errorImage", ImageDescriptor.createFromImageData((ImageData)DISPLAY.getSystemImage(1).getImageData().scaledTo(this.IMAGE_SIZE, this.IMAGE_SIZE)));
            JFaceResources.getImageRegistry().put("warningImage", ImageDescriptor.createFromImageData((ImageData)DISPLAY.getSystemImage(8).getImageData().scaledTo(this.IMAGE_SIZE, this.IMAGE_SIZE)));
            JFaceResources.getImageRegistry().put("infoImage", ImageDescriptor.createFromImageData((ImageData)DISPLAY.getSystemImage(2).getImageData().scaledTo(this.IMAGE_SIZE, this.IMAGE_SIZE)));
            this.hAlign = HorizontalAlignmentEnum.LEFT;
            this.cellPainter = new LineBorderDecorator((ICellPainter)new PaddingDecorator((ICellPainter)new CellPainterDecorator((ICellPainter)new AutomaticRowHeightTextPainter(2), CellEdgeEnum.LEFT, (ICellPainter)new ImagePainter()), 0, 2, 0, 2));
        }

        public void configureRegistry(IConfigRegistry configRegistry) {
            super.configureRegistry(configRegistry);
            Style errorStyle = new Style();
            errorStyle.setAttributeValue(CellStyleAttributes.IMAGE, (Object)JFaceResources.getImageRegistry().get("errorImage"));
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)errorStyle, "NORMAL", Level.SEVERE.toString());
            Style warningStyle = new Style();
            warningStyle.setAttributeValue(CellStyleAttributes.IMAGE, (Object)JFaceResources.getImageRegistry().get("warningImage"));
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)warningStyle, "NORMAL", Level.WARNING.toString());
            Style informationStyle = new Style();
            informationStyle.setAttributeValue(CellStyleAttributes.IMAGE, (Object)JFaceResources.getImageRegistry().get("infoImage"));
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)informationStyle, "NORMAL", Level.INFO.toString());
        }
    }

    public class ValidatorMessageLabelAccumulator
    implements IConfigLabelAccumulator {
        public void accumulateConfigLabels(LabelStack configLabels, int columnPosition, int rowPosition) {
            LogRecord vm = (LogRecord)AutomaticRowHeightExample.this.logMessages.get(rowPosition);
            configLabels.addLabel(vm.getLevel().toString());
        }
    }
}

