/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples._700_AdditionalFunctions;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.data.IRowIdAccessor;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ReflectiveColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.dataset.person.Person;
import org.eclipse.nebula.widgets.nattable.dataset.person.PersonService;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.grid.data.DummyColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.layer.CompositeLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.painter.IOverlayPainter;
import org.eclipse.nebula.widgets.nattable.painter.NatTableBorderOverlayPainter;
import org.eclipse.nebula.widgets.nattable.reorder.ColumnReorderLayer;
import org.eclipse.nebula.widgets.nattable.selection.ISelectionModel;
import org.eclipse.nebula.widgets.nattable.selection.RowSelectionModel;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class _781_DragAndDropExample
extends AbstractNatExample {
    private NatTable firstNatTable;
    private NatTable secondNatTable;

    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(600, 400, new _781_DragAndDropExample());
    }

    @Override
    public String getDescription() {
        return "This example shows how add Drag&Drop support to NatTable instances.\nYou can drag rows from one NatTable instance to the other.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, true));
        List data = PersonService.getPersons((int)20);
        ArrayList<Person> subData1 = new ArrayList<Person>();
        int i = 0;
        while (i < 10) {
            Person p = (Person)data.get(i);
            subData1.add(p);
            ++i;
        }
        ArrayList<Person> subData2 = new ArrayList<Person>();
        int i2 = 10;
        while (i2 < 20) {
            Person p = (Person)data.get(i2);
            subData2.add(p);
            ++i2;
        }
        this.firstNatTable = this.createTable(container, subData1);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.firstNatTable);
        this.secondNatTable = this.createTable(container, subData2);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.secondNatTable);
        return container;
    }

    private NatTable createTable(Composite parent, List<Person> data) {
        String[] propertyNames = new String[]{"firstName", "lastName"};
        HashMap<String, String> propertyToLabelMap = new HashMap<String, String>();
        propertyToLabelMap.put("firstName", "Firstname");
        propertyToLabelMap.put("lastName", "Lastname");
        ReflectiveColumnPropertyAccessor columnPropertyAccessor = new ReflectiveColumnPropertyAccessor(propertyNames);
        ListDataProvider bodyDataProvider = new ListDataProvider(data, (IColumnAccessor)columnPropertyAccessor);
        DataLayer bodyDataLayer = new DataLayer((IDataProvider)bodyDataProvider);
        ColumnReorderLayer reorderLayer = new ColumnReorderLayer((IUniqueIndexLayer)bodyDataLayer);
        SelectionLayer selectionLayer = new SelectionLayer((IUniqueIndexLayer)reorderLayer);
        selectionLayer.setSelectionModel((ISelectionModel)new RowSelectionModel(selectionLayer, (IRowDataProvider)bodyDataProvider, (IRowIdAccessor)new IRowIdAccessor<Person>(){

            public Serializable getRowId(Person rowObject) {
                return Integer.valueOf(rowObject.getId());
            }
        }, false));
        ViewportLayer viewportLayer = new ViewportLayer((IUniqueIndexLayer)selectionLayer);
        ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)new DataLayer((IDataProvider)new DummyColumnHeaderDataProvider((IDataProvider)bodyDataProvider)), (ILayer)viewportLayer, selectionLayer);
        CompositeLayer compositeLayer = new CompositeLayer(1, 2);
        compositeLayer.setChildLayer("COLUMN_HEADER", (ILayer)columnHeaderLayer, 0, 0);
        compositeLayer.setChildLayer("BODY", (ILayer)viewportLayer, 0, 1);
        NatTable natTable = new NatTable(parent, (ILayer)compositeLayer);
        DragAndDropSupport dndSupport = new DragAndDropSupport(natTable, selectionLayer, data);
        Transfer[] transfer = new Transfer[]{TextTransfer.getInstance()};
        natTable.addDragSupport(1, transfer, (DragSourceListener)dndSupport);
        natTable.addDropSupport(1, transfer, (DropTargetListener)dndSupport);
        natTable.addOverlayPainter((IOverlayPainter)new NatTableBorderOverlayPainter(natTable.getConfigRegistry()));
        return natTable;
    }

    class DragAndDropSupport
    implements DragSourceListener,
    DropTargetListener {
        private final NatTable natTable;
        private final SelectionLayer selectionLayer;
        private final List<Person> data;
        private Person draggedPerson;
        private static final String DATA_SEPARATOR = "|";
        private final SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");

        public DragAndDropSupport(NatTable natTable, SelectionLayer selectionLayer, List<Person> data) {
            this.natTable = natTable;
            this.selectionLayer = selectionLayer;
            this.data = data;
        }

        public void dragStart(DragSourceEvent event) {
            if (this.selectionLayer.getSelectedRowCount() == 0) {
                event.doit = false;
            } else if (!this.natTable.getRegionLabelsByXY(event.x, event.y).hasLabel("BODY")) {
                event.doit = false;
            }
        }

        public void dragSetData(DragSourceEvent event) {
            List selection = ((RowSelectionModel)this.selectionLayer.getSelectionModel()).getSelectedRowObjects();
            if (!selection.isEmpty()) {
                this.draggedPerson = (Person)selection.get(0);
                StringBuilder builder = new StringBuilder();
                builder.append(this.draggedPerson.getId()).append(DATA_SEPARATOR).append(this.draggedPerson.getFirstName()).append(DATA_SEPARATOR).append(this.draggedPerson.getLastName()).append(DATA_SEPARATOR).append(this.draggedPerson.getGender()).append(DATA_SEPARATOR).append(this.draggedPerson.isMarried()).append(DATA_SEPARATOR).append(this.sdf.format(this.draggedPerson.getBirthday()));
                event.data = builder.toString();
            }
        }

        public void dragFinished(DragSourceEvent event) {
            this.data.remove(this.draggedPerson);
            this.draggedPerson = null;
            this.selectionLayer.clear();
            this.natTable.refresh();
        }

        public void dragEnter(DropTargetEvent event) {
            event.detail = 1;
        }

        public void dragLeave(DropTargetEvent event) {
        }

        public void dragOperationChanged(DropTargetEvent event) {
        }

        public void dragOver(DropTargetEvent event) {
        }

        public void drop(DropTargetEvent event) {
            String[] data;
            String[] stringArray = data = event.data != null ? event.data.toString().split("\\|") : new String[]{};
            if (data.length > 0) {
                Person p = new Person(Integer.valueOf(data[0]).intValue());
                p.setFirstName(data[1]);
                p.setLastName(data[2]);
                p.setGender(Person.Gender.valueOf((String)data[3]));
                p.setMarried(Boolean.valueOf(data[4]).booleanValue());
                try {
                    p.setBirthday(this.sdf.parse(data[5]));
                }
                catch (ParseException parseException) {}
                int rowPosition = this.getRowPosition(event);
                if (rowPosition > 0) {
                    this.data.add(rowPosition - 1, p);
                } else {
                    this.data.add(p);
                }
                this.natTable.refresh();
            }
        }

        public void dropAccept(DropTargetEvent event) {
        }

        private int getRowPosition(DropTargetEvent event) {
            Point pt = event.display.map(null, (Control)this.natTable, event.x, event.y);
            int position = this.natTable.getRowPositionByY(pt.y);
            return position;
        }
    }
}

