/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples._600_GlazedLists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SortedList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.config.NullComparator;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ReflectiveColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.dataset.person.PersonService;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.GlazedListsEventLayer;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.GlazedListsSortModel;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultColumnHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultRowHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.ColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ColumnLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.reorder.ColumnReorderLayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.sort.ISortModel;
import org.eclipse.nebula.widgets.nattable.sort.SortConfigAttributes;
import org.eclipse.nebula.widgets.nattable.sort.SortDirectionEnum;
import org.eclipse.nebula.widgets.nattable.sort.SortHeaderLayer;
import org.eclipse.nebula.widgets.nattable.sort.config.SingleClickSortConfiguration;
import org.eclipse.nebula.widgets.nattable.ui.menu.DebugMenuConfiguration;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class _602_GlazedListsSortingExample
extends AbstractNatExample {
    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(new _602_GlazedListsSortingExample());
    }

    @Override
    public String getDescription() {
        return "This example shows the usage of the SortHeaderLayer within a grid that is using GlazedLists SortedList for sorting.\n\nFeatures:\nThe contents of the grid are kept in sorted order as the rows are added/removed.\nCustom comparators can be applied to each column.\nCustom comparator applied to the 'Lastname' column that will always sort 'Simpson' at the top.\nSorting is turned off for the 'Gender' column.\n\nKey bindings:\nSort by left clicking on the column header.\nAdd columns to the existing sort by (Alt + left click) on the column header\n";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        String[] propertyNames = new String[]{"firstName", "lastName", "gender", "married", "birthday"};
        HashMap<String, String> propertyToLabelMap = new HashMap<String, String>();
        propertyToLabelMap.put("firstName", "Firstname");
        propertyToLabelMap.put("lastName", "Lastname");
        propertyToLabelMap.put("gender", "Gender");
        propertyToLabelMap.put("married", "Married");
        propertyToLabelMap.put("birthday", "Birthday");
        EventList persons = GlazedLists.eventList((Collection)PersonService.getPersons((int)10));
        SortedList sortedList = new SortedList(persons, null);
        ReflectiveColumnPropertyAccessor accessor = new ReflectiveColumnPropertyAccessor(propertyNames);
        ListDataProvider bodyDataProvider = new ListDataProvider((List)sortedList, (IColumnAccessor)accessor);
        DataLayer bodyDataLayer = new DataLayer((IDataProvider)bodyDataProvider);
        GlazedListsEventLayer eventLayer = new GlazedListsEventLayer((IUniqueIndexLayer)bodyDataLayer, (EventList)sortedList);
        ColumnReorderLayer columnReorderLayer = new ColumnReorderLayer((IUniqueIndexLayer)eventLayer);
        ColumnHideShowLayer columnHideShowLayer = new ColumnHideShowLayer((IUniqueIndexLayer)columnReorderLayer);
        SelectionLayer selectionLayer = new SelectionLayer((IUniqueIndexLayer)columnHideShowLayer);
        ViewportLayer viewportLayer = new ViewportLayer((IUniqueIndexLayer)selectionLayer);
        DefaultColumnHeaderDataProvider columnHeaderDataProvider = new DefaultColumnHeaderDataProvider(propertyNames, propertyToLabelMap);
        DefaultColumnHeaderDataLayer columnHeaderDataLayer = new DefaultColumnHeaderDataLayer((IDataProvider)columnHeaderDataProvider);
        ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)columnHeaderDataLayer, (ILayer)viewportLayer, selectionLayer);
        columnHeaderDataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)new ColumnLabelAccumulator());
        ConfigRegistry configRegistry = new ConfigRegistry();
        final SortHeaderLayer sortHeaderLayer = new SortHeaderLayer((ILayer)columnHeaderLayer, (ISortModel)new GlazedListsSortModel(sortedList, (IColumnPropertyAccessor)accessor, (IConfigRegistry)configRegistry, (ILayer)columnHeaderDataLayer));
        DefaultRowHeaderDataProvider rowHeaderDataProvider = new DefaultRowHeaderDataProvider((IDataProvider)bodyDataProvider);
        DefaultRowHeaderDataLayer rowHeaderDataLayer = new DefaultRowHeaderDataLayer((IDataProvider)rowHeaderDataProvider);
        RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)rowHeaderDataLayer, (ILayer)viewportLayer, selectionLayer);
        DefaultCornerDataProvider cornerDataProvider = new DefaultCornerDataProvider((IDataProvider)columnHeaderDataProvider, (IDataProvider)rowHeaderDataProvider);
        DataLayer cornerDataLayer = new DataLayer((IDataProvider)cornerDataProvider);
        CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)cornerDataLayer, (ILayer)rowHeaderLayer, (ILayer)sortHeaderLayer);
        GridLayer gridLayer = new GridLayer((ILayer)viewportLayer, (ILayer)sortHeaderLayer, (ILayer)rowHeaderLayer, (ILayer)cornerLayer);
        NatTable natTable = new NatTable(parent, (ILayer)gridLayer, false);
        natTable.setConfigRegistry((IConfigRegistry)configRegistry);
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        natTable.addConfiguration((IConfiguration)new SingleClickSortConfiguration());
        natTable.addConfiguration((IConfiguration)new DebugMenuConfiguration(natTable));
        natTable.addConfiguration((IConfiguration)new AbstractRegistryConfiguration(){

            public void configureRegistry(IConfigRegistry configRegistry) {
                configRegistry.registerConfigAttribute(SortConfigAttributes.SORT_COMPARATOR, (Object)new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        boolean sortDesc = sortHeaderLayer.getSortModel().getSortDirection(1).equals((Object)SortDirectionEnum.DESC);
                        if ("Simpson".equals(o1) && !"Simpson".equals(o2)) {
                            return sortDesc ? 1 : -1;
                        }
                        if (!"Simpson".equals(o1) && "Simpson".equals(o2)) {
                            return sortDesc ? -1 : 1;
                        }
                        return o1.compareToIgnoreCase(o2);
                    }
                }, "NORMAL", "COLUMN_1");
                configRegistry.registerConfigAttribute(SortConfigAttributes.SORT_COMPARATOR, (Object)new NullComparator(), "NORMAL", "COLUMN_2");
            }
        });
        natTable.configure();
        return natTable;
    }
}

