/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples._500_Layers._505_Selection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.command.VisualRefreshCommand;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.data.IRowIdAccessor;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ReflectiveColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.dataset.person.Person;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.layer.CompositeLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.painter.IOverlayPainter;
import org.eclipse.nebula.widgets.nattable.painter.NatTableBorderOverlayPainter;
import org.eclipse.nebula.widgets.nattable.selection.ISelectionModel;
import org.eclipse.nebula.widgets.nattable.selection.RowSelectionModel;
import org.eclipse.nebula.widgets.nattable.selection.RowSelectionProvider;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.style.theme.ModernNatTableThemeConfiguration;
import org.eclipse.nebula.widgets.nattable.style.theme.ThemeConfiguration;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class _5054_SelectionProviderExample
extends AbstractNatExample {
    public static final String ACTIVE_LABEL = "ACTIVE";
    private boolean isFirstSelectionProvider = true;

    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(600, 400, new _5054_SelectionProviderExample());
    }

    @Override
    public String getDescription() {
        return "This example shows how to use JFace ISelectionProvider mechanism with a NatTable grid composition. For this the RowSelectionProvider adapter class is used which also allows switching the NatTable instance that provides the selection at runtime.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout(2, true));
        String[] propertyNames = new String[]{"lastName", "firstName"};
        HashMap<String, String> propertyToLabelMap = new HashMap<String, String>();
        propertyToLabelMap.put("lastName", "Lastname");
        propertyToLabelMap.put("firstName", "Firstname");
        ReflectiveColumnPropertyAccessor columnPropertyAccessor = new ReflectiveColumnPropertyAccessor(propertyNames);
        IRowIdAccessor<Person> rowIdAccessor = new IRowIdAccessor<Person>(){

            public Serializable getRowId(Person rowObject) {
                return Integer.valueOf(rowObject.getId());
            }
        };
        ListDataProvider firstBodyDataProvider = new ListDataProvider(this.getSimpsonsList(), (IColumnAccessor)columnPropertyAccessor);
        DataLayer firstBodyDataLayer = new DataLayer((IDataProvider)firstBodyDataProvider);
        final SelectionLayer firstSelectionLayer = new SelectionLayer((IUniqueIndexLayer)firstBodyDataLayer);
        ViewportLayer firstViewportLayer = new ViewportLayer((IUniqueIndexLayer)firstSelectionLayer);
        firstSelectionLayer.setSelectionModel((ISelectionModel)new RowSelectionModel(firstSelectionLayer, (IRowDataProvider)firstBodyDataProvider, (IRowIdAccessor)rowIdAccessor));
        DefaultColumnHeaderDataProvider columnHeaderDataProvider = new DefaultColumnHeaderDataProvider(propertyNames, propertyToLabelMap);
        DataLayer firstColumnHeaderDataLayer = new DataLayer((IDataProvider)columnHeaderDataProvider);
        ColumnHeaderLayer firstColumnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)firstColumnHeaderDataLayer, (ILayer)firstViewportLayer, firstSelectionLayer);
        firstColumnHeaderDataLayer.setConfigLabelAccumulator(new IConfigLabelAccumulator(){

            public void accumulateConfigLabels(LabelStack configLabels, int columnPosition, int rowPosition) {
                if (_5054_SelectionProviderExample.this.isFirstSelectionProvider) {
                    configLabels.addLabelOnTop(_5054_SelectionProviderExample.ACTIVE_LABEL);
                }
            }
        });
        CompositeLayer firstCompositeLayer = new CompositeLayer(1, 2);
        firstCompositeLayer.setChildLayer("COLUMN_HEADER", (ILayer)firstColumnHeaderLayer, 0, 0);
        firstCompositeLayer.setChildLayer("BODY", (ILayer)firstViewportLayer, 0, 1);
        NatTable firstNatTable = new NatTable(panel, (ILayer)firstCompositeLayer, false);
        firstNatTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        firstNatTable.addConfiguration((IConfiguration)new ActiveTableStyleConfiguration());
        firstNatTable.configure();
        firstNatTable.setTheme((ThemeConfiguration)new ModernNatTableThemeConfiguration());
        firstNatTable.addOverlayPainter((IOverlayPainter)new NatTableBorderOverlayPainter());
        ListDataProvider secondBodyDataProvider = new ListDataProvider(this.getFlandersList(), (IColumnAccessor)columnPropertyAccessor);
        DataLayer secondBodyDataLayer = new DataLayer((IDataProvider)secondBodyDataProvider);
        SelectionLayer secondSelectionLayer = new SelectionLayer((IUniqueIndexLayer)secondBodyDataLayer);
        ViewportLayer secondViewportLayer = new ViewportLayer((IUniqueIndexLayer)secondSelectionLayer);
        secondSelectionLayer.setSelectionModel((ISelectionModel)new RowSelectionModel(secondSelectionLayer, (IRowDataProvider)secondBodyDataProvider, (IRowIdAccessor)rowIdAccessor));
        DataLayer secondColumnHeaderDataLayer = new DataLayer((IDataProvider)columnHeaderDataProvider);
        ColumnHeaderLayer secondColumnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)secondColumnHeaderDataLayer, (ILayer)secondViewportLayer, secondSelectionLayer);
        secondColumnHeaderDataLayer.setConfigLabelAccumulator(new IConfigLabelAccumulator(){

            public void accumulateConfigLabels(LabelStack configLabels, int columnPosition, int rowPosition) {
                if (!_5054_SelectionProviderExample.this.isFirstSelectionProvider) {
                    configLabels.addLabelOnTop(_5054_SelectionProviderExample.ACTIVE_LABEL);
                }
            }
        });
        CompositeLayer secondCompositeLayer = new CompositeLayer(1, 2);
        secondCompositeLayer.setChildLayer("COLUMN_HEADER", (ILayer)secondColumnHeaderLayer, 0, 0);
        secondCompositeLayer.setChildLayer("BODY", (ILayer)secondViewportLayer, 0, 1);
        NatTable secondNatTable = new NatTable(panel, (ILayer)secondCompositeLayer, false);
        secondNatTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        secondNatTable.addConfiguration((IConfiguration)new ActiveTableStyleConfiguration());
        secondNatTable.configure();
        secondNatTable.setTheme((ThemeConfiguration)new ModernNatTableThemeConfiguration());
        secondNatTable.addOverlayPainter((IOverlayPainter)new NatTableBorderOverlayPainter());
        final RowSelectionProvider selectionProvider = new RowSelectionProvider(firstSelectionLayer, (IRowDataProvider)firstBodyDataProvider);
        selectionProvider.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                _5054_SelectionProviderExample.this.log("Selection changed:");
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                for (Person selected : selection) {
                    _5054_SelectionProviderExample.this.log("  " + selected.getFirstName() + " " + selected.getLastName());
                }
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)firstNatTable);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)secondNatTable);
        Composite buttonArea = new Composite(panel, 0);
        buttonArea.setLayout((Layout)new RowLayout());
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)buttonArea);
        Button button = new Button(buttonArea, 8);
        button.setText("Change selection provider");
        button.addSelectionListener((SelectionListener)new SelectionAdapter((IRowDataProvider)firstBodyDataProvider, secondSelectionLayer, (IRowDataProvider)secondBodyDataProvider, firstNatTable, secondNatTable){
            private final /* synthetic */ IRowDataProvider val$firstBodyDataProvider;
            private final /* synthetic */ SelectionLayer val$secondSelectionLayer;
            private final /* synthetic */ IRowDataProvider val$secondBodyDataProvider;
            private final /* synthetic */ NatTable val$firstNatTable;
            private final /* synthetic */ NatTable val$secondNatTable;
            {
                this.val$firstBodyDataProvider = iRowDataProvider;
                this.val$secondSelectionLayer = selectionLayer2;
                this.val$secondBodyDataProvider = iRowDataProvider2;
                this.val$firstNatTable = natTable;
                this.val$secondNatTable = natTable2;
            }

            public void widgetSelected(SelectionEvent e) {
                _5054_SelectionProviderExample.this.isFirstSelectionProvider = !_5054_SelectionProviderExample.this.isFirstSelectionProvider;
                if (_5054_SelectionProviderExample.this.isFirstSelectionProvider) {
                    selectionProvider.updateSelectionProvider(firstSelectionLayer, this.val$firstBodyDataProvider);
                } else {
                    selectionProvider.updateSelectionProvider(this.val$secondSelectionLayer, this.val$secondBodyDataProvider);
                }
                this.val$firstNatTable.doCommand((ILayerCommand)new VisualRefreshCommand());
                this.val$secondNatTable.doCommand((ILayerCommand)new VisualRefreshCommand());
            }
        });
        Text output = this.setupTextArea(panel);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)output);
        return panel;
    }

    private List<Person> getSimpsonsList() {
        ArrayList<Person> result = new ArrayList<Person>();
        result.add(new Person(1, "Homer", "Simpson", Person.Gender.MALE, true, new Date()));
        result.add(new Person(2, "Marge", "Simpson", Person.Gender.FEMALE, true, new Date()));
        result.add(new Person(3, "Bart", "Simpson", Person.Gender.MALE, false, new Date()));
        result.add(new Person(4, "Lisa", "Simpson", Person.Gender.FEMALE, false, new Date()));
        result.add(new Person(5, "Maggie", "Simpson", Person.Gender.FEMALE, false, new Date()));
        return result;
    }

    private List<Person> getFlandersList() {
        ArrayList<Person> result = new ArrayList<Person>();
        result.add(new Person(6, "Ned", "Flanders", Person.Gender.MALE, true, new Date()));
        result.add(new Person(7, "Maude", "Flanders", Person.Gender.FEMALE, true, new Date()));
        result.add(new Person(8, "Rod", "Flanders", Person.Gender.MALE, false, new Date()));
        result.add(new Person(9, "Todd", "Flanders", Person.Gender.MALE, false, new Date()));
        return result;
    }

    class ActiveTableStyleConfiguration
    extends AbstractRegistryConfiguration {
        ActiveTableStyleConfiguration() {
        }

        public void configureRegistry(IConfigRegistry configRegistry) {
            Style style = new Style();
            style.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)GUIHelper.COLOR_BLUE);
            style.setAttributeValue(CellStyleAttributes.FOREGROUND_COLOR, (Object)GUIHelper.COLOR_WHITE);
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)style, "NORMAL", _5054_SelectionProviderExample.ACTIVE_LABEL);
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)style, "SELECT", _5054_SelectionProviderExample.ACTIVE_LABEL);
        }
    }
}

