/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples._500_Layers._501_Data;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IEditableRule;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ISpanningDataProvider;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.config.DefaultEditBindings;
import org.eclipse.nebula.widgets.nattable.edit.config.DefaultEditConfiguration;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.SpanningDataLayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.DataCell;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class _5014_SpanningDataLayerExample
extends AbstractNatExample {
    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(new _5014_SpanningDataLayerExample());
    }

    @Override
    public String getDescription() {
        return "This example shows the usage of the SpanningDataLayer. It uses a ISpanningDataProvider that spans several periodic blocks. Editing is also enabled to show and verify that editing of spanned cells is working correctly.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        ViewportLayer layer = new ViewportLayer((IUniqueIndexLayer)new SelectionLayer((IUniqueIndexLayer)new SpanningDataLayer((ISpanningDataProvider)new DummySpanningBodyDataProvider(100, 100))));
        layer.setRegionName("BODY");
        NatTable natTable = new NatTable(parent, (ILayer)layer, false);
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        layer.addConfiguration((IConfiguration)new DefaultEditBindings());
        layer.addConfiguration((IConfiguration)new DefaultEditConfiguration());
        layer.addConfiguration((IConfiguration)new AbstractRegistryConfiguration(){

            public void configureRegistry(IConfigRegistry configRegistry) {
                configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)IEditableRule.ALWAYS_EDITABLE);
            }
        });
        natTable.configure();
        return natTable;
    }

    class DummySpanningBodyDataProvider
    implements IDataProvider,
    ISpanningDataProvider {
        private final int columnCount;
        private final int rowCount;
        private Map<Point, Object> values = new HashMap<Point, Object>();
        private static final int BLOCK_SIZE = 4;
        private static final int CELL_SPAN = 2;

        public DummySpanningBodyDataProvider(int columnCount, int rowCount) {
            this.columnCount = columnCount;
            this.rowCount = rowCount;
        }

        public int getColumnCount() {
            return this.columnCount;
        }

        public int getRowCount() {
            return this.rowCount;
        }

        public Object getDataValue(int columnIndex, int rowIndex) {
            Point point = new Point(columnIndex, rowIndex);
            if (this.values.containsKey(point)) {
                return this.values.get(point);
            }
            return "Col: " + (columnIndex + 1) + ", Row: " + (rowIndex + 1);
        }

        public void setDataValue(int columnIndex, int rowIndex, Object newValue) {
            this.values.put(new Point(columnIndex, rowIndex), newValue);
        }

        public DataCell getCellByPosition(int columnPosition, int rowPosition) {
            int columnBlock = columnPosition / 4;
            int rowBlock = rowPosition / 4;
            boolean isSpanned = this.isEven(columnBlock + rowBlock) && columnPosition % 4 < 2 && rowPosition % 4 < 2;
            int columnSpan = isSpanned ? 2 : 1;
            int rowSpan = isSpanned ? 2 : 1;
            int cellColumnPosition = columnPosition;
            int cellRowPosition = rowPosition;
            if (isSpanned) {
                cellColumnPosition -= columnPosition % 4;
                cellRowPosition -= rowPosition % 4;
            }
            return new DataCell(cellColumnPosition, cellRowPosition, columnSpan, rowSpan);
        }

        private boolean isEven(int i) {
            return i % 2 == 0;
        }
    }
}

