/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.ui.menu;

import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.columnCategories.ChooseColumnsFromCategoriesCommand;
import org.eclipse.nebula.widgets.nattable.columnChooser.command.DisplayColumnChooserCommand;
import org.eclipse.nebula.widgets.nattable.columnRename.DisplayColumnRenameDialogCommand;
import org.eclipse.nebula.widgets.nattable.filterrow.command.ClearAllFiltersCommand;
import org.eclipse.nebula.widgets.nattable.filterrow.command.ToggleFilterRowCommand;
import org.eclipse.nebula.widgets.nattable.group.command.OpenCreateColumnGroupDialog;
import org.eclipse.nebula.widgets.nattable.group.command.UngroupColumnCommand;
import org.eclipse.nebula.widgets.nattable.hideshow.command.ColumnHideCommand;
import org.eclipse.nebula.widgets.nattable.hideshow.command.ShowAllColumnsCommand;
import org.eclipse.nebula.widgets.nattable.resize.command.InitializeAutoResizeColumnsCommand;
import org.eclipse.nebula.widgets.nattable.resize.command.InitializeAutoResizeRowsCommand;
import org.eclipse.nebula.widgets.nattable.style.editor.command.DisplayColumnStyleEditorCommand;
import org.eclipse.nebula.widgets.nattable.ui.NatEventData;
import org.eclipse.nebula.widgets.nattable.ui.menu.IMenuItemProvider;
import org.eclipse.nebula.widgets.nattable.util.GCFactory;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Widget;

public class MenuItemProviders {
    public static NatEventData getNatEventData(SelectionEvent selectionEvent) {
        Widget widget = selectionEvent.widget;
        if (widget == null || !(widget instanceof MenuItem)) {
            return null;
        }
        MenuItem menuItem = (MenuItem)widget;
        Object data = null;
        for (Menu parentMenu = menuItem.getParent(); parentMenu != null; parentMenu = parentMenu.getParentMenu()) {
            if (parentMenu.getData() == null) {
                continue;
            }
            data = parentMenu.getData();
            break;
        }
        return data != null ? (NatEventData)data : null;
    }

    public static IMenuItemProvider hideColumnMenuItemProvider() {
        return MenuItemProviders.hideColumnMenuItemProvider(Messages.getString("MenuItemProviders.hideColumn"));
    }

    public static IMenuItemProvider hideColumnMenuItemProvider(final String menuLabel) {
        return new IMenuItemProvider(){

            public void addMenuItem(final NatTable natTable, Menu popupMenu) {
                MenuItem menuItem = new MenuItem(popupMenu, 8);
                menuItem.setText(menuLabel);
                menuItem.setImage(GUIHelper.getImage("hide_column"));
                menuItem.setEnabled(true);
                menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        int columnPosition = MenuItemProviders.getNatEventData(event).getColumnPosition();
                        natTable.doCommand(new ColumnHideCommand(natTable, columnPosition));
                    }
                });
            }
        };
    }

    public static IMenuItemProvider showAllColumnMenuItemProvider() {
        return MenuItemProviders.showAllColumnMenuItemProvider(Messages.getString("MenuItemProviders.showAllColumns"));
    }

    public static IMenuItemProvider showAllColumnMenuItemProvider(final String menuLabel) {
        return new IMenuItemProvider(){

            public void addMenuItem(final NatTable natTable, Menu popupMenu) {
                MenuItem showAllColumns = new MenuItem(popupMenu, 8);
                showAllColumns.setText(menuLabel);
                showAllColumns.setImage(GUIHelper.getImage("show_column"));
                showAllColumns.setEnabled(true);
                showAllColumns.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        natTable.doCommand(new ShowAllColumnsCommand());
                    }
                });
            }
        };
    }

    public static IMenuItemProvider autoResizeColumnMenuItemProvider() {
        return MenuItemProviders.autoResizeColumnMenuItemProvider(Messages.getString("MenuItemProviders.autoResizeColumn"));
    }

    public static IMenuItemProvider autoResizeColumnMenuItemProvider(final String menuLabel) {
        return new IMenuItemProvider(){

            public void addMenuItem(final NatTable natTable, Menu popupMenu) {
                MenuItem autoResizeColumns = new MenuItem(popupMenu, 8);
                autoResizeColumns.setText(menuLabel);
                autoResizeColumns.setImage(GUIHelper.getImage("auto_resize"));
                autoResizeColumns.setEnabled(true);
                autoResizeColumns.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        int columnPosition = MenuItemProviders.getNatEventData(event).getColumnPosition();
                        natTable.doCommand(new InitializeAutoResizeColumnsCommand(natTable, columnPosition, natTable.getConfigRegistry(), new GCFactory((Drawable)natTable)));
                    }
                });
            }
        };
    }

    public static IMenuItemProvider autoResizeRowMenuItemProvider() {
        return MenuItemProviders.autoResizeRowMenuItemProvider(Messages.getString("MenuItemProviders.autoResizeRow"));
    }

    public static IMenuItemProvider autoResizeRowMenuItemProvider(final String menuLabel) {
        return new IMenuItemProvider(){

            public void addMenuItem(final NatTable natTable, Menu popupMenu) {
                MenuItem autoResizeRows = new MenuItem(popupMenu, 8);
                autoResizeRows.setText(menuLabel);
                autoResizeRows.setEnabled(true);
                autoResizeRows.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        int rowPosition = MenuItemProviders.getNatEventData(event).getRowPosition();
                        natTable.doCommand(new InitializeAutoResizeRowsCommand(natTable, rowPosition, natTable.getConfigRegistry(), new GCFactory((Drawable)natTable)));
                    }
                });
            }
        };
    }

    public static IMenuItemProvider autoResizeAllSelectedColumnMenuItemProvider() {
        return MenuItemProviders.autoResizeAllSelectedColumnMenuItemProvider(Messages.getString("MenuItemProviders.autoResizeAllSelectedColumns"));
    }

    public static IMenuItemProvider autoResizeAllSelectedColumnMenuItemProvider(final String menuLabel) {
        return new IMenuItemProvider(){

            public void addMenuItem(final NatTable natTable, Menu popupMenu) {
                MenuItem autoResizeColumns = new MenuItem(popupMenu, 8);
                autoResizeColumns.setText(menuLabel);
                autoResizeColumns.setEnabled(true);
                autoResizeColumns.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        int columnPosition = MenuItemProviders.getNatEventData(event).getColumnPosition();
                        natTable.doCommand(new InitializeAutoResizeColumnsCommand(natTable, columnPosition, natTable.getConfigRegistry(), new GCFactory((Drawable)natTable)));
                    }
                });
            }
        };
    }

    public static IMenuItemProvider columnChooserMenuItemProvider() {
        return MenuItemProviders.columnChooserMenuItemProvider(Messages.getString("MenuItemProviders.chooseColumns"));
    }

    public static IMenuItemProvider columnChooserMenuItemProvider(final String menuLabel) {
        return new IMenuItemProvider(){

            public void addMenuItem(final NatTable natTable, Menu popupMenu) {
                MenuItem columnChooser = new MenuItem(popupMenu, 8);
                columnChooser.setText(menuLabel);
                columnChooser.setImage(GUIHelper.getImage("column_chooser"));
                columnChooser.setEnabled(true);
                columnChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        natTable.doCommand(new DisplayColumnChooserCommand(natTable));
                    }
                });
            }
        };
    }

    public static IMenuItemProvider columnStyleEditorMenuItemProvider() {
        return MenuItemProviders.columnStyleEditorMenuItemProvider(Messages.getString("MenuItemProviders.editStyles"));
    }

    public static IMenuItemProvider columnStyleEditorMenuItemProvider(final String menuLabel) {
        return new IMenuItemProvider(){

            public void addMenuItem(final NatTable natTable, Menu popupMenu) {
                MenuItem columnStyleEditor = new MenuItem(popupMenu, 8);
                columnStyleEditor.setText(menuLabel);
                columnStyleEditor.setImage(GUIHelper.getImage("preferences"));
                columnStyleEditor.setEnabled(true);
                columnStyleEditor.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        int rowPosition = MenuItemProviders.getNatEventData(event).getRowPosition();
                        int columnPosition = MenuItemProviders.getNatEventData(event).getColumnPosition();
                        natTable.doCommand(new DisplayColumnStyleEditorCommand(natTable, natTable.getConfigRegistry(), columnPosition, rowPosition));
                    }
                });
            }
        };
    }

    public static IMenuItemProvider renameColumnMenuItemProvider() {
        return MenuItemProviders.renameColumnMenuItemProvider(Messages.getString("MenuItemProviders.renameColumn"));
    }

    public static IMenuItemProvider renameColumnMenuItemProvider(final String label) {
        return new IMenuItemProvider(){

            public void addMenuItem(final NatTable natTable, Menu popupMenu) {
                MenuItem menuItem = new MenuItem(popupMenu, 8);
                menuItem.setText(label);
                menuItem.setEnabled(true);
                menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        natTable.doCommand(new DisplayColumnRenameDialogCommand(natTable, MenuItemProviders.getNatEventData(event).getColumnPosition()));
                    }
                });
            }
        };
    }

    public static IMenuItemProvider createColumnGroupMenuItemProvider() {
        return MenuItemProviders.createColumnGroupMenuItemProvider(Messages.getString("MenuItemProviders.createColumnGroup"));
    }

    public static IMenuItemProvider createColumnGroupMenuItemProvider(final String menuLabel) {
        return new IMenuItemProvider(){

            public void addMenuItem(final NatTable natTable, Menu popupMenu) {
                MenuItem columnStyleEditor = new MenuItem(popupMenu, 8);
                columnStyleEditor.setText(menuLabel);
                columnStyleEditor.setEnabled(true);
                columnStyleEditor.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        natTable.doCommand(new OpenCreateColumnGroupDialog(natTable.getShell()));
                    }
                });
            }
        };
    }

    public static IMenuItemProvider ungroupColumnsMenuItemProvider() {
        return MenuItemProviders.ungroupColumnsMenuItemProvider(Messages.getString("MenuItemProviders.ungroupColumns"));
    }

    public static IMenuItemProvider ungroupColumnsMenuItemProvider(final String menuLabel) {
        return new IMenuItemProvider(){

            public void addMenuItem(final NatTable natTable, Menu popupMenu) {
                MenuItem columnStyleEditor = new MenuItem(popupMenu, 8);
                columnStyleEditor.setText(menuLabel);
                columnStyleEditor.setEnabled(true);
                columnStyleEditor.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        natTable.doCommand(new UngroupColumnCommand());
                    }
                });
            }
        };
    }

    public static IMenuItemProvider inspectLabelsMenuItemProvider() {
        return new IMenuItemProvider(){

            public void addMenuItem(NatTable natTable, Menu popupMenu) {
                MenuItem inspectLabelsMenuItem = new MenuItem(popupMenu, 8);
                inspectLabelsMenuItem.setText(Messages.getString("MenuItemProviders.debugInfo"));
                inspectLabelsMenuItem.setEnabled(true);
                inspectLabelsMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        NatEventData natEventData = MenuItemProviders.getNatEventData(e);
                        NatTable natTable = natEventData.getNatTable();
                        int columnPosition = natEventData.getColumnPosition();
                        int rowPosition = natEventData.getRowPosition();
                        String msg = "Display mode: " + natTable.getDisplayModeByPosition(columnPosition, rowPosition) + "\nConfig labels: " + natTable.getConfigLabelsByPosition(columnPosition, rowPosition) + "\nData value: " + natTable.getDataValueByPosition(columnPosition, rowPosition) + "\n\nColumn position: " + columnPosition + "\nColumn index: " + natTable.getColumnIndexByPosition(columnPosition) + "\n\nRow position: " + rowPosition + "\nRow index: " + natTable.getRowIndexByPosition(rowPosition);
                        MessageBox messageBox = new MessageBox(natTable.getShell(), 34);
                        messageBox.setText(Messages.getString("MenuItemProviders.debugInformation"));
                        messageBox.setMessage(msg);
                        messageBox.open();
                    }
                });
            }
        };
    }

    public static IMenuItemProvider categoriesBasedColumnChooserMenuItemProvider() {
        return MenuItemProviders.categoriesBasedColumnChooserMenuItemProvider(Messages.getString("MenuItemProviders.columnCategoriesChooser"));
    }

    public static IMenuItemProvider categoriesBasedColumnChooserMenuItemProvider(final String menuLabel) {
        return new IMenuItemProvider(){

            public void addMenuItem(final NatTable natTable, Menu popupMenu) {
                MenuItem columnChooser = new MenuItem(popupMenu, 8);
                columnChooser.setText(menuLabel);
                columnChooser.setImage(GUIHelper.getImage("column_categories_chooser"));
                columnChooser.setEnabled(true);
                columnChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        natTable.doCommand(new ChooseColumnsFromCategoriesCommand(natTable));
                    }
                });
            }
        };
    }

    public static IMenuItemProvider clearAllFiltersMenuItemProvider() {
        return MenuItemProviders.clearAllFiltersMenuItemProvider(Messages.getString("MenuItemProviders.clearAllFilters"));
    }

    public static IMenuItemProvider clearAllFiltersMenuItemProvider(final String menuLabel) {
        return new IMenuItemProvider(){

            public void addMenuItem(final NatTable natTable, Menu popupMenu) {
                MenuItem menuItem = new MenuItem(popupMenu, 8);
                menuItem.setText(menuLabel);
                menuItem.setImage(GUIHelper.getImage("remove_filter"));
                menuItem.setEnabled(true);
                menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        natTable.doCommand(new ClearAllFiltersCommand());
                    }
                });
            }
        };
    }

    public static IMenuItemProvider clearToggleFilterRowMenuItemProvider() {
        return MenuItemProviders.clearToggleFilterRowMenuItemProvider(Messages.getString("MenuItemProviders.toggleFilterRow"));
    }

    public static IMenuItemProvider clearToggleFilterRowMenuItemProvider(final String menuLabel) {
        return new IMenuItemProvider(){

            public void addMenuItem(final NatTable natTable, Menu popupMenu) {
                MenuItem menuItem = new MenuItem(popupMenu, 8);
                menuItem.setText(menuLabel);
                menuItem.setImage(GUIHelper.getImage("toggle_filter"));
                menuItem.setEnabled(true);
                menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        natTable.doCommand(new ToggleFilterRowCommand());
                    }
                });
            }
        };
    }

    public static IMenuItemProvider separatorMenuItemProvider() {
        return new IMenuItemProvider(){

            public void addMenuItem(NatTable natTable, Menu popupMenu) {
                new MenuItem(popupMenu, 2);
            }
        };
    }
}

