/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.reorder.action;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.IOverlayPainter;
import org.eclipse.nebula.widgets.nattable.reorder.command.ColumnReorderEndCommand;
import org.eclipse.nebula.widgets.nattable.reorder.command.ColumnReorderStartCommand;
import org.eclipse.nebula.widgets.nattable.selection.command.ClearAllSelectionsCommand;
import org.eclipse.nebula.widgets.nattable.ui.action.IDragMode;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeDetectUtil;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeEnum;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.nebula.widgets.nattable.viewport.command.ViewportDragCommand;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class ColumnReorderDragMode
implements IDragMode {
    private NatTable natTable;
    private MouseEvent initialEvent;
    private MouseEvent currentEvent;
    private int dragFromGridColumnPosition;
    protected ColumnReorderOverlayPainter targetOverlayPainter = new ColumnReorderOverlayPainter();

    public void mouseDown(NatTable natTable, MouseEvent event) {
        this.natTable = natTable;
        this.currentEvent = this.initialEvent = event;
        this.dragFromGridColumnPosition = this.getDragFromGridColumnPosition();
        natTable.addOverlayPainter(this.targetOverlayPainter);
        natTable.doCommand(new ClearAllSelectionsCommand());
        this.fireMoveStartCommand(natTable, this.dragFromGridColumnPosition);
    }

    public void mouseMove(NatTable natTable, MouseEvent event) {
        this.currentEvent = event;
        natTable.doCommand(new ViewportDragCommand(event.x, -1));
        natTable.redraw();
    }

    public void mouseUp(NatTable natTable, MouseEvent event) {
        natTable.removeOverlayPainter(this.targetOverlayPainter);
        int dragToGridColumnPosition = this.getDragToGridColumnPosition(this.getMoveDirection(event.x), natTable.getColumnPositionByX(event.x));
        if (!this.isValidTargetColumnPosition(natTable, this.dragFromGridColumnPosition, dragToGridColumnPosition, event)) {
            dragToGridColumnPosition = -1;
        }
        this.fireMoveEndCommand(natTable, dragToGridColumnPosition);
        natTable.doCommand(new ViewportDragCommand(-1, -1));
        natTable.redraw();
    }

    private int getDragFromGridColumnPosition() {
        return this.natTable.getColumnPositionByX(this.initialEvent.x);
    }

    private int getDragToGridColumnPosition(CellEdgeEnum moveDirection, int gridColumnPosition) {
        int dragToGridColumnPosition = -1;
        if (moveDirection != null) {
            switch (moveDirection) {
                case LEFT: {
                    dragToGridColumnPosition = gridColumnPosition;
                    break;
                }
                case RIGHT: {
                    dragToGridColumnPosition = gridColumnPosition + 1;
                }
            }
        }
        return dragToGridColumnPosition;
    }

    private CellEdgeEnum getMoveDirection(int x) {
        ILayerCell cell = this.getColumnCell(x);
        if (cell != null) {
            Rectangle selectedColumnHeaderRect = cell.getBounds();
            return CellEdgeDetectUtil.getHorizontalCellEdge(selectedColumnHeaderRect, new Point(x, this.initialEvent.y));
        }
        return null;
    }

    private ILayerCell getColumnCell(int x) {
        int gridColumnPosition = this.natTable.getColumnPositionByX(x);
        int gridRowPosition = this.natTable.getRowPositionByY(this.initialEvent.y);
        return this.natTable.getCellByPosition(gridColumnPosition, gridRowPosition);
    }

    protected boolean isValidTargetColumnPosition(ILayer natLayer, int dragFromGridColumnPosition, int dragToGridColumnPosition, MouseEvent event) {
        return dragFromGridColumnPosition >= 0 && dragToGridColumnPosition >= 0;
    }

    protected void fireMoveStartCommand(NatTable natTable, int dragFromGridColumnPosition) {
        natTable.doCommand(new ColumnReorderStartCommand(natTable, dragFromGridColumnPosition));
    }

    protected void fireMoveEndCommand(NatTable natTable, int dragToGridColumnPosition) {
        natTable.doCommand(new ColumnReorderEndCommand(natTable, dragToGridColumnPosition));
    }

    private class ColumnReorderOverlayPainter
    implements IOverlayPainter {
        private ColumnReorderOverlayPainter() {
        }

        public void paintOverlay(GC gc, ILayer layer) {
            int dragFromGridColumnPosition = ColumnReorderDragMode.this.getDragFromGridColumnPosition();
            if (((ColumnReorderDragMode)ColumnReorderDragMode.this).currentEvent.x > ColumnReorderDragMode.this.natTable.getWidth()) {
                return;
            }
            CellEdgeEnum moveDirection = ColumnReorderDragMode.this.getMoveDirection(((ColumnReorderDragMode)ColumnReorderDragMode.this).currentEvent.x);
            int dragToGridColumnPosition = ColumnReorderDragMode.this.getDragToGridColumnPosition(moveDirection, ColumnReorderDragMode.this.natTable.getColumnPositionByX(((ColumnReorderDragMode)ColumnReorderDragMode.this).currentEvent.x));
            if (ColumnReorderDragMode.this.isValidTargetColumnPosition(ColumnReorderDragMode.this.natTable, dragFromGridColumnPosition, dragToGridColumnPosition, ColumnReorderDragMode.this.currentEvent)) {
                int dragToColumnHandleX = -1;
                if (moveDirection != null) {
                    Rectangle selectedColumnHeaderRect = ColumnReorderDragMode.this.getColumnCell(((ColumnReorderDragMode)ColumnReorderDragMode.this).currentEvent.x).getBounds();
                    switch (moveDirection) {
                        case LEFT: {
                            dragToColumnHandleX = selectedColumnHeaderRect.x;
                            break;
                        }
                        case RIGHT: {
                            dragToColumnHandleX = selectedColumnHeaderRect.x + selectedColumnHeaderRect.width;
                        }
                    }
                }
                if (dragToColumnHandleX > 0) {
                    Color orgBgColor = gc.getBackground();
                    gc.setBackground(GUIHelper.COLOR_DARK_GRAY);
                    gc.fillRectangle(dragToColumnHandleX - 1, 0, 2, layer.getHeight());
                    gc.setBackground(orgBgColor);
                }
            }
        }
    }
}

