/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.hideshow.event;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionUtil;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.ColumnStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralDiff;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HideColumnPositionsEvent
extends ColumnStructuralChangeEvent {
    public HideColumnPositionsEvent(ILayer layer, Collection<Integer> columnPositions) {
        super(layer, PositionUtil.getRanges(columnPositions));
    }

    protected HideColumnPositionsEvent(HideColumnPositionsEvent event) {
        super(event);
    }

    @Override
    public HideColumnPositionsEvent cloneEvent() {
        return new HideColumnPositionsEvent(this);
    }

    @Override
    public Collection<StructuralDiff> getColumnDiffs() {
        ArrayList<StructuralDiff> columnDiffs = new ArrayList<StructuralDiff>();
        for (Range range : this.getColumnPositionRanges()) {
            StructuralDiff diff = new StructuralDiff(StructuralDiff.DiffTypeEnum.DELETE, range, new Range(range.start, range.start));
            columnDiffs.add(diff);
        }
        return columnDiffs;
    }

    @Override
    public boolean convertToLocal(ILayer localLayer) {
        super.convertToLocal(localLayer);
        return true;
    }
}

