/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.action;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupModel;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupUtils;
import org.eclipse.nebula.widgets.nattable.group.command.ReorderColumnGroupEndCommand;
import org.eclipse.nebula.widgets.nattable.group.command.ReorderColumnGroupStartCommand;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.reorder.action.ColumnReorderDragMode;
import org.eclipse.swt.events.MouseEvent;

public class ColumnGroupHeaderReorderDragMode
extends ColumnReorderDragMode {
    private final ColumnGroupModel model;
    private MouseEvent event;

    public ColumnGroupHeaderReorderDragMode(ColumnGroupModel model) {
        this.model = model;
    }

    protected boolean isValidTargetColumnPosition(ILayer natLayer, int fromGridColumnPosition, int toGridColumnPosition, MouseEvent event) {
        this.event = event;
        toGridColumnPosition = natLayer.getColumnPositionByX(event.x);
        return this.isValidTargetColumnPosition(natLayer, fromGridColumnPosition, toGridColumnPosition);
    }

    protected boolean isValidTargetColumnPosition(ILayer natLayer, int fromGridColumnPosition, int toGridColumnPosition) {
        int toColumnIndex = natLayer.getColumnIndexByPosition(toGridColumnPosition);
        boolean betweenGroups = false;
        if (this.event != null) {
            int minX = this.event.x - 4;
            int maxX = this.event.x + 4;
            betweenGroups = ColumnGroupUtils.isBetweenTwoGroups(natLayer, minX, maxX, this.model);
        }
        return !this.model.isPartOfAGroup(toColumnIndex) || betweenGroups;
    }

    protected void fireMoveStartCommand(NatTable natTable, int dragFromGridColumnPosition) {
        natTable.doCommand(new ReorderColumnGroupStartCommand(natTable, dragFromGridColumnPosition));
    }

    protected void fireMoveEndCommand(NatTable natTable, int dragToGridColumnPosition) {
        natTable.doCommand(new ReorderColumnGroupEndCommand(natTable, dragToGridColumnPosition));
    }
}

