/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.export;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.export.IExportFormatter;
import org.eclipse.nebula.widgets.nattable.export.ILayerExporter;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.print.command.PrintEntireGridCommand;
import org.eclipse.nebula.widgets.nattable.print.command.TurnViewportOffCommand;
import org.eclipse.nebula.widgets.nattable.print.command.TurnViewportOnCommand;
import org.eclipse.nebula.widgets.nattable.util.IClientAreaProvider;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NatExporter {
    private final Shell shell;

    public NatExporter(Shell shell) {
        this.shell = shell;
    }

    public void exportSingleLayer(final ILayer layer, final IConfigRegistry configRegistry) {
        final ILayerExporter exporter = configRegistry.getConfigAttribute(ILayerExporter.CONFIG_ATTRIBUTE, "NORMAL", new String[0]);
        final OutputStream outputStream = exporter.getOutputStream(this.shell);
        if (outputStream == null) {
            return;
        }
        Runnable exportRunnable = new Runnable(){

            public void run() {
                try {
                    try {
                        exporter.exportBegin(outputStream);
                        NatExporter.this.exportLayer(exporter, outputStream, "", layer, configRegistry);
                        exporter.exportEnd(outputStream);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to export.", e);
                    }
                }
                finally {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace(System.err);
                    }
                }
            }
        };
        if (this.shell != null) {
            this.shell.getDisplay().asyncExec(exportRunnable);
        } else {
            exportRunnable.run();
        }
    }

    public void exportMultipleNatTables(final ILayerExporter exporter, final Map<String, NatTable> natTablesMap) {
        final OutputStream outputStream = exporter.getOutputStream(this.shell);
        if (outputStream == null) {
            return;
        }
        Runnable exportRunnable = new Runnable(){

            public void run() {
                try {
                    try {
                        exporter.exportBegin(outputStream);
                        for (String name : natTablesMap.keySet()) {
                            NatTable natTable = (NatTable)natTablesMap.get(name);
                            NatExporter.this.exportLayer(exporter, outputStream, name, natTable, natTable.getConfigRegistry());
                        }
                        exporter.exportEnd(outputStream);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to export.", e);
                    }
                }
                finally {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace(System.err);
                    }
                }
            }
        };
        if (this.shell != null) {
            this.shell.getDisplay().asyncExec(exportRunnable);
        } else {
            exportRunnable.run();
        }
    }

    protected void exportLayer(ILayerExporter exporter, OutputStream outputStream, String layerName, ILayer layer, IConfigRegistry configRegistry) {
        IClientAreaProvider originalClientAreaProvider = layer.getClientAreaProvider();
        layer.doCommand(new TurnViewportOffCommand());
        this.setClientAreaToMaximum(layer);
        ProgressBar progressBar = null;
        if (this.shell != null) {
            Shell childShell = new Shell(this.shell.getDisplay(), 67680);
            childShell.setText(Messages.getString("NatExporter.exporting"));
            int startRow = 0;
            int endRow = layer.getRowCount() - 1;
            progressBar = new ProgressBar((Composite)childShell, 65536);
            progressBar.setMinimum(startRow);
            progressBar.setMaximum(endRow);
            progressBar.setBounds(0, 0, 400, 25);
            progressBar.setFocus();
            childShell.pack();
            childShell.open();
        }
        try {
            exporter.exportLayerBegin(outputStream, layerName);
            int rowPosition = 0;
            while (rowPosition < layer.getRowCount()) {
                exporter.exportRowBegin(outputStream, rowPosition);
                if (progressBar != null) {
                    progressBar.setSelection(rowPosition);
                }
                int columnPosition = 0;
                while (columnPosition < layer.getColumnCount()) {
                    ILayerCell cell = layer.getCellByPosition(columnPosition, rowPosition);
                    IExportFormatter exportFormatter = configRegistry.getConfigAttribute(CellConfigAttributes.EXPORT_FORMATTER, cell.getDisplayMode(), cell.getConfigLabels().getLabels());
                    Object exportDisplayValue = exportFormatter.formatForExport(cell, configRegistry);
                    exporter.exportCell(outputStream, exportDisplayValue, cell, configRegistry);
                    ++columnPosition;
                }
                exporter.exportRowEnd(outputStream, rowPosition);
                ++rowPosition;
            }
            exporter.exportLayerEnd(outputStream, layerName);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        layer.setClientAreaProvider(originalClientAreaProvider);
        layer.doCommand(new TurnViewportOnCommand());
        if (progressBar != null) {
            Shell childShell = progressBar.getShell();
            progressBar.dispose();
            childShell.dispose();
        }
    }

    private void setClientAreaToMaximum(ILayer layer) {
        final Rectangle maxClientArea = new Rectangle(0, 0, layer.getWidth(), layer.getHeight());
        layer.setClientAreaProvider(new IClientAreaProvider(){

            public Rectangle getClientArea() {
                return maxClientArea;
            }
        });
        layer.doCommand(new PrintEntireGridCommand());
    }
}

