/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.columnChooser.gui;

import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractColumnChooserDialog
extends Dialog {
    protected ListenerList listeners = new ListenerList();
    private IDialogSettings dialogSettings;

    public AbstractColumnChooserDialog(Shell parent) {
        super(parent);
        this.setShellStyle(67696);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Messages.getString("AbstractColumnChooserDialog.doneButton"), true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        composite.setLayout((Layout)new GridLayout(1, true));
        composite.getShell().setText(Messages.getString("AbstractColumnChooserDialog.shellTitle"));
        composite.getShell().setImage(GUIHelper.getImage("preferences"));
        this.populateDialogArea(composite);
        Label separator = new Label(composite, 258);
        GridDataFactory.fillDefaults().grab(true, false).span(((GridLayout)composite.getLayout()).numColumns, 1).applyTo((Control)separator);
        return composite;
    }

    protected abstract void populateDialogArea(Composite var1);

    protected void createLabels(Composite parent, String availableStr, String selectedStr) {
        boolean availableSet = StringUtils.isNotEmpty((String)availableStr);
        boolean selectedSet = StringUtils.isNotEmpty((String)selectedStr);
        if (availableSet && selectedSet) {
            if (availableSet) {
                Label availableLabel = new Label(parent, 0);
                availableLabel.setText(availableStr);
                GridDataFactory.swtDefaults().applyTo((Control)availableLabel);
            }
            Label filler = new Label(parent, 0);
            GridDataFactory.swtDefaults().span(availableSet ? 1 : 2, 1).applyTo((Control)filler);
            if (selectedSet) {
                Label selectedLabel = new Label(parent, 0);
                selectedLabel.setText(selectedStr);
                GridDataFactory.swtDefaults().span(2, 1).applyTo((Control)selectedLabel);
            }
        }
    }

    public void addListener(Object listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Object listener) {
        this.listeners.remove(listener);
    }

    protected Point getInitialSize() {
        if (this.dialogSettings == null) {
            return new Point(500, 350);
        }
        Point initialSize = super.getInitialSize();
        return initialSize.x < 500 && initialSize.y < 350 ? new Point(500, 350) : initialSize;
    }

    public void setDialogSettings(IDialogSettings dialogSettings) {
        this.dialogSettings = dialogSettings;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return this.dialogSettings;
    }
}

