/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public class DocumentUtils {
    public static int findEndOfWhiteSpace(IDocument document, int offset, int end) throws BadLocationException {
        while (offset < end) {
            char c = document.getChar(offset);
            if (c != ' ' && c != '\t') {
                return offset;
            }
            ++offset;
        }
        return end;
    }

    public static IRegion getLineInformationOfOffset(IDocument document, int offset) throws BadLocationException {
        int p;
        int n = p = offset == document.getLength() ? offset - 1 : offset;
        if (p < 0) {
            p = 0;
        }
        IRegion info = document.getLineInformationOfOffset(p);
        return info;
    }

    public static String getStartingWhiteSpace(IDocument document, int offset, int end) throws BadLocationException {
        int whiteSpaceEnd = DocumentUtils.findEndOfWhiteSpace(document, offset, end);
        return whiteSpaceEnd > offset ? document.get(offset, whiteSpaceEnd - offset) : "";
    }
}

