/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.external.mcrl2;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpaceException;
import org.eclipse.emf.henshin.statespace.external.AbstractFileBasedValidator;
import org.eclipse.emf.henshin.statespace.util.ObjectKeyHelper;
import org.eclipse.emf.henshin.statespace.util.ParameterUtil;
import org.eclipse.emf.henshin.statespace.validation.ValidationResult;

public class MCRL2StateSpaceValidator
extends AbstractFileBasedValidator {
    public ValidationResult validate(StateSpace stateSpace, IProgressMonitor monitor) throws Exception {
        String line;
        monitor.beginTask("Validating property...", 10);
        String name = stateSpace.eResource().getURI().trimFileExtension().lastSegment();
        File aut = this.exportAsAUT(stateSpace, (IProgressMonitor)new SubProgressMonitor(monitor, 4));
        if (monitor.isCanceled()) {
            return null;
        }
        File min = File.createTempFile(name, ".aut");
        this.convertFile(aut, min, (IProgressMonitor)new SubProgressMonitor(monitor, 1), "ltsconvert", "--equivalence=bisim");
        if (monitor.isCanceled()) {
            return null;
        }
        String actions = this.createActions(stateSpace);
        System.out.println(String.valueOf(actions) + "\n");
        File act = this.createTempFile(name, ".mcrl2", actions);
        File lps = File.createTempFile(name, ".lps");
        this.convertFile(min, lps, (IProgressMonitor)new SubProgressMonitor(monitor, 1), "lts2lps", "--data=" + act.getAbsolutePath());
        if (monitor.isCanceled()) {
            return null;
        }
        File mcl = this.createTempFile("property", ".mcl", this.property);
        File pbes = File.createTempFile(name, ".pbes");
        this.convertFile(lps, pbes, (IProgressMonitor)new SubProgressMonitor(monitor, 2), "lps2pbes", "--formula=" + mcl.getAbsolutePath());
        if (monitor.isCanceled()) {
            return null;
        }
        monitor.subTask("Running pbes2bool...");
        String[] pbes2bool = new String[]{"pbes2bool", pbes.getAbsolutePath()};
        if (System.getProperty("os.name").startsWith("Linux")) {
            pbes2bool = new String[]{"bash", "-c", "ulimit -s unlimited; pbes2bool " + pbes.getAbsolutePath()};
        }
        Process process = Runtime.getRuntime().exec(pbes2bool);
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        Boolean result = null;
        while ((line = reader.readLine()) != null) {
            line = line.trim();
            System.out.println("pbes2bool:" + line);
            if (line.startsWith("The solution for the initial variable of the pbes is")) {
                if (line.endsWith("true")) {
                    result = Boolean.TRUE;
                    break;
                }
                if (line.endsWith("false")) {
                    result = Boolean.FALSE;
                    break;
                }
                throw new RuntimeException("pbes2bool produced unexpected output: " + line);
            }
            if (!monitor.isCanceled()) continue;
            process.destroy();
            return null;
        }
        process.waitFor();
        monitor.worked(1);
        min.delete();
        act.delete();
        lps.delete();
        mcl.delete();
        pbes.delete();
        monitor.worked(1);
        monitor.done();
        if (result == Boolean.TRUE) {
            return ValidationResult.VALID;
        }
        if (result == Boolean.FALSE) {
            return ValidationResult.INVALID;
        }
        throw new RuntimeException("pbes2bool produced no output.");
    }

    private String createActions(StateSpace stateSpace) throws StateSpaceException {
        StringBuffer actions = new StringBuffer();
        Map<EClass, EClass> superTypes = this.getSuperTypeMap(stateSpace);
        Map<EClass, Set<String>> superTypeParams = this.getUsedParameterNamesByType(stateSpace, superTypes);
        Map<EClass, Set<String>> basicTypeParams = this.getUsedParameterNamesByType(stateSpace, null);
        if (!stateSpace.getEqualityHelper().getIdentityTypes().isEmpty()) {
            for (Map.Entry<EClass, Set<String>> entry : superTypeParams.entrySet()) {
                actions.append("sort " + entry.getKey().getName() + " = struct ");
                Iterator<String> it = entry.getValue().iterator();
                while (it.hasNext()) {
                    actions.append(it.next());
                    if (!it.hasNext()) continue;
                    actions.append(" | ");
                }
                actions.append(";\n");
            }
        }
        actions.append("act ");
        int i = 0;
        while (i < stateSpace.getRules().size()) {
            Rule rule = (Rule)stateSpace.getRules().get(i);
            actions.append(rule.getName());
            if (!stateSpace.getEqualityHelper().getIdentityTypes().isEmpty()) {
                actions.append(" : ");
                List nodes = ParameterUtil.getParameters((StateSpace)stateSpace, (Rule)rule);
                int j = 0;
                while (j < nodes.size()) {
                    EClass type = superTypes.get(((Node)nodes.get(j)).getType());
                    actions.append(type.getName());
                    if (j < nodes.size() - 1) {
                        actions.append(" # ");
                    }
                    ++j;
                }
            }
            actions.append("; ");
            ++i;
        }
        actions.append("\n\n");
        int var = 1;
        if (!stateSpace.getEqualityHelper().getIdentityTypes().isEmpty()) {
            for (Map.Entry<EClass, Set<String>> entry : basicTypeParams.entrySet()) {
                String variable = "xyz" + var++;
                String superType = superTypes.get(entry.getKey()).getName();
                String function = "is" + entry.getKey().getName();
                actions.append("map " + function + " : " + superType + " -> Bool;\n");
                actions.append("var " + variable + " : " + superType + ";\n");
                Iterator<String> it = entry.getValue().iterator();
                actions.append("eqn " + function + "(" + variable + ") = ");
                if (it.hasNext()) {
                    while (it.hasNext()) {
                        actions.append("(" + variable + "==" + it.next() + ")");
                        if (!it.hasNext()) continue;
                        actions.append(" || ");
                    }
                } else {
                    actions.append("false");
                }
                actions.append(";\n\n");
            }
        }
        return actions.toString();
    }

    private Map<EClass, EClass> getSuperTypeMap(StateSpace stateSpace) throws StateSpaceException {
        LinkedHashSet<EClass> types = new LinkedHashSet<EClass>();
        types.addAll((Collection<EClass>)stateSpace.getEqualityHelper().getIdentityTypes());
        for (Rule rule : stateSpace.getRules()) {
            List params = ParameterUtil.getParameters((StateSpace)stateSpace, (Rule)rule);
            for (Node param : params) {
                types.add(param.getType());
            }
        }
        HashMap<EClass, EClass> superTypes = new HashMap<EClass, EClass>();
        for (EClass type : types) {
            superTypes.put(type, type);
        }
        for (Rule rule : stateSpace.getRules()) {
            List params = ParameterUtil.getParameters((StateSpace)stateSpace, (Rule)rule);
            for (Node param : params) {
                EClass superType2 = param.getType();
                for (EClass type : types) {
                    EClass superType1 = (EClass)superTypes.get(type);
                    if (superType1 == superType2 || !superType2.isSuperTypeOf(superType1)) continue;
                    superTypes.put(type, superType2);
                }
            }
        }
        return superTypes;
    }

    private Map<EClass, Set<String>> getUsedParameterNamesByType(StateSpace stateSpace, Map<EClass, EClass> superTypes) throws StateSpaceException {
        int[] params = stateSpace.getAllParameterKeys();
        EList types = stateSpace.getEqualityHelper().getIdentityTypes();
        HashMap<EClass, Set<String>> result = new HashMap<EClass, Set<String>>();
        int i = 0;
        while (i < params.length) {
            EClass type = ObjectKeyHelper.getObjectType((int)params[i], (EList)types);
            if (superTypes != null && superTypes.containsKey(type)) {
                type = superTypes.get(type);
            }
            String prefix = ObjectKeyHelper.getObjectTypePrefix((int)params[i]);
            int id = ObjectKeyHelper.getObjectID((int)params[i]);
            String name = String.valueOf(prefix) + id;
            LinkedHashSet<String> names = (LinkedHashSet<String>)result.get(type);
            if (names == null) {
                names = new LinkedHashSet<String>();
                result.put(type, names);
            }
            names.add(name);
            ++i;
        }
        return result;
    }

    public String getName() {
        return "mCRL2";
    }

    public boolean usesProperty() {
        return true;
    }
}

