/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.impl;

import java.util.HashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.statespace.EqualityHelper;
import org.eclipse.emf.henshin.statespace.Model;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpacePackage;
import org.eclipse.emf.henshin.statespace.hashcodes.StateSpaceHashCodeUtil;
import org.eclipse.emf.henshin.statespace.util.EcoreEqualityHelper;
import org.eclipse.emf.henshin.statespace.util.GraphEqualityChecker;

public class EqualityHelperImpl
extends MinimalEObjectImpl.Container
implements EqualityHelper {
    protected static final boolean CHECK_LINK_ORDER_EDEFAULT = false;
    protected boolean checkLinkOrder = false;
    protected EList<EAttribute> ignoredAttributes;
    protected EList<EClass> identityTypes;

    @Override
    public int hashCode(Model model) {
        return StateSpaceHashCodeUtil.computeHashCode(model, this);
    }

    @Override
    public void setStateSpace(StateSpace stateSpace) {
        String linkOrder = (String)stateSpace.getProperties().get((Object)"checkLinkOrder");
        this.checkLinkOrder = "true".equalsIgnoreCase(linkOrder) || "yes".equalsIgnoreCase(linkOrder);
        HashMap<String, EClass> allTypes = new HashMap<String, EClass>();
        HashMap<String, EAttribute> allAttrs = new HashMap<String, EAttribute>();
        for (Rule rule : stateSpace.getRules()) {
            for (EPackage pack : rule.getTransformationSystem().getImports()) {
                for (EClassifier type : pack.getEClassifiers()) {
                    if (!(type instanceof EClass)) continue;
                    allTypes.put(type.getName(), (EClass)type);
                    for (EAttribute att : ((EClass)type).getEAllAttributes()) {
                        allAttrs.put(String.valueOf(type.getName()) + "." + att.getName(), att);
                    }
                }
            }
        }
        this.getIdentityTypes().clear();
        String typeNames = (String)stateSpace.getProperties().get((Object)"identityTypes");
        if (typeNames != null) {
            String[] stringArray = typeNames.split(",");
            int n = stringArray.length;
            int pack = 0;
            while (pack < n) {
                String name = stringArray[pack];
                EClass type = (EClass)allTypes.get(name.trim());
                if (type != null) {
                    this.identityTypes.add((Object)type);
                }
                ++pack;
            }
        }
        this.getIgnoredAttributes().clear();
        String attrNames = (String)stateSpace.getProperties().get((Object)"ignoredAttributes");
        if (attrNames != null) {
            String[] stringArray = attrNames.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                EAttribute attr = (EAttribute)allAttrs.get(name.trim());
                if (attr != null) {
                    this.ignoredAttributes.add((Object)attr);
                }
                ++n2;
            }
        }
    }

    @Override
    public boolean equals(Model model1, Model model2) {
        if (model1 == null || model2 == null) {
            throw new NullPointerException();
        }
        if (this.checkLinkOrder) {
            return new EcoreEqualityHelper(this).equals(model1, model2);
        }
        return new GraphEqualityChecker(this).equals(model1, model2);
    }

    protected EqualityHelperImpl() {
    }

    protected EClass eStaticClass() {
        return StateSpacePackage.Literals.EQUALITY_HELPER;
    }

    @Override
    public boolean isCheckLinkOrder() {
        return this.checkLinkOrder;
    }

    @Override
    public EList<EAttribute> getIgnoredAttributes() {
        if (this.ignoredAttributes == null) {
            this.ignoredAttributes = new EObjectResolvingEList(EAttribute.class, (InternalEObject)this, 1);
        }
        return this.ignoredAttributes;
    }

    @Override
    public EList<EClass> getIdentityTypes() {
        if (this.identityTypes == null) {
            this.identityTypes = new EObjectResolvingEList(EClass.class, (InternalEObject)this, 2);
        }
        return this.identityTypes;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.isCheckLinkOrder();
            }
            case 1: {
                return this.getIgnoredAttributes();
            }
            case 2: {
                return this.getIdentityTypes();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.checkLinkOrder;
            }
            case 1: {
                return this.ignoredAttributes != null && !this.ignoredAttributes.isEmpty();
            }
            case 2: {
                return this.identityTypes != null && !this.identityTypes.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (checkLinkOrder: ");
        result.append(this.checkLinkOrder);
        result.append(')');
        return result.toString();
    }
}

