/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.testframework;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Engine;
import org.eclipse.emf.henshin.interpreter.Match;
import org.eclipse.emf.henshin.model.Rule;

public class Matches {
    public static void assertObjectContainedInAllMatches(Rule r, EGraph graph, Match partialMatch, Engine engine, EObject object) throws AssertionError {
        boolean foundMatch = false;
        for (Match match : engine.findMatches(r, graph, partialMatch)) {
            foundMatch = true;
            if (!match.getNodeTargets().contains(object)) {
                throw new AssertionError((Object)"expected: Object contained in every match, but it's not");
            }
        }
        if (!foundMatch) {
            throw new AssertionError((Object)"expected: Object contained in every match, but Rule produces no matches");
        }
    }

    public static void assertObjectContainedInNoMatch(Rule r, EGraph graph, Match partialMatch, Engine engine, EObject object) throws AssertionError {
        for (Match match : engine.findMatches(r, graph, partialMatch)) {
            if (match.getNodeTargets().contains(object)) {
                throw new AssertionError((Object)"expected: Object contained in no match, but contained in at least one");
            }
        }
    }

    public static void assertObjectContainedInNMatches(Rule r, EGraph graph, Match partialMatch, Engine engine, EObject object, int n) throws AssertionError {
        int num = 0;
        for (Match match : engine.findMatches(r, graph, partialMatch)) {
            if (!match.getNodeTargets().contains(object)) continue;
            ++num;
        }
        if (num != n) {
            throw new AssertionError((Object)("expected: Object contained in " + n + " matches, but contained in " + num));
        }
    }

    public static void assertObjectContainedInAtLeastOneMatch(Rule r, EGraph graph, Match partialMatch, Engine engine, EObject object) throws AssertionError {
        for (Match m : engine.findMatches(r, graph, partialMatch)) {
            if (!m.getNodeTargets().contains(object)) continue;
            return;
        }
        throw new AssertionError((Object)("expected: Object is contained in at least one match of " + r.getName() + ", but is contained in none"));
    }

    public static void assertNoObjectFromGroupContainedInAnyMatch(Rule r, EGraph graph, Match partialMatch, Engine engine, Collection<? extends EObject> group) throws AssertionError {
        for (Match m : engine.findMatches(r, graph, partialMatch)) {
            for (EObject eObject : group) {
                if (m.getNodeTargets().contains(eObject)) {
                    throw new AssertionError((Object)("expected: No object from group is contained in any match, but at least " + eObject + " is contained in at least one"));
                }
            }
        }
    }

    public static void assertGroupContainedInNoMatch(Rule r, EGraph graph, Match partialMatch, Engine engine, Collection<? extends EObject> group) throws AssertionError {
        for (Match m : engine.findMatches(r, graph, partialMatch)) {
            if (m.getNodeTargets().containsAll(group)) {
                throw new AssertionError((Object)"expected: Group is contained in no match, but is contained in at least one");
            }
        }
    }

    public static void assertGroupContainedInAtLeastOneMatch(Rule r, EGraph graph, Match partialMatch, Engine engine, Collection<? extends EObject> group) throws AssertionError {
        for (Match m : engine.findMatches(r, graph, partialMatch)) {
            if (!m.getNodeTargets().containsAll(group)) continue;
            return;
        }
        throw new AssertionError((Object)("expected: Group is contained in at least one match of " + r.getName() + ", but is contained in none"));
    }

    public static void assertAnyObjectFromGroupContainedInAtLeastOneMatch(Rule r, EGraph graph, Match partialMatch, Engine engine, Collection<? extends EObject> group) throws AssertionError {
        for (Match m : engine.findMatches(r, graph, partialMatch)) {
            for (EObject eObject : group) {
                if (!m.getNodeTargets().contains(eObject)) continue;
                return;
            }
        }
        throw new AssertionError((Object)"expected: At least one object from group is contained in at least one match, but isn't.");
    }

    public static void assertGroupIsMatched(Rule rule, EGraph graph, Match partialMatch, Engine engine, Collection<? extends EObject> group) throws AssertionError {
        HashMap<EObject, Boolean> matchContained = new HashMap<EObject, Boolean>();
        for (EObject eObject : group) {
            matchContained.put(eObject, false);
        }
        for (Match match : engine.findMatches(rule, graph, partialMatch)) {
            for (EObject eo2 : match.getNodeTargets()) {
                matchContained.put(eo2, true);
            }
        }
        if (matchContained.containsValue(false)) {
            System.out.println("~~~~~~");
            for (Map.Entry entry : matchContained.entrySet()) {
                if (((Boolean)entry.getValue()).booleanValue()) continue;
                System.out.println(entry.getKey() + " -> " + entry.getValue());
            }
            throw new AssertionError((Object)"expected: group is matched, but some elements aren't.");
        }
    }

    public static void assertOnlyGroupIsMatched(Rule rule, EGraph graph, Match partialMatch, Engine engine, Collection<? extends EObject> group) throws AssertionError {
        boolean injective = rule.isInjectiveMatching();
        Boolean inj = (Boolean)engine.getOptions().get("INJECTIVE_MATCHING");
        if (inj != null) {
            injective = inj;
        }
        if (!injective) {
            HashMap<EObject, Integer> matchContents = new HashMap<EObject, Integer>();
            for (EObject eObject : group) {
                if (matchContents.containsKey(eObject)) {
                    matchContents.put(eObject, (Integer)matchContents.get(eObject) + 1);
                    continue;
                }
                matchContents.put(eObject, 1);
            }
            for (Match match : engine.findMatches(rule, graph, partialMatch)) {
                for (EObject eo : match.getNodeTargets()) {
                    if (group.contains(eo)) {
                        matchContents.put(eo, (Integer)matchContents.get(eo) - 1);
                        continue;
                    }
                    throw new AssertionError((Object)"expected: entire group + only elements from group are matched, but match contains elements not in group");
                }
            }
            for (Integer n : matchContents.values()) {
                if (n != 0) {
                    throw new AssertionError((Object)"expected: group is matched, but some elements aren't.");
                }
            }
        } else {
            HashMap<EObject, Boolean> matchContents = new HashMap<EObject, Boolean>();
            for (EObject eObject : group) {
                matchContents.put(eObject, false);
            }
            for (Match match : engine.findMatches(rule, graph, partialMatch)) {
                for (EObject eo : match.getNodeTargets()) {
                    if (group.contains(eo)) {
                        matchContents.put(eo, true);
                        continue;
                    }
                    throw new AssertionError((Object)"expected: entire group + only elements from group are matched, but match contains elements not in group");
                }
            }
            if (matchContents.containsValue(false)) {
                throw new AssertionError((Object)"expected: group is matched, but some elements aren't.");
            }
        }
    }

    public static void assertMatchIsGroup(Match match, Collection<? extends EObject> group) throws AssertionError {
        HashMap<EObject, Integer> matchContents = new HashMap<EObject, Integer>();
        for (EObject eObject : group) {
            if (matchContents.containsKey(eObject)) {
                matchContents.put(eObject, (Integer)matchContents.get(eObject) + 1);
                continue;
            }
            matchContents.put(eObject, 1);
        }
        for (EObject eObject : match.getNodeTargets()) {
            if (group.contains(eObject)) {
                matchContents.put(eObject, (Integer)matchContents.get(eObject) - 1);
                continue;
            }
            throw new AssertionError((Object)"match contains elements not in group");
        }
        for (Integer n : matchContents.values()) {
            if (n != 0) {
                throw new AssertionError((Object)"expected: match is group, but some elements in the group are not in the match");
            }
        }
    }
}

