/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.testframework;

import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.metamodel.DifferenceKind;
import org.eclipse.emf.compare.diff.service.DiffService;
import org.eclipse.emf.compare.match.metamodel.MatchElement;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.compare.match.service.MatchService;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Engine;
import org.eclipse.emf.henshin.interpreter.InterpreterFactory;
import org.eclipse.emf.henshin.interpreter.RuleApplication;
import org.eclipse.emf.henshin.interpreter.UnitApplication;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.TransformationUnit;
import org.eclipse.emf.henshin.testframework.Graphs;
import org.eclipse.emf.henshin.testframework.Tools;

public class GraphTransformations {
    public static void assertNumberOfObjectsIdentical(Rule r, EGraph graph, Engine engine) throws AssertionError {
        RuleApplication ra = InterpreterFactory.INSTANCE.createRuleApplication(engine);
        ra.setRule(r);
        ra.setEGraph(graph);
        GraphTransformations.assertNumberOfObjectsIdentical((UnitApplication)ra);
    }

    public static void assertNumberOfObjectsIdentical(UnitApplication ua) throws AssertionError {
        int[] sizes = Tools.getGraphSizes(ua);
        if (sizes[0] != sizes[1]) {
            throw new AssertionError((Object)("expected: Number of elements before and after execution of " + ua.getUnit().getName() + " identical. Values: <" + sizes[0] + "> -> <" + sizes[1] + ">"));
        }
    }

    public static void assertNumberOfObjectsChanged(Rule r, EGraph graph, Engine engine) throws AssertionError {
        RuleApplication ra = InterpreterFactory.INSTANCE.createRuleApplication(engine);
        ra.setRule(r);
        ra.setEGraph(graph);
        GraphTransformations.assertNumberOfObjectsChanged((UnitApplication)ra);
    }

    public static void assertNumberOfObjectsChanged(TransformationUnit tu, EGraph graph, Engine engine) throws AssertionError {
        UnitApplication ua = InterpreterFactory.INSTANCE.createUnitApplication(engine);
        ua.setUnit(tu);
        ua.setEGraph(graph);
        GraphTransformations.assertNumberOfObjectsChanged(ua);
    }

    public static void assertNumberOfObjectsChanged(UnitApplication ua) throws AssertionError {
        int[] sizes = GraphTransformations.getGraphSizes(ua);
        if (sizes[0] == sizes[1]) {
            throw new AssertionError((Object)("expected: Number of elements before and after execution of " + ua.getUnit().getName() + " different. Values: <" + sizes[0] + "> -> <" + sizes[1] + ">"));
        }
    }

    public static void assertGraphIsNotChanged(Rule r, EGraph graph, Engine engine, double matchSimilarityThreshold) throws AssertionError {
        RuleApplication ra = InterpreterFactory.INSTANCE.createRuleApplication(engine);
        ra.setRule(r);
        ra.setEGraph(graph);
        GraphTransformations.assertGraphIsNotChanged((UnitApplication)ra, matchSimilarityThreshold);
    }

    public static void assertGraphIsNotChanged(TransformationUnit tu, EGraph graph, Engine engine, double matchSimilarityThreshold) throws AssertionError {
        UnitApplication ua = InterpreterFactory.INSTANCE.createUnitApplication(engine);
        ua.setUnit(tu);
        ua.setEGraph(graph);
        GraphTransformations.assertGraphIsNotChanged(ua, matchSimilarityThreshold);
    }

    public static void assertGraphIsNotChanged(UnitApplication ua, double matchSimilarityThreshold) throws AssertionError {
        MatchModel matchM;
        if (ua.getEGraph().getRoots().size() != 1) {
            throw new AssertionError((Object)"!!!! graphs with multiple root objects not supported yet.");
        }
        EGraph graph = ua.getEGraph();
        List rootObjects = graph.getRoots();
        EObject[] rootObjectArr = rootObjects.toArray(new EObject[1]);
        EObject rootCopy = EcoreUtil.copy((EObject)rootObjectArr[0]);
        EObject rootOrig = rootObjectArr[0];
        ua.execute(null);
        try {
            matchM = MatchService.doMatch((EObject)rootCopy, (EObject)rootOrig, null);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new AssertionError((Object)"!!!! execution interrupted.");
        }
        for (MatchElement ma : matchM.getMatchedElements()) {
            if (ma.getSimilarity() < matchSimilarityThreshold) {
                throw new AssertionError((Object)("Could not match graphs. Threshold exceeded: (" + ma.getSimilarity() + "), threshold " + matchSimilarityThreshold + ". Quite possibly, graph was changed."));
            }
        }
        DiffModel diffM = DiffService.doDiff((MatchModel)matchM);
        if (diffM.getDifferences().size() != 0) {
            throw new AssertionError((Object)("expected: Graph is not changed, but " + diffM.getDifferences().size() + " changes occured."));
        }
    }

    public static void assertTransformsGraph(Rule r, EGraph graph1, EGraph graph2, Engine engine, double matchSimilarityThreshold) throws AssertionError {
        RuleApplication ra = InterpreterFactory.INSTANCE.createRuleApplication(engine);
        ra.setRule(r);
        ra.setEGraph(graph1);
        GraphTransformations.assertTransformsGraph(ra, graph2, matchSimilarityThreshold);
    }

    public static void assertTransformsGraph(TransformationUnit tu, EGraph graph1, EGraph graph2, Engine engine, double matchSimilarityThreshold) throws AssertionError {
        UnitApplication ra = InterpreterFactory.INSTANCE.createUnitApplication(engine);
        ra.setUnit(tu);
        ra.setEGraph(graph1);
        GraphTransformations.assertTransformsGraph(ra, graph2, matchSimilarityThreshold);
    }

    public static void assertTransformsGraph(UnitApplication ua, EGraph graph2, double matchSimilarityThreshold) throws AssertionError {
        ua.execute(null);
        if (!GraphTransformations.graphsEqual(ua.getEGraph(), graph2, matchSimilarityThreshold)) {
            Tools.printGraph(ua.getEGraph());
            throw new AssertionError((Object)("expected: Execution of " + ua.getUnit().getName() + " transforms graph into specified graph, but doesn't."));
        }
    }

    public static void assertTransformsGraph(RuleApplication ra, EGraph graph2, double matchSimilarityThreshold) throws AssertionError {
        ra.execute(null);
        if (!GraphTransformations.graphsEqual(ra.getEGraph(), graph2, matchSimilarityThreshold)) {
            Tools.printGraph(ra.getEGraph());
            throw new AssertionError((Object)("expected: Execution of " + ra.getRule().getName() + " transforms graph into specified graph, but doesn't."));
        }
    }

    public static void assertNObjectsDeleted(Rule r, EGraph graph, Engine engine, int n) throws AssertionError {
        RuleApplication ra = InterpreterFactory.INSTANCE.createRuleApplication(engine);
        ra.setRule(r);
        ra.setEGraph(graph);
        GraphTransformations.assertNObjectsDeleted((UnitApplication)ra, n);
    }

    public static void assertNObjectsDeleted(TransformationUnit tu, EGraph graph, Engine engine, int n) throws AssertionError {
        UnitApplication ra = InterpreterFactory.INSTANCE.createUnitApplication(engine);
        ra.setUnit(tu);
        ra.setEGraph(graph);
        GraphTransformations.assertNObjectsDeleted(ra, n);
    }

    public static void assertNObjectsDeleted(UnitApplication ua, int n) throws AssertionError {
        MatchModel matchM;
        if (ua.getEGraph().getRoots().size() != 1) {
            throw new AssertionError((Object)"!!!! graphs with multiple root objects not supported yet.");
        }
        EGraph graph = ua.getEGraph();
        List rootObjects = graph.getRoots();
        EObject[] rootObjectArr = rootObjects.toArray(new EObject[1]);
        EObject rootCopy = EcoreUtil.copy((EObject)rootObjectArr[0]);
        EObject rootOrig = rootObjectArr[0];
        ua.execute(null);
        try {
            matchM = MatchService.doMatch((EObject)rootOrig, (EObject)rootCopy, null);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new AssertionError((Object)"!!!! execution interrupted.");
        }
        int dcount = 0;
        DiffModel diffM = DiffService.doDiff((MatchModel)matchM);
        for (DiffElement di : diffM.getDifferences()) {
            if (!di.getKind().equals((Object)DifferenceKind.DELETION)) continue;
            ++dcount;
        }
        if (dcount != n) {
            throw new AssertionError((Object)("expected: <" + n + "> elements deleted, but <" + dcount + "> elements were deleted."));
        }
    }

    public static void assertNObjectsCreated(Rule r, EGraph graph, Engine engine, int n) throws AssertionError {
        RuleApplication ra = InterpreterFactory.INSTANCE.createRuleApplication(engine);
        ra.setRule(r);
        ra.setEGraph(graph);
        GraphTransformations.assertNObjectsCreated((UnitApplication)ra, n);
    }

    public static void assertNObjectsCreated(TransformationUnit tu, EGraph graph, Engine engine, int n) throws AssertionError {
        UnitApplication ra = InterpreterFactory.INSTANCE.createUnitApplication(engine);
        ra.setUnit(tu);
        ra.setEGraph(graph);
        GraphTransformations.assertNObjectsCreated(ra, n);
    }

    public static void assertNObjectsCreated(UnitApplication ua, int n) throws AssertionError {
        MatchModel matchM;
        if (ua.getEGraph().getRoots().size() != 1) {
            throw new AssertionError((Object)"!!!! graphs with multiple root objects not supported yet.");
        }
        EGraph graph = ua.getEGraph();
        List rootObjects = graph.getRoots();
        EObject[] rootObjectArr = rootObjects.toArray(new EObject[1]);
        EObject rootCopy = EcoreUtil.copy((EObject)rootObjectArr[0]);
        EObject rootOrig = rootObjectArr[0];
        ua.execute(null);
        try {
            matchM = MatchService.doMatch((EObject)rootOrig, (EObject)rootCopy, null);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new AssertionError((Object)"!!!! execution interrupted.");
        }
        int ccount = 0;
        DiffModel diffM = DiffService.doDiff((MatchModel)matchM);
        for (DiffElement di : diffM.getDifferences()) {
            if (!di.getKind().equals((Object)DifferenceKind.ADDITION)) continue;
            ++ccount;
        }
        if (ccount != n) {
            throw new AssertionError((Object)("expected: <" + n + "> elements created, but <" + ccount + "> elements were created."));
        }
    }

    public static void assertTransformsSubgraph(TransformationUnit tu, EGraph graph, EGraph subgraphBefore, EGraph subgraphAfter, Engine engine, boolean ignoreChanges, double matchSimilarityThreshold) throws AssertionError {
        UnitApplication ra = InterpreterFactory.INSTANCE.createUnitApplication(engine);
        ra.setUnit(tu);
        ra.setEGraph(graph);
        GraphTransformations.assertTransformsSubgraph(ra, subgraphBefore, subgraphAfter, ignoreChanges, matchSimilarityThreshold);
    }

    public static void assertTransformsSubgraph(UnitApplication ua, EGraph subgraphBefore, EGraph subgraphAfter, boolean ignoreChanges, double matchSimilarityThreshold) throws AssertionError {
        MatchModel match2M;
        MatchModel matchM;
        EGraph mainGraph = ua.getEGraph();
        HashMap<String, Boolean> matchOptions = new HashMap<String, Boolean>();
        matchOptions.put("IGNORE_ID", true);
        matchOptions.put("IGNORE_XMI_ID", true);
        try {
            matchM = MatchService.doMatch((EObject)GraphTransformations.getGraphRoot(subgraphBefore), (EObject)GraphTransformations.getGraphRoot(mainGraph), matchOptions);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new AssertionError((Object)"interrupted.");
        }
        for (MatchElement ma : matchM.getMatchedElements()) {
            System.out.println(ma);
            if (ma.getSimilarity() < matchSimilarityThreshold) {
                throw new AssertionError((Object)"expected: UnitApplication transforms graph containing subgraphBefore to graph containing subgraphAfter, but graph can't be matched to subgraphBefore");
            }
        }
        DiffModel diffM = DiffService.doDiff((MatchModel)matchM, (boolean)true);
        for (DiffElement di : diffM.getDifferences()) {
            System.out.println(di);
        }
        if (!ua.execute(null)) {
            throw new AssertionError((Object)"expected: UnitApplication transforms graph containing subgraphBefore to graph containing subgraphAfter, but execution of UnitApplication failed.");
        }
        try {
            match2M = MatchService.doMatch((EObject)GraphTransformations.getGraphRoot(subgraphAfter), (EObject)GraphTransformations.getGraphRoot(mainGraph), null);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new AssertionError((Object)"interrupted.");
        }
        for (MatchElement me : match2M.getMatchedElements()) {
            if (me.getSimilarity() < matchSimilarityThreshold) {
                throw new AssertionError((Object)"expected: UnitApplication transforms graph containing subgraphBefore to graph containing subgraphAfter, but subgraphAfter could not be matched.");
            }
        }
        DiffModel diff2M = DiffService.doDiff((MatchModel)match2M);
        for (DiffElement di : diff2M.getDifferences()) {
            if (di.getKind().equals((Object)DifferenceKind.ADDITION)) {
                throw new AssertionError((Object)"expected: UnitApplication transforms graph containing subgraphBefore to graph containing subgraphAfter, but subgraphAfter contains elements not contained in UnitApplication's graph.");
            }
            if (!ignoreChanges && di.getKind().equals((Object)DifferenceKind.CHANGE)) {
                throw new AssertionError((Object)"expected: UnitApplication transforms graph containing subgraphBefore to graph containing subgraphAfter, but subgraphAfter contains elements with differing values from matched elements contained in UnitApplication's graph.");
            }
        }
    }

    private static int[] getGraphSizes(UnitApplication ua) {
        return Tools.getGraphSizes(ua);
    }

    private static boolean graphsEqual(EGraph graph1, EGraph graph2, double matchSimilarityThreshold) {
        return Graphs.graphsEqual(graph1, graph2, matchSimilarityThreshold);
    }

    private static EObject getGraphRoot(EGraph graph) {
        return Tools.getGraphRoot(graph);
    }
}

