/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.edit.parts;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.henshin.diagram.part.HenshinLinkUpdater;
import org.eclipse.emf.henshin.model.PriorityUnit;
import org.eclipse.emf.henshin.model.TransformationUnit;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITreeBranchEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ViewComponentEditPolicy;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;

public class LinkEditPart
extends ConnectionNodeEditPart
implements ITreeBranchEditPart {
    public static final int VISUAL_ID = 4002;
    private RotatableDecoration arrow;
    private Label label;

    public LinkEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ViewComponentEditPolicy());
        this.removeEditPolicy("SemanticPolicy");
    }

    private void updateArrow(LinkFigure figure) {
        if (figure != null) {
            TransformationUnit unit = this.getTransformationUnit();
            figure.setTargetDecoration(null);
            if (this.arrow != null) {
                if (figure.getChildren().contains(this.arrow)) {
                    figure.remove((IFigure)this.arrow);
                }
                this.arrow = null;
            }
            if (unit instanceof PriorityUnit) {
                this.arrow = this.createArrowDecoration(4, 7);
                figure.add((IFigure)this.arrow, (Object)new MiddleLocator((Connection)figure));
            } else {
                this.arrow = this.createArrowDecoration(7, 3);
                figure.setTargetDecoration(this.arrow);
            }
        }
    }

    private void updateLabel(LinkFigure figure) {
        if (figure != null) {
            if (this.label != null) {
                figure.remove((IFigure)this.label);
                this.label = null;
            }
            if (HenshinLinkUpdater.isIfLink(this.getTransformationUnit(), this.getNotationView())) {
                this.label = new Label("if");
                figure.add((IFigure)this.label, (Object)new LabelLocator((Connection)figure, 0, -10));
            } else if (HenshinLinkUpdater.isThenLink(this.getTransformationUnit(), this.getNotationView())) {
                this.label = new Label("then");
                figure.add((IFigure)this.label, (Object)new LabelLocator((Connection)figure, 10, -10));
            } else if (HenshinLinkUpdater.isElseLink(this.getTransformationUnit(), this.getNotationView())) {
                this.label = new Label("else");
                figure.add((IFigure)this.label, (Object)new LabelLocator((Connection)figure, 10, 10));
            }
        }
    }

    private TransformationUnit getTransformationUnit() {
        View sourceNode = ((Edge)this.getNotationView()).getSource();
        if (sourceNode == null) {
            return null;
        }
        View compartment = (View)sourceNode.eContainer();
        if (compartment == null) {
            return null;
        }
        View unitView = (View)compartment.eContainer();
        if (unitView == null) {
            return null;
        }
        if (unitView.getElement() instanceof TransformationUnit) {
            return (TransformationUnit)unitView.getElement();
        }
        return null;
    }

    private RotatableDecoration createArrowDecoration(int length, int width) {
        PolygonDecoration df = new PolygonDecoration();
        df.setFill(true);
        PointList pl = new PointList();
        pl.addPoint(this.getMapMode().DPtoLP(-1), this.getMapMode().DPtoLP(1));
        pl.addPoint(this.getMapMode().DPtoLP(0), this.getMapMode().DPtoLP(0));
        pl.addPoint(this.getMapMode().DPtoLP(-1), this.getMapMode().DPtoLP(-1));
        df.setTemplate(pl);
        df.setScale((double)this.getMapMode().DPtoLP(length), (double)this.getMapMode().DPtoLP(width));
        return df;
    }

    public Command getCommand(Request request) {
        Object type = request.getType();
        if ("delete".equals(type) || "Reconnection source".equals(type) || "Reconnection target".equals(type)) {
            return UnexecutableCommand.INSTANCE;
        }
        return super.getCommand(request);
    }

    protected Connection createConnectionFigure() {
        LinkFigure linkFigure = new LinkFigure();
        linkFigure.setTargetDecoration(null);
        this.updateArrow(linkFigure);
        this.updateLabel(linkFigure);
        return linkFigure;
    }

    public LinkFigure getPrimaryShape() {
        return (LinkFigure)this.getFigure();
    }

    private class LabelLocator
    extends ConnectionLocator {
        private int x;
        private int y;

        public LabelLocator(Connection connection, int x, int y) {
            super(connection);
            this.x = x;
            this.y = y;
        }

        protected Point getReferencePoint() {
            Connection connection = this.getConnection();
            Point p = connection.getPoints().getMidpoint();
            connection.translateToAbsolute((Translatable)p);
            p.x += this.x;
            p.y += this.y;
            return p;
        }
    }

    public class LinkFigure
    extends PolylineConnectionEx {
        public LinkFigure() {
            this.setForegroundColor(ColorConstants.black);
            this.setTargetDecoration(this.createTargetDecoration());
        }

        private RotatableDecoration createTargetDecoration() {
            PolygonDecoration df = new PolygonDecoration();
            df.setFill(true);
            PointList pl = new PointList();
            pl.addPoint(LinkEditPart.this.getMapMode().DPtoLP(-1), LinkEditPart.this.getMapMode().DPtoLP(1));
            pl.addPoint(LinkEditPart.this.getMapMode().DPtoLP(0), LinkEditPart.this.getMapMode().DPtoLP(0));
            pl.addPoint(LinkEditPart.this.getMapMode().DPtoLP(-1), LinkEditPart.this.getMapMode().DPtoLP(-1));
            df.setTemplate(pl);
            df.setScale((double)LinkEditPart.this.getMapMode().DPtoLP(7), (double)LinkEditPart.this.getMapMode().DPtoLP(3));
            return df;
        }
    }

    private class MiddleLocator
    extends ConnectionLocator {
        public MiddleLocator(Connection connection) {
            super(connection);
        }

        public void relocate(IFigure target) {
            PointList points = this.getConnection().getPoints();
            RotatableDecoration box = (RotatableDecoration)target;
            box.setLocation(this.getLocation(points));
            int midPoint = points.size() / 2;
            box.setReferencePoint(points.getPoint(midPoint - 1));
        }
    }
}

